/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.paging.PagedListResponse;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class SettingsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void retrySettingsMerge() {
        RetrySettings.Builder builder = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ofMillis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L));
        RetrySettings.Builder mergedBuilder = RetrySettings.newBuilder();
        mergedBuilder.merge(builder);
        RetrySettings settingsA = builder.build();
        RetrySettings settingsB = mergedBuilder.build();
        Truth.assertThat((Comparable)settingsA.getTotalTimeout()).isEqualTo((Object)settingsB.getTotalTimeout());
        Truth.assertThat((Comparable)settingsA.getInitialRetryDelay()).isEqualTo((Object)settingsB.getInitialRetryDelay());
        Truth.assertThat((Double)settingsA.getRpcTimeoutMultiplier()).isWithin(0.0).of(settingsB.getRpcTimeoutMultiplier());
        Truth.assertThat((Comparable)settingsA.getMaxRpcTimeout()).isEqualTo((Object)settingsB.getMaxRpcTimeout());
        Truth.assertThat((Comparable)settingsA.getInitialRetryDelay()).isEqualTo((Object)settingsB.getInitialRetryDelay());
        Truth.assertThat((Double)settingsA.getRetryDelayMultiplier()).isWithin(0.0).of(settingsB.getRetryDelayMultiplier());
        Truth.assertThat((Comparable)settingsA.getMaxRetryDelay()).isEqualTo((Object)settingsB.getMaxRetryDelay());
    }

    @Test
    public void customCredentials() throws IOException {
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeStubSettings settings = ((FakeStubSettings.Builder)FakeStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
        TransportChannelProvider actualChannelProvider = settings.getTransportChannelProvider();
        Truth.assertThat((Object)actualChannelProvider).isInstanceOf(InstantiatingGrpcChannelProvider.class);
        InstantiatingGrpcChannelProvider actualInstChPr = (InstantiatingGrpcChannelProvider)actualChannelProvider;
        Truth.assertThat((String)actualInstChPr.getEndpoint()).isEqualTo((Object)"pubsub-experimental.googleapis.com:443");
        Truth.assertThat((Object)settings.getCredentialsProvider().getCredentials()).isSameAs((Object)credentials);
    }

    @Test
    public void channelCustomCredentialScopes() throws IOException {
        ImmutableList inputScopes = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/fakeservice").build();
        GoogleCredentialsProvider credentialsProvider = FakeStubSettings.defaultCredentialsProviderBuilder().setScopesToApply((List)inputScopes).build();
        FakeStubSettings settings = ((FakeStubSettings.Builder)FakeStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).build();
        TransportChannelProvider actualChannelProvider = settings.getTransportChannelProvider();
        Truth.assertThat((Object)actualChannelProvider).isInstanceOf(InstantiatingGrpcChannelProvider.class);
        InstantiatingGrpcChannelProvider actualInstChPr = (InstantiatingGrpcChannelProvider)actualChannelProvider;
        Truth.assertThat((String)actualInstChPr.getEndpoint()).isEqualTo((Object)"pubsub-experimental.googleapis.com:443");
        CredentialsProvider actualCredentialsProvider = settings.getCredentialsProvider();
        Truth.assertThat((Object)actualCredentialsProvider).isInstanceOf(GoogleCredentialsProvider.class);
        GoogleCredentialsProvider googCredProv = (GoogleCredentialsProvider)actualCredentialsProvider;
        Truth.assertThat((Iterable)googCredProv.getScopesToApply()).isEqualTo((Object)inputScopes);
    }

    @Test
    public void callSettingsToBuilder() throws IOException {
        FakeSettings.Builder builderA = FakeSettings.Builder.createDefault();
        FakeSettings settingsA = builderA.build();
        FakeSettings.Builder builderB = settingsA.toBuilder();
        FakeSettings settingsB = builderB.build();
        SettingsTest.assertIsReflectionEqual(builderA, builderB);
        SettingsTest.assertIsReflectionEqual(settingsA, settingsB);
    }

    @Test
    public void callSettingsTimeoutNoRetries() throws IOException {
        Duration timeout = Duration.ofMillis((long)60000L);
        FakeSettings.Builder builderA = FakeSettings.Builder.createDefault();
        builderA.fakeMethodSimple().setSimpleTimeoutNoRetries(timeout);
        FakeSettings settingsA = builderA.build();
        FakeSettings.Builder builderB = FakeSettings.Builder.createDefault();
        builderB.fakeMethodSimple().setRetryableCodes(new StatusCode.Code[0]).setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(timeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setInitialRpcTimeout(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(timeout).setMaxAttempts(1).build());
        FakeSettings settingsB = builderB.build();
        SettingsTest.assertIsReflectionEqual(builderA, builderB);
        SettingsTest.assertIsReflectionEqual(settingsA, settingsB);
    }

    @Test
    public void unaryCallSettingsBuilderBuildDoesNotFailUnsetProperties() throws IOException {
        UnaryCallSettings.Builder builder = UnaryCallSettings.newUnaryCallSettingsBuilder();
        builder.build();
    }

    @Test
    public void callSettingsBuildFromTimeoutNoRetries() throws IOException {
        Duration timeout = Duration.ofMillis((long)60000L);
        UnaryCallSettings.Builder builderA = UnaryCallSettings.newUnaryCallSettingsBuilder();
        builderA.setSimpleTimeoutNoRetries(timeout);
        UnaryCallSettings settingsA = builderA.build();
        UnaryCallSettings.Builder builderB = UnaryCallSettings.newUnaryCallSettingsBuilder();
        builderB.setRetryableCodes(new StatusCode.Code[0]).setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(timeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setInitialRpcTimeout(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(timeout).setMaxAttempts(1).build());
        UnaryCallSettings settingsB = builderB.build();
        SettingsTest.assertIsReflectionEqual(builderA, builderB);
        SettingsTest.assertIsReflectionEqual(settingsA, settingsB);
    }

    private static void assertIsReflectionEqual(Object objA, Object objB, String[] excludes) {
        Truth.assertThat((Boolean)EqualsBuilder.reflectionEquals((Object)objA, (Object)objB, (String[])excludes)).isTrue();
    }

    private static void assertIsReflectionEqual(Object objA, Object objB) {
        SettingsTest.assertIsReflectionEqual(objA, objB, null);
    }

    private static void assertIsReflectionEqual(FakeSettings settingsA, FakeSettings settingsB) {
        SettingsTest.assertIsReflectionEqual((Object)settingsA, (Object)settingsB, new String[]{"fakeMethodSimple", "fakePagedMethod", "fakeMethodBatching", "stubSettings"});
        SettingsTest.assertIsReflectionEqual(settingsA.fakeMethodSimple(), settingsB.fakeMethodSimple());
        SettingsTest.assertIsReflectionEqual(settingsA.fakePagedMethod(), settingsB.fakePagedMethod());
        SettingsTest.assertIsReflectionEqual(settingsA.fakeMethodBatching(), settingsB.fakeMethodBatching());
        SettingsTest.assertIsReflectionEqual(settingsA.getStubSettings(), settingsB.getStubSettings(), new String[]{"fakeMethodSimple", "fakePagedMethod", "fakeMethodBatching", "executorProvider", "credentialsProvider", "headerProvider", "internalHeaderProvider", "transportChannelProvider", "streamWatchdogProvider"});
        SettingsTest.assertIsReflectionEqual(settingsA.getExecutorProvider(), settingsB.getExecutorProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getCredentialsProvider(), settingsB.getCredentialsProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getTransportChannelProvider(), settingsB.getTransportChannelProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getHeaderProvider(), settingsB.getHeaderProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getStubSettings().getExecutorProvider(), settingsB.getStubSettings().getExecutorProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getStubSettings().getCredentialsProvider(), settingsB.getStubSettings().getCredentialsProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getStubSettings().getTransportChannelProvider(), settingsB.getStubSettings().getTransportChannelProvider());
        SettingsTest.assertIsReflectionEqual(settingsA.getStubSettings().getHeaderProvider(), settingsB.getStubSettings().getHeaderProvider());
    }

    private static void assertIsReflectionEqual(FakeSettings.Builder builderA, FakeSettings.Builder builderB) {
        SettingsTest.assertIsReflectionEqual((Object)builderA, (Object)builderB, new String[]{"fakeMethodSimple", "fakePagedMethod", "fakeMethodBatching", "stubSettings"});
        SettingsTest.assertIsReflectionEqual(builderA.fakeMethodSimple(), builderB.fakeMethodSimple());
        SettingsTest.assertIsReflectionEqual(builderA.fakePagedMethod(), builderB.fakePagedMethod());
        SettingsTest.assertIsReflectionEqual(builderA.fakeMethodBatching(), builderB.fakeMethodBatching());
        SettingsTest.assertIsReflectionEqual(builderA.getExecutorProvider(), builderB.getExecutorProvider());
        SettingsTest.assertIsReflectionEqual(builderA.getCredentialsProvider(), builderB.getCredentialsProvider());
        SettingsTest.assertIsReflectionEqual(builderA.getTransportChannelProvider(), builderB.getTransportChannelProvider());
    }

    private static void assertIsReflectionEqual(UnaryCallSettings.Builder<?, ?> builderA, UnaryCallSettings.Builder<?, ?> builderB) {
        SettingsTest.assertIsReflectionEqual(builderA, builderB, new String[]{"retrySettings"});
        SettingsTest.assertIsReflectionEqual(builderA.getRetrySettings(), builderB.getRetrySettings());
    }

    private static <RequestT, ResponseT> void assertIsReflectionEqual(BatchingCallSettings<RequestT, ResponseT> settingsA, BatchingCallSettings<RequestT, ResponseT> settingsB) {
        SettingsTest.assertIsReflectionEqual(settingsA, settingsB, new String[]{"retrySettings", "batchingDescriptor", "batchingSettings", "flowController"});
        SettingsTest.assertIsReflectionEqual(settingsA.getRetrySettings(), settingsA.getRetrySettings());
        SettingsTest.assertIsReflectionEqual(settingsB.getBatchingSettings(), settingsB.getBatchingSettings());
    }

    private static <RequestT, ResponseT> void assertIsReflectionEqual(BatchingCallSettings.Builder<RequestT, ResponseT> builderA, BatchingCallSettings.Builder<RequestT, ResponseT> builderB) {
        SettingsTest.assertIsReflectionEqual(builderA, builderB, new String[]{"retrySettings", "batchingDescriptor", "batchingSettings", "flowController"});
        SettingsTest.assertIsReflectionEqual(builderA.getRetrySettings(), builderB.getRetrySettings());
        SettingsTest.assertIsReflectionEqual(builderA.getBatchingSettings(), builderB.getBatchingSettings());
    }

    private static class FakeSettings
    extends ClientSettings {
        public UnaryCallSettings<Integer, Integer> fakeMethodSimple() {
            return ((FakeStubSettings)this.getStubSettings()).fakeMethodSimple();
        }

        public PagedCallSettings<Integer, Integer, FakePagedListResponse> fakePagedMethod() {
            return ((FakeStubSettings)this.getStubSettings()).fakePagedMethod();
        }

        public BatchingCallSettings<Integer, Integer> fakeMethodBatching() {
            return ((FakeStubSettings)this.getStubSettings()).fakeMethodBatching();
        }

        public static Builder newBuilder() {
            return Builder.createDefault();
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private FakeSettings(Builder settingsBuilder) throws IOException {
            super((ClientSettings.Builder)settingsBuilder);
        }

        private static class Builder
        extends ClientSettings.Builder {
            protected Builder() throws IOException {
                this((ClientContext)null);
            }

            protected Builder(ClientContext clientContext) {
                super((StubSettings.Builder)FakeStubSettings.newBuilder(clientContext));
            }

            private static Builder createDefault() {
                return new Builder(FakeStubSettings.newBuilder());
            }

            protected Builder(FakeSettings settings) {
                super(settings.getStubSettings().toBuilder());
            }

            protected Builder(FakeStubSettings.Builder stubSettings) {
                super((StubSettings.Builder)stubSettings);
            }

            public FakeStubSettings.Builder getStubSettingsBuilder() {
                return (FakeStubSettings.Builder)this.getStubSettings();
            }

            public UnaryCallSettings.Builder<Integer, Integer> fakeMethodSimple() {
                return this.getStubSettingsBuilder().fakeMethodSimple();
            }

            public PagedCallSettings.Builder<Integer, Integer, FakePagedListResponse> fakePagedMethod() {
                return this.getStubSettingsBuilder().fakePagedMethod();
            }

            public BatchingCallSettings.Builder<Integer, Integer> fakeMethodBatching() {
                return this.getStubSettingsBuilder().fakeMethodBatching();
            }

            public FakeSettings build() throws IOException {
                return new FakeSettings(this);
            }
        }
    }

    private static class FakeStubSettings
    extends StubSettings<FakeStubSettings> {
        private static final PagedListResponseFactory<Integer, Integer, FakePagedListResponse> fakePagedListResponseFactory = (PagedListResponseFactory)Mockito.mock(PagedListResponseFactory.class);
        private static final BatchingDescriptor<Integer, Integer> FAKE_BATCHING_DESCRIPTOR = (BatchingDescriptor)Mockito.mock(BatchingDescriptor.class);
        private static final String DEFAULT_GAPIC_NAME = "gapic";
        public static final String DEFAULT_SERVICE_ADDRESS = "pubsub-experimental.googleapis.com";
        public static final int DEFAULT_SERVICE_PORT = 443;
        public static final String DEFAULT_SERVICE_ENDPOINT = "pubsub-experimental.googleapis.com:443";
        public static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/pubsub").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;
        private final UnaryCallSettings<Integer, Integer> fakeMethodSimple;
        private final PagedCallSettings<Integer, Integer, FakePagedListResponse> fakePagedMethod;
        private final BatchingCallSettings<Integer, Integer> fakeMethodBatching;

        public UnaryCallSettings<Integer, Integer> fakeMethodSimple() {
            return this.fakeMethodSimple;
        }

        public PagedCallSettings<Integer, Integer, FakePagedListResponse> fakePagedMethod() {
            return this.fakePagedMethod;
        }

        public BatchingCallSettings<Integer, Integer> fakeMethodBatching() {
            return this.fakeMethodBatching;
        }

        public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
            return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
        }

        public static InstantiatingGrpcChannelProvider.Builder defaultChannelProviderBuilder() {
            return InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(DEFAULT_SERVICE_ENDPOINT);
        }

        public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
            return InstantiatingExecutorProvider.newBuilder();
        }

        public static InstantiatingGrpcChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
            return InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(DEFAULT_SERVICE_ENDPOINT);
        }

        public static ApiClientHeaderProvider.Builder defaultGoogleServiceHeaderProviderBuilder() {
            return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken(DEFAULT_GAPIC_NAME, "0.10.0").setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
        }

        public static TransportChannelProvider defaultTransportChannelProvider() {
            return FakeStubSettings.defaultGrpcChannelProviderBuilder().build();
        }

        public static Builder newBuilder() {
            return Builder.createDefault();
        }

        public static Builder newBuilder(ClientContext clientContext) {
            return new Builder(clientContext);
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private FakeStubSettings(Builder settingsBuilder) throws IOException {
            super((StubSettings.Builder)settingsBuilder);
            this.fakeMethodSimple = settingsBuilder.fakeMethodSimple().build();
            this.fakePagedMethod = settingsBuilder.fakePagedMethod().build();
            this.fakeMethodBatching = settingsBuilder.fakeMethodBatching().build();
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }

        private static class Builder
        extends StubSettings.Builder<FakeStubSettings, Builder> {
            private UnaryCallSettings.Builder<Integer, Integer> fakeMethodSimple;
            private PagedCallSettings.Builder<Integer, Integer, FakePagedListResponse> fakePagedMethod;
            private BatchingCallSettings.Builder<Integer, Integer> fakeMethodBatching;

            private Builder() {
                super((ClientContext)null);
                this.fakeMethodSimple = UnaryCallSettings.newUnaryCallSettingsBuilder();
                this.fakePagedMethod = PagedCallSettings.newBuilder((PagedListResponseFactory)fakePagedListResponseFactory);
                this.fakeMethodBatching = BatchingCallSettings.newBuilder((BatchingDescriptor)FAKE_BATCHING_DESCRIPTOR).setBatchingSettings(BatchingSettings.newBuilder().build());
            }

            private static Builder createDefault() {
                Builder builder = new Builder();
                builder.setTransportChannelProvider(FakeStubSettings.defaultTransportChannelProvider());
                builder.setExecutorProvider((ExecutorProvider)FakeStubSettings.defaultExecutorProviderBuilder().build());
                builder.setCredentialsProvider((CredentialsProvider)FakeStubSettings.defaultCredentialsProviderBuilder().build());
                builder.setHeaderProvider((HeaderProvider)new NoHeaderProvider());
                builder.setInternalHeaderProvider((HeaderProvider)FakeStubSettings.defaultGoogleServiceHeaderProviderBuilder().build());
                builder.setStreamWatchdogProvider(FixedWatchdogProvider.create(null));
                builder.fakeMethodSimple().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
                builder.fakePagedMethod().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
                builder.fakeMethodBatching().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(800L)).setRequestByteThreshold(Long.valueOf(0x800000L)).setDelayThreshold(Duration.ofMillis((long)100L)).build());
                builder.fakeMethodBatching().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
                return builder;
            }

            protected Builder(ClientContext clientContext) {
                super(clientContext);
            }

            private Builder(FakeStubSettings settings) {
                super((StubSettings)settings);
                this.fakeMethodSimple = settings.fakeMethodSimple().toBuilder();
                this.fakePagedMethod = settings.fakePagedMethod().toBuilder();
                this.fakeMethodBatching = settings.fakeMethodBatching().toBuilder();
            }

            public FakeStubSettings build() throws IOException {
                return new FakeStubSettings(this);
            }

            public UnaryCallSettings.Builder<Integer, Integer> fakeMethodSimple() {
                return this.fakeMethodSimple;
            }

            public PagedCallSettings.Builder<Integer, Integer, FakePagedListResponse> fakePagedMethod() {
                return this.fakePagedMethod;
            }

            public BatchingCallSettings.Builder<Integer, Integer> fakeMethodBatching() {
                return this.fakeMethodBatching;
            }
        }
    }

    static interface FakePagedListResponse
    extends PagedListResponse<Integer> {
    }
}

