/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class InstantiatingGrpcChannelProviderTest {
    @Test
    public void testEndpoint() {
        String endpoint = "localhost:8080";
        InstantiatingGrpcChannelProvider.Builder builder = InstantiatingGrpcChannelProvider.newBuilder();
        builder.setEndpoint(endpoint);
        Assert.assertEquals((Object)builder.getEndpoint(), (Object)endpoint);
        InstantiatingGrpcChannelProvider provider = builder.build();
        Assert.assertEquals((Object)provider.getEndpoint(), (Object)endpoint);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEndpointNoPort() {
        InstantiatingGrpcChannelProvider.newBuilder().setEndpoint("localhost");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEndpointBadPort() {
        InstantiatingGrpcChannelProvider.newBuilder().setEndpoint("localhost:abcd");
    }

    @Test
    public void testKeepAlive() {
        Duration keepaliveTime = Duration.ofSeconds((long)1L);
        Duration keepaliveTimeout = Duration.ofSeconds((long)2L);
        boolean keepaliveWithoutCalls = true;
        InstantiatingGrpcChannelProvider provider = InstantiatingGrpcChannelProvider.newBuilder().setKeepAliveTime(keepaliveTime).setKeepAliveTimeout(keepaliveTimeout).setKeepAliveWithoutCalls(Boolean.valueOf(keepaliveWithoutCalls)).build();
        Assert.assertEquals((Object)provider.getKeepAliveTime(), (Object)keepaliveTime);
        Assert.assertEquals((Object)provider.getKeepAliveTimeout(), (Object)keepaliveTimeout);
        Assert.assertEquals((Object)provider.getKeepAliveWithoutCalls(), (Object)keepaliveWithoutCalls);
    }

    @Test
    public void testMaxInboundMetadataSize() {
        InstantiatingGrpcChannelProvider provider = InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMetadataSize(Integer.valueOf(4096)).build();
        Truth.assertThat((Integer)provider.getMaxInboundMetadataSize()).isEqualTo((Object)4096);
    }

    @Test
    public void testCpuPoolSize() {
        InstantiatingGrpcChannelProvider.Builder builder = InstantiatingGrpcChannelProvider.newBuilder().setProcessorCount(2);
        builder.setChannelsPerCpu(2.5);
        Assert.assertEquals((long)5L, (long)builder.getPoolSize());
        builder = builder.setProcessorCount(50);
        builder.setChannelsPerCpu(100.0, 10);
        Assert.assertEquals((long)10L, (long)builder.getPoolSize());
        builder.setChannelsPerCpu(200.0);
        Assert.assertEquals((long)100L, (long)builder.getPoolSize());
    }

    @Test
    public void testWithPoolSize() throws IOException {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.shutdown();
        TransportChannelProvider provider = InstantiatingGrpcChannelProvider.newBuilder().build().withExecutor((ScheduledExecutorService)executor).withHeaders(Collections.emptyMap()).withEndpoint("localhost:8080");
        Truth.assertThat((Boolean)provider.acceptsPoolSize()).isTrue();
        provider.getTransportChannel().shutdownNow();
        provider = provider.withPoolSize(2);
        Truth.assertThat((Boolean)provider.acceptsPoolSize()).isFalse();
        provider.getTransportChannel().shutdownNow();
        try {
            provider.withPoolSize(3);
            Assert.fail((String)"acceptsPoolSize() returned false; we shouldn't be able to set it again");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testWithInterceptors() throws Exception {
        this.testWithInterceptors(1);
    }

    @Test
    public void testWithInterceptorsAndMultipleChannels() throws Exception {
        this.testWithInterceptors(5);
    }

    private void testWithInterceptors(int numChannels) throws Exception {
        GrpcInterceptorProvider interceptorProvider = (GrpcInterceptorProvider)Mockito.mock(GrpcInterceptorProvider.class);
        InstantiatingGrpcChannelProvider channelProvider = InstantiatingGrpcChannelProvider.newBuilder().setEndpoint("localhost:8080").setPoolSize(numChannels).setHeaderProvider((HeaderProvider)Mockito.mock(HeaderProvider.class)).setExecutorProvider((ExecutorProvider)Mockito.mock(ExecutorProvider.class)).setInterceptorProvider(interceptorProvider).build();
        ((GrpcInterceptorProvider)Mockito.verify((Object)interceptorProvider, (VerificationMode)Mockito.never())).getInterceptors();
        channelProvider.getTransportChannel().shutdownNow();
        ((GrpcInterceptorProvider)Mockito.verify((Object)interceptorProvider, (VerificationMode)Mockito.times((int)numChannels))).getInterceptors();
    }
}

