/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcApiExceptionFactory;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import java.util.Set;
import java.util.concurrent.CancellationException;

class GrpcExceptionServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> inner;
    private final GrpcApiExceptionFactory exceptionFactory;

    public GrpcExceptionServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> inner, Set<StatusCode.Code> retryableCodes) {
        this.inner = inner;
        this.exceptionFactory = new GrpcApiExceptionFactory(retryableCodes);
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        this.inner.call(request, (ResponseObserver)new ExceptionResponseObserver(responseObserver), context);
    }

    private class ExceptionResponseObserver
    extends StateCheckingResponseObserver<ResponseT> {
        private ResponseObserver<ResponseT> innerObserver;
        private volatile CancellationException cancellationException;

        public ExceptionResponseObserver(ResponseObserver<ResponseT> innerObserver) {
            this.innerObserver = innerObserver;
        }

        protected void onStartImpl(final StreamController controller) {
            this.innerObserver.onStart(new StreamController(){

                public void cancel() {
                    ExceptionResponseObserver.this.cancellationException = new CancellationException("User cancelled stream");
                    controller.cancel();
                }

                public void disableAutoInboundFlowControl() {
                    controller.disableAutoInboundFlowControl();
                }

                public void request(int count) {
                    controller.request(count);
                }
            });
        }

        protected void onResponseImpl(ResponseT response) {
            this.innerObserver.onResponse(response);
        }

        protected void onErrorImpl(Throwable t) {
            t = this.cancellationException != null ? this.cancellationException : GrpcExceptionServerStreamingCallable.this.exceptionFactory.create(t);
            this.innerObserver.onError(t);
        }

        protected void onCompleteImpl() {
            this.innerObserver.onComplete();
        }
    }
}

