/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import java.util.Objects;

@InternalExtensionOnly
public class GrpcStatusCode
implements StatusCode {
    private final Status.Code grpcCode;
    private final StatusCode.Code statusCode;

    public static GrpcStatusCode of(Status.Code grpcCode) {
        return new GrpcStatusCode(grpcCode, GrpcStatusCode.grpcCodeToStatusCode(grpcCode));
    }

    static StatusCode.Code grpcCodeToStatusCode(Status.Code code) {
        switch (code) {
            case OK: {
                return StatusCode.Code.OK;
            }
            case CANCELLED: {
                return StatusCode.Code.CANCELLED;
            }
            case UNKNOWN: {
                return StatusCode.Code.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return StatusCode.Code.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return StatusCode.Code.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return StatusCode.Code.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return StatusCode.Code.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return StatusCode.Code.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return StatusCode.Code.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return StatusCode.Code.FAILED_PRECONDITION;
            }
            case ABORTED: {
                return StatusCode.Code.ABORTED;
            }
            case OUT_OF_RANGE: {
                return StatusCode.Code.OUT_OF_RANGE;
            }
            case UNIMPLEMENTED: {
                return StatusCode.Code.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return StatusCode.Code.INTERNAL;
            }
            case UNAVAILABLE: {
                return StatusCode.Code.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return StatusCode.Code.DATA_LOSS;
            }
            case UNAUTHENTICATED: {
                return StatusCode.Code.UNAUTHENTICATED;
            }
        }
        throw new IllegalStateException("Unrecognized status code: " + code);
    }

    public StatusCode.Code getCode() {
        return this.statusCode;
    }

    public Status.Code getTransportCode() {
        return this.grpcCode;
    }

    private GrpcStatusCode(Status.Code grpcCode, StatusCode.Code statusCode) {
        this.grpcCode = (Status.Code)Preconditions.checkNotNull((Object)grpcCode);
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcStatusCode that = (GrpcStatusCode)o;
        return Objects.equals(this.grpcCode, that.grpcCode);
    }

    public int hashCode() {
        return this.grpcCode.hashCode();
    }
}

