/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

@BetaApi
public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    private final ExecutorProvider executorProvider;
    private final HeaderProvider headerProvider;
    private final String serviceAddress;
    private final int port;
    @Nullable
    private final Integer maxInboundMessageSize;

    private InstantiatingGrpcChannelProvider(ExecutorProvider executorProvider, HeaderProvider headerProvider, String serviceAddress, int port, Integer maxInboundMessageSize) {
        this.executorProvider = executorProvider;
        this.headerProvider = headerProvider;
        this.serviceAddress = serviceAddress;
        this.port = port;
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.toBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)executor)).build();
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getTransportChannel() called when needsExecutor() is true");
        }
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        ScheduledExecutorService executor = this.executorProvider.getExecutor();
        Map headers = this.headerProvider.getHeaders();
        ArrayList<GrpcHeaderInterceptor> interceptors = new ArrayList<GrpcHeaderInterceptor>();
        interceptors.add(new GrpcHeaderInterceptor(headers));
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)this.serviceAddress, (int)this.port).intercept(interceptors).executor((Executor)executor);
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        return GrpcTransportChannel.newBuilder().setManagedChannel(builder.build()).build();
    }

    public String getEndpoint() {
        return this.serviceAddress + ':' + this.port;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ExecutorProvider executorProvider;
        private HeaderProvider headerProvider;
        private String serviceAddress;
        private int port;
        private Integer maxInboundMessageSize;

        private Builder() {
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.executorProvider = provider.executorProvider;
            this.headerProvider = provider.headerProvider;
            this.serviceAddress = provider.serviceAddress;
            this.port = provider.port;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            int colon = endpoint.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
            }
            this.port = Integer.parseInt(endpoint.substring(colon + 1));
            this.serviceAddress = endpoint.substring(0, colon);
            return this;
        }

        public String getEndpoint() {
            return this.serviceAddress + ':' + this.port;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public InstantiatingGrpcChannelProvider build() {
            return new InstantiatingGrpcChannelProvider(this.executorProvider, this.headerProvider, this.serviceAddress, this.port, this.maxInboundMessageSize);
        }
    }
}

