/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.auth.MoreCallCredentials;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.threeten.bp.Duration;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
public final class GrpcCallContext
implements ApiCallContext {
    private final Channel channel;
    private final CallOptions callOptions;

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, CallOptions.DEFAULT);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, callOptions);
    }

    private GrpcCallContext(Channel channel, CallOptions callOptions) {
        this.channel = channel;
        this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions);
    }

    public GrpcCallContext nullToSelf(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = this;
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    public GrpcCallContext withCredentials(Credentials newCredentials) {
        Preconditions.checkNotNull((Object)newCredentials);
        CallCredentials callCredentials = MoreCallCredentials.from((Credentials)newCredentials);
        return this.withCallOptions(this.callOptions.withCallCredentials(callCredentials));
    }

    public GrpcCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof GrpcTransportChannel)) {
            throw new IllegalArgumentException("Expected GrpcTransportChannel, got " + inputChannel.getClass().getName());
        }
        GrpcTransportChannel transportChannel = (GrpcTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public GrpcCallContext withTimeout(Duration rpcTimeout) {
        CallOptions oldOptions = this.callOptions;
        CallOptions newOptions = oldOptions.withDeadlineAfter(rpcTimeout.toMillis(), TimeUnit.MILLISECONDS);
        GrpcCallContext nextContext = this.withCallOptions(newOptions);
        if (oldOptions.getDeadline() == null) {
            return nextContext;
        }
        if (oldOptions.getDeadline().isBefore(newOptions.getDeadline())) {
            return this;
        }
        return nextContext;
    }

    public ApiCallContext merge(ApiCallContext inputCallContext) {
        CallCredentials newCallCredentials;
        Deadline newDeadline;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        GrpcCallContext grpcCallContext = (GrpcCallContext)inputCallContext;
        Channel newChannel = grpcCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = grpcCallContext.callOptions.getDeadline()) == null) {
            newDeadline = this.callOptions.getDeadline();
        }
        if ((newCallCredentials = grpcCallContext.callOptions.getCredentials()) == null) {
            newCallCredentials = this.callOptions.getCredentials();
        }
        CallOptions newCallOptions = this.callOptions.withCallCredentials(newCallCredentials).withDeadline(newDeadline);
        return new GrpcCallContext(newChannel, newCallOptions);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    public GrpcCallContext withChannel(Channel newChannel) {
        return new GrpcCallContext(newChannel, this.callOptions);
    }

    public GrpcCallContext withCallOptions(CallOptions newCallOptions) {
        return new GrpcCallContext(this.channel, newCallOptions);
    }

    public GrpcCallContext withRequestParamsDynamicHeaderOption(String requestParams) {
        CallOptions newCallOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(this.callOptions, requestParams);
        return this.withCallOptions(newCallOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions);
    }
}

