/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.RequestUrlParamsEncoder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;

class GrpcDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    GrpcDirectCallable(MethodDescriptor<RequestT, ResponseT> descriptor, RequestUrlParamsEncoder<RequestT> paramsEncoder) {
        this.descriptor = (MethodDescriptor)Preconditions.checkNotNull(descriptor);
        this.paramsEncoder = (RequestUrlParamsEncoder)Preconditions.checkNotNull(paramsEncoder);
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        GrpcCallContext context = GrpcCallContext.getAsGrpcCallContextWithDefault(inputContext);
        CallOptions callOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(context.getCallOptions(), this.paramsEncoder.encode(request));
        return new ListenableFutureToApiFuture(ClientCalls.futureUnaryCall(this.newCall(context.getChannel(), callOptions), request));
    }

    private ClientCall<RequestT, ResponseT> newCall(Channel channel, CallOptions callOptions) {
        Preconditions.checkNotNull((Object)channel);
        Preconditions.checkNotNull((Object)callOptions);
        return channel.newCall(this.descriptor, callOptions);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

