/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsSettings;
import com.google.longrunning.PagedResponseWrappers;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class OperationsClient
implements BackgroundResource {
    private final OperationsSettings settings;
    private final OperationsStub stub;

    public static final OperationsClient create(OperationsSettings settings) throws IOException {
        return new OperationsClient(settings);
    }

    public static final OperationsClient create(OperationsStub stub) {
        return new OperationsClient(stub);
    }

    protected OperationsClient(OperationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected OperationsClient(OperationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OperationsSettings getSettings() {
        return this.settings;
    }

    public OperationsStub getStub() {
        return this.stub;
    }

    public final Operation getOperation(String name) {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        return this.getOperation(request);
    }

    private final Operation getOperation(GetOperationRequest request) {
        return (Operation)this.getOperationCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperationRequest, Operation> getOperationCallable() {
        return this.stub.getOperationCallable();
    }

    public final PagedResponseWrappers.ListOperationsPagedResponse listOperations(String name, String filter) {
        ListOperationsRequest request = ListOperationsRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.listOperations(request);
    }

    public final PagedResponseWrappers.ListOperationsPagedResponse listOperations(ListOperationsRequest request) {
        return (PagedResponseWrappers.ListOperationsPagedResponse)((Object)this.listOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOperationsRequest, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsPagedCallable() {
        return this.stub.listOperationsPagedCallable();
    }

    public final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable() {
        return this.stub.listOperationsCallable();
    }

    public final void cancelOperation(String name) {
        CancelOperationRequest request = CancelOperationRequest.newBuilder().setName(name).build();
        this.cancelOperation(request);
    }

    private final void cancelOperation(CancelOperationRequest request) {
        this.cancelOperationCallable().call((Object)request);
    }

    public final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable() {
        return this.stub.cancelOperationCallable();
    }

    public final void deleteOperation(String name) {
        DeleteOperationRequest request = DeleteOperationRequest.newBuilder().setName(name).build();
        this.deleteOperation(request);
    }

    private final void deleteOperation(DeleteOperationRequest request) {
        this.deleteOperationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

