/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;

class GrpcHeaderInterceptor
implements ClientInterceptor {
    private final Map<Metadata.Key<String>, String> customHeaders;

    public GrpcHeaderInterceptor(Map<Metadata.Key<String>, String> headers) {
        this.customHeaders = ImmutableMap.copyOf(headers);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                for (Map.Entry header : GrpcHeaderInterceptor.this.customHeaders.entrySet()) {
                    headers.put((Metadata.Key)header.getKey(), header.getValue());
                }
                super.start(responseListener, headers);
            }
        };
    }
}

