/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;

class GrpcClientCalls {
    private GrpcClientCalls() {
    }

    public static <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> descriptor, ApiCallContext context) {
        if (!(context instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + context.getClass().getName());
        }
        GrpcCallContext grpcContext = (GrpcCallContext)context;
        Preconditions.checkNotNull((Object)grpcContext.getChannel());
        Preconditions.checkNotNull((Object)grpcContext.getCallOptions());
        return grpcContext.getChannel().newCall(descriptor, grpcContext.getCallOptions());
    }
}

