/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ApiException;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.grpc.StatusRuntimeException;

@BetaApi
public class ApiExceptions {
    public static <ResponseT> ResponseT callAndTranslateApiException(ApiFuture<ResponseT> future) {
        try {
            return (ResponseT)Futures.getUnchecked(future);
        }
        catch (UncheckedExecutionException exception) {
            Throwables.propagateIfInstanceOf((Throwable)exception.getCause(), ApiException.class);
            if (exception.getCause() instanceof StatusRuntimeException) {
                StatusRuntimeException statusException = (StatusRuntimeException)exception.getCause();
                throw new ApiException((Throwable)statusException, statusException.getStatus().getCode(), false);
            }
            throw exception;
        }
    }
}

