/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.AttemptCallable;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.common.base.Preconditions;

class RetryingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final RetryingExecutor<ResponseT> executor;

    RetryingCallable(FutureCallable<RequestT, ResponseT> callable, RetryingExecutor<ResponseT> executor) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.executor = (RetryingExecutor)Preconditions.checkNotNull(executor);
    }

    @Override
    public RetryingFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        AttemptCallable<RequestT, ResponseT> retryCallable = new AttemptCallable<RequestT, ResponseT>(this.callable, request, context);
        RetryingFuture retryingFuture = this.executor.createFuture(retryCallable);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

