/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.AutoValue_ClientContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

@BetaApi
public abstract class ClientContext {
    public abstract Collection<AutoCloseable> getCloseables();

    public abstract Channel getChannel();

    public abstract ScheduledExecutorService getExecutor();

    @Nullable
    public abstract Credentials getCredentials();

    static Builder newBuilder() {
        return new AutoValue_ClientContext.Builder().setCloseables(Collections.emptyList());
    }

    public static ClientContext create(ClientSettings settings) throws IOException {
        ChannelProvider channelProvider;
        ImmutableList.Builder closeables = ImmutableList.builder();
        ExecutorProvider executorProvider = settings.getExecutorProvider();
        final ScheduledExecutorService executor = executorProvider.getExecutor();
        if (executorProvider.shouldAutoClose()) {
            closeables.add((Object)new AutoCloseable(){

                @Override
                public void close() {
                    executor.shutdown();
                }
            });
        }
        final ManagedChannel channel = (channelProvider = settings.getChannelProvider()).needsExecutor() ? channelProvider.getChannel(executor) : channelProvider.getChannel();
        if (channelProvider.shouldAutoClose()) {
            closeables.add((Object)new AutoCloseable(){

                @Override
                public void close() {
                    channel.shutdown();
                }
            });
        }
        return ClientContext.newBuilder().setCloseables((Collection<AutoCloseable>)closeables.build()).setChannel((Channel)channel).setExecutor(executor).setCredentials(settings.getCredentialsProvider().getCredentials()).build();
    }

    static abstract class Builder {
        Builder() {
        }

        public abstract Builder setCloseables(Collection<AutoCloseable> var1);

        public abstract Builder setChannel(Channel var1);

        public abstract Builder setExecutor(ScheduledExecutorService var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract ClientContext build();
    }
}

