/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.retrying.ExceptionRetryAlgorithm;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Status;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.threeten.bp.Duration;

class RetryingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    static final Duration DEADLINE_SLEEP_DURATION = Duration.ofMillis((long)1L);
    private final FutureCallable<RequestT, ResponseT> callable;
    private final RetryingExecutor<ResponseT> scheduler;

    RetryingCallable(FutureCallable<RequestT, ResponseT> callable, RetrySettings retrySettings, ScheduledExecutorService scheduler, ApiClock clock) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm((ExceptionRetryAlgorithm)new GrpcExceptionRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, clock));
        this.scheduler = new ScheduledRetryingExecutor(retryAlgorithm, scheduler);
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        GrpcRetryCallable retryCallable = new GrpcRetryCallable(this.callable, request, context);
        RetryingFuture retryingFuture = this.scheduler.createFuture(retryCallable);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }

    private static CallContext getCallContextWithDeadlineAfter(CallContext oldContext, Duration rpcTimeout) {
        CallOptions oldOptions = oldContext.getCallOptions();
        CallOptions newOptions = oldOptions.withDeadlineAfter(rpcTimeout.toMillis(), TimeUnit.MILLISECONDS);
        CallContext newContext = oldContext.withCallOptions(newOptions);
        if (oldOptions.getDeadline() == null) {
            return newContext;
        }
        if (oldOptions.getDeadline().isBefore(newOptions.getDeadline())) {
            return oldContext;
        }
        return newContext;
    }

    private static class NonCancelableFuture<ResponseT>
    extends AbstractApiFuture<ResponseT> {
        private NonCancelableFuture() {
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }

    private static class GrpcExceptionRetryAlgorithm
    implements ExceptionRetryAlgorithm {
        private GrpcExceptionRetryAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, TimedAttemptSettings prevSettings) {
            if (((ApiException)prevThrowable).getStatusCode() == Status.Code.DEADLINE_EXCEEDED) {
                return new TimedAttemptSettings(prevSettings.getGlobalSettings(), prevSettings.getRetryDelay(), prevSettings.getRpcTimeout(), DEADLINE_SLEEP_DURATION, prevSettings.getAttemptCount() + 1, prevSettings.getFirstAttemptStartTimeNanos());
            }
            return null;
        }

        public boolean accept(Throwable prevThrowable) {
            return prevThrowable instanceof ApiException && ((ApiException)prevThrowable).isRetryable();
        }
    }

    private static class GrpcRetryCallable<RequestT, ResponseT>
    implements Callable<ResponseT> {
        private final FutureCallable<RequestT, ResponseT> callable;
        private final RequestT request;
        private volatile RetryingFuture<ResponseT> externalFuture;
        private volatile CallContext callContext;

        private GrpcRetryCallable(FutureCallable<RequestT, ResponseT> callable, RequestT request, CallContext callContext) {
            this.callable = callable;
            this.request = request;
            this.callContext = callContext;
        }

        private void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
            this.externalFuture = externalFuture;
        }

        @Override
        public ResponseT call() {
            this.callContext = RetryingCallable.getCallContextWithDeadlineAfter(this.callContext, this.externalFuture.getAttemptSettings().getRpcTimeout());
            try {
                this.externalFuture.setAttemptFuture(new NonCancelableFuture());
                if (this.externalFuture.isDone()) {
                    return null;
                }
                ApiFuture<ResponseT> internalFuture = this.callable.futureCall(this.request, this.callContext);
                this.externalFuture.setAttemptFuture(internalFuture);
            }
            catch (Throwable e) {
                this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture((Throwable)e));
                throw e;
            }
            return null;
        }
    }
}

