/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;

public class MockServiceHelper {
    private static final int FLOW_CONTROL_WINDOW = 66560;
    private final String addressString;
    private final SocketAddress address;
    private final Server server;
    private final List<MockGrpcService> mockServices;

    public MockServiceHelper(String addressString, MockGrpcService mockService) {
        this(addressString, Arrays.asList(mockService));
    }

    public MockServiceHelper(String addressString, List<MockGrpcService> mockServices) {
        this.addressString = addressString;
        this.address = new LocalAddress(addressString);
        this.mockServices = Lists.newArrayList(mockServices);
        NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)this.address).flowControlWindow(66560).channelType(LocalServerChannel.class);
        for (MockGrpcService mockService : mockServices) {
            builder.addService(mockService.getServiceDefinition());
        }
        this.server = builder.build();
    }

    @VisibleForTesting
    MockServiceHelper(Server server, String address, MockGrpcService mockService) {
        this(server, address, Arrays.asList(mockService));
    }

    @VisibleForTesting
    MockServiceHelper(Server server, String addressString, List<MockGrpcService> mockServices) {
        this.server = server;
        this.addressString = addressString;
        this.address = new LocalAddress(addressString);
        this.mockServices = mockServices;
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void reset() {
        for (MockGrpcService mockService : this.mockServices) {
            mockService.reset();
        }
    }

    public void stop() {
        this.server.shutdownNow();
    }

    public MockGrpcService getService() {
        if (this.mockServices.size() != 1) {
            throw new IllegalStateException("MockServiceHelper.getService() can only be called if there is one service, but there are " + this.mockServices.size());
        }
        return this.mockServices.get(0);
    }

    public List<MockGrpcService> getServices() {
        return this.mockServices;
    }

    public LocalChannelProvider createChannelProvider() {
        return LocalChannelProvider.create(this.addressString);
    }
}

