/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateProviderPluginInstance;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;

public final class CommonTlsContextUtil {
    private CommonTlsContextUtil() {
    }

    public static boolean hasCertProviderInstance(CommonTlsContext commonTlsContext) {
        if (commonTlsContext == null) {
            return false;
        }
        return commonTlsContext.hasTlsCertificateProviderInstance() || CommonTlsContextUtil.hasValidationProviderInstance(commonTlsContext);
    }

    private static boolean hasValidationProviderInstance(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasValidationContext() && commonTlsContext.getValidationContext().hasCaCertificateProviderInstance()) {
            return true;
        }
        return commonTlsContext.hasCombinedValidationContext() && commonTlsContext.getCombinedValidationContext().getDefaultValidationContext().hasCaCertificateProviderInstance();
    }

    public static CommonTlsContext.CertificateProviderInstance convert(CertificateProviderPluginInstance pluginInstance) {
        return CommonTlsContext.CertificateProviderInstance.newBuilder().setInstanceName(pluginInstance.getInstanceName()).setCertificateName(pluginInstance.getCertificateName()).build();
    }

    public static boolean isUsingSystemRootCerts(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasCombinedValidationContext()) {
            return commonTlsContext.getCombinedValidationContext().getDefaultValidationContext().hasSystemRootCerts();
        }
        if (commonTlsContext.hasValidationContext()) {
            return commonTlsContext.getValidationContext().hasSystemRootCerts();
        }
        return false;
    }
}

