/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.client.util.SecurityUtils;
import com.google.api.core.InternalApi;
import com.google.auth.mtls.MtlsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

@InternalApi(value="for testing")
public class FakeMtlsProvider
implements MtlsProvider {
    private KeyStore keyStore;
    private boolean throwExceptionForGetKeyStore;

    public FakeMtlsProvider(KeyStore keystore, String keyStorePassword, boolean throwExceptionForGetKeyStore) {
        this.keyStore = keystore;
        this.throwExceptionForGetKeyStore = throwExceptionForGetKeyStore;
    }

    @Override
    public KeyStore getKeyStore() throws IOException {
        if (this.throwExceptionForGetKeyStore) {
            throw new IOException("getKeyStore throws exception");
        }
        return this.keyStore;
    }

    @Override
    public boolean isAvailable() throws IOException {
        return true;
    }

    public static KeyStore createTestMtlsKeyStore() throws IOException {
        try {
            InputStream certAndKey = FakeMtlsProvider.class.getClassLoader().getResourceAsStream("com/google/api/gax/rpc/mtls/mtlsCertAndKey.pem");
            return SecurityUtils.createMtlsKeyStore(certAndKey);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to create key store", e);
        }
    }
}

