/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_IdentifierNode;
import com.google.api.generator.engine.lexicon.InvalidSymbol;
import com.google.api.generator.engine.lexicon.Keyword;
import com.google.api.generator.engine.lexicon.Literal;
import com.google.api.generator.engine.lexicon.Operator;
import com.google.api.generator.engine.lexicon.Separator;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

@AutoValue
public abstract class IdentifierNode
implements AstNode {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("^[0-9]");

    public abstract String name();

    public static IdentifierNode withName(String name) {
        return IdentifierNode.builder().setName(name).build();
    }

    public static Builder builder() {
        return new AutoValue_IdentifierNode.Builder();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.name();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        abstract IdentifierNode autoBuild();

        public IdentifierNode buildVariableIdentifier() throws InvalidIdentifierException {
            return this.build(true);
        }

        public IdentifierNode build() throws InvalidIdentifierException {
            return this.build(false);
        }

        IdentifierNode build(boolean isField) throws InvalidIdentifierException {
            IdentifierNode identifier = this.autoBuild();
            String identifierName = identifier.name();
            Preconditions.checkNotNull(identifierName);
            if (identifierName.isEmpty()) {
                throw new InvalidIdentifierException("Name cannot be empty.");
            }
            if (NUMERIC_PATTERN.matcher(identifierName.substring(0, 1)).matches()) {
                throw new InvalidIdentifierException("Name cannot begin with a number.");
            }
            if (Literal.isLiteral(identifierName)) {
                throw new InvalidIdentifierException(String.format("Name %s cannot be a literal", identifierName));
            }
            if (InvalidSymbol.containsInvalidSymbol(identifierName) || Operator.containsOperator(identifierName) || Separator.containsSeparator(identifierName)) {
                throw new InvalidIdentifierException(String.format("Name %s cannot contain non-alphanumeric characters", identifierName));
            }
            if (isField ? Keyword.isInvalidFieldName(identifierName) : Keyword.isKeyword(identifierName)) {
                throw new InvalidIdentifierException(String.format("Name %s cannot be a keyword.", identifierName));
            }
            return identifier;
        }
    }

    static class InvalidIdentifierException
    extends RuntimeException {
        public InvalidIdentifierException(String errorMessage) {
            super(errorMessage);
        }
    }
}

