/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.mtls;

import com.google.api.client.util.SecurityUtils;
import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.auth.mtls.WorkloadCertificateConfiguration;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.KeyStore;
import java.util.Locale;

public class X509Provider {
    static final String CERTIFICATE_CONFIGURATION_ENV_VARIABLE = "GOOGLE_API_CERTIFICATE_CONFIG";
    static final String WELL_KNOWN_CERTIFICATE_CONFIG_FILE = "certificate_config.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    private final String certConfigPathOverride;

    public X509Provider(String certConfigPathOverride) {
        this.certConfigPathOverride = certConfigPathOverride;
    }

    public X509Provider() {
        this(null);
    }

    public String getCertificatePath() throws IOException {
        String certPath = this.getWorkloadCertificateConfiguration().getCertPath();
        if (Strings.isNullOrEmpty(certPath)) {
            throw new CertificateSourceUnavailableException("Certificate configuration loaded successfully, but does not contain a 'certificate_file' path.");
        }
        return certPath;
    }

    public KeyStore getKeyStore() throws IOException {
        WorkloadCertificateConfiguration workloadCertConfig = this.getWorkloadCertificateConfiguration();
        InputStream certStream = null;
        InputStream privateKeyStream = null;
        SequenceInputStream certAndPrivateKeyStream = null;
        try {
            File certFile = new File(workloadCertConfig.getCertPath());
            File privateKeyFile = new File(workloadCertConfig.getPrivateKeyPath());
            certStream = this.createInputStream(certFile);
            privateKeyStream = this.createInputStream(privateKeyFile);
            certAndPrivateKeyStream = new SequenceInputStream(certStream, privateKeyStream);
            KeyStore keyStore = SecurityUtils.createMtlsKeyStore(certAndPrivateKeyStream);
            return keyStore;
        }
        catch (CertificateSourceUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (certStream != null) {
                certStream.close();
            }
            if (privateKeyStream != null) {
                privateKeyStream.close();
            }
            if (certAndPrivateKeyStream != null) {
                certAndPrivateKeyStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkloadCertificateConfiguration getWorkloadCertificateConfiguration() throws IOException {
        String envCredentialsPath;
        File certConfig = this.certConfigPathOverride != null ? new File(this.certConfigPathOverride) : (!Strings.isNullOrEmpty(envCredentialsPath = this.getEnv(CERTIFICATE_CONFIGURATION_ENV_VARIABLE)) ? new File(envCredentialsPath) : this.getWellKnownCertificateConfigFile());
        try (InputStream certConfigStream = null;){
            if (!this.isFile(certConfig)) {
                throw new CertificateSourceUnavailableException("File does not exist.");
            }
            certConfigStream = this.createInputStream(certConfig);
            WorkloadCertificateConfiguration workloadCertificateConfiguration = WorkloadCertificateConfiguration.fromCertificateConfigurationStream(certConfigStream);
            return workloadCertificateConfiguration;
        }
    }

    boolean isFile(File file) {
        return file.isFile();
    }

    InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    String getEnv(String name) {
        return System.getenv(name);
    }

    String getOsName() {
        return this.getProperty("os.name", "").toLowerCase(Locale.US);
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    private File getWellKnownCertificateConfigFile() {
        File cloudConfigPath;
        String envPath = this.getEnv("CLOUDSDK_CONFIG");
        if (envPath != null) {
            cloudConfigPath = new File(envPath);
        } else if (this.getOsName().indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        return new File(cloudConfigPath, WELL_KNOWN_CERTIFICATE_CONFIG_FILE);
    }
}

