/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.file;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.file.FSInfo;
import org.openjdk.tools.javac.file.Locations;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.main.OptionHelper;
import org.openjdk.tools.javac.resources.CompilerProperties;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;

public abstract class BaseFileManager
implements JavaFileManager {
    public Log log;
    protected Charset charset;
    protected Options options;
    protected String classLoaderClass;
    protected final Locations locations;
    public boolean autoClose;
    private long lastUsedTime = System.currentTimeMillis();
    protected long deferredCloseTimeout = 0L;
    private static final Set<Option> javacFileManagerOptions = Option.getJavacFileManagerOptions();
    protected String multiReleaseValue;
    private String encodingName;
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.byteBufferCache = new ByteBufferCache();
        this.locations = this.createLocations();
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.classLoaderClass = this.options.get("procloader");
        boolean bl = this.options.isLintSet("path");
        this.locations.update(this.log, bl, FSInfo.instance(context));
        String string = this.options.get("fileManager.deferClose");
        if (string != null) {
            try {
                this.deferredCloseTimeout = (int)(Float.parseFloat(string) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                this.deferredCloseTimeout = 60000L;
            }
        }
    }

    protected Locations createLocations() {
        return new Locations();
    }

    protected void deferredClose() {
        Thread thread = new Thread(this.getClass().getName() + " DeferredClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BaseFileManager baseFileManager = BaseFileManager.this;
                    synchronized (baseFileManager) {
                        long l = System.currentTimeMillis();
                        while (l < BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout) {
                            BaseFileManager.this.wait(BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout - l);
                            l = System.currentTimeMillis();
                        }
                        BaseFileManager.this.deferredCloseTimeout = 0L;
                        BaseFileManager.this.close();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    synchronized void updateLastUsedTime() {
        if (this.deferredCloseTimeout > 0L) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    protected ClassLoader getClassLoader(URL[] uRLArray) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.classLoaderClass != null) {
            try {
                Class<ClassLoader> clazz = Class.forName(this.classLoaderClass).asSubclass(ClassLoader.class);
                Class[] classArray = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constructor = clazz.getConstructor(classArray);
                return constructor.newInstance(uRLArray, classLoader);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new URLClassLoader(uRLArray, classLoader);
    }

    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        OptionHelper.GrumpyHelper grumpyHelper = new OptionHelper.GrumpyHelper(this.log){

            @Override
            public String get(Option option) {
                return BaseFileManager.this.options.get(option);
            }

            @Override
            public void put(String string, String string2) {
                BaseFileManager.this.options.put(string, string2);
            }

            @Override
            public void remove(String string) {
                BaseFileManager.this.options.remove(string);
            }

            @Override
            public boolean handleFileManagerOption(Option option, String string) {
                return BaseFileManager.this.handleOption(option, string);
            }
        };
        Option option = Option.lookup(string, javacFileManagerOptions);
        if (option == null) {
            return false;
        }
        try {
            option.handleOption(grumpyHelper, string, iterator);
        }
        catch (Option.InvalidValueException invalidValueException) {
            throw new IllegalArgumentException(invalidValueException.getMessage(), invalidValueException);
        }
        return true;
    }

    @Override
    public int isSupportedOption(String string) {
        Option option = Option.lookup(string, javacFileManagerOptions);
        return option == null ? -1 : (option.hasArg() ? 1 : 0);
    }

    public boolean handleOption(Option option, String string) {
        switch (option) {
            case ENCODING: {
                this.encodingName = string;
                return true;
            }
            case MULTIRELEASE: {
                this.multiReleaseValue = string;
                this.locations.setMultiReleaseValue(string);
                return true;
            }
        }
        return this.locations.handleOption(option, string);
    }

    public boolean handleOptions(Map<Option, String> map) {
        boolean bl = true;
        for (Map.Entry<Option, String> entry : map.entrySet()) {
            try {
                bl &= this.handleOption(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error(CompilerProperties.Errors.IllegalArgumentForOption(entry.getKey().getPrimaryName(), illegalArgumentException.getMessage()));
                bl = false;
            }
        }
        return bl;
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = Charset.defaultCharset().name();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        return this.encodingName != null ? this.encodingName : this.getDefaultEncodingName();
    }

    public CharBuffer decode(ByteBuffer byteBuffer, boolean bl) {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder;
        String string = this.getEncodingName();
        try {
            charsetDecoder = this.getDecoder(string, bl);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            this.log.error("unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float f = charsetDecoder.averageCharsPerByte() * 0.8f + charsetDecoder.maxCharsPerByte() * 0.2f;
        CharBuffer charBuffer = CharBuffer.allocate(10 + (int)((float)byteBuffer.remaining() * f));
        while (true) {
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            if (coderResult.isUnderflow()) {
                if (charBuffer.limit() == charBuffer.capacity()) {
                    charBuffer = CharBuffer.allocate(charBuffer.capacity() + 1).put(charBuffer);
                    charBuffer.flip();
                }
                return charBuffer;
            }
            if (coderResult.isOverflow()) {
                int n = 10 + charBuffer.capacity() + (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
                charBuffer = CharBuffer.allocate(n).put(charBuffer);
                continue;
            }
            if (!coderResult.isMalformed() && !coderResult.isUnmappable()) break;
            StringBuilder stringBuilder = new StringBuilder();
            int n = coderResult.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(String.format("%02X", byteBuffer.get()));
            }
            String string2 = this.charset == null ? string : this.charset.name();
            this.log.error(charBuffer.limit(), CompilerProperties.Errors.IllegalCharForEncoding(stringBuilder.toString(), string2));
            charBuffer.position(charBuffer.limit());
            charBuffer.limit(charBuffer.capacity());
            charBuffer.put('\ufffd');
        }
        throw new AssertionError(coderResult);
    }

    public CharsetDecoder getDecoder(String string, boolean bl) {
        Charset charset = this.charset == null ? Charset.forName(string) : this.charset;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CodingErrorAction codingErrorAction = bl ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return charsetDecoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    public ByteBuffer makeByteBuffer(InputStream inputStream) throws IOException {
        int n = inputStream.available();
        if (n < 1024) {
            n = 1024;
        }
        ByteBuffer byteBuffer = this.byteBufferCache.get(n);
        int n2 = 0;
        while (inputStream.available() != 0) {
            int n3;
            if (n2 >= n) {
                byteBuffer = ByteBuffer.allocate(n <<= 1).put((ByteBuffer)byteBuffer.flip());
            }
            if ((n3 = inputStream.read(byteBuffer.array(), n2, n - n2)) < 0) break;
            byteBuffer.position(n2 += n3);
        }
        return (ByteBuffer)byteBuffer.flip();
    }

    public void recycleByteBuffer(ByteBuffer byteBuffer) {
        this.byteBufferCache.put(byteBuffer);
    }

    public CharBuffer getCachedContent(JavaFileObject javaFileObject) {
        ContentCacheEntry contentCacheEntry = this.contentCache.get(javaFileObject);
        if (contentCacheEntry == null) {
            return null;
        }
        if (!contentCacheEntry.isValid(javaFileObject)) {
            this.contentCache.remove(javaFileObject);
            return null;
        }
        return contentCacheEntry.getValue();
    }

    public void cache(JavaFileObject javaFileObject, CharBuffer charBuffer) {
        this.contentCache.put(javaFileObject, new ContentCacheEntry(javaFileObject, charBuffer));
    }

    public void flushCache(JavaFileObject javaFileObject) {
        this.contentCache.remove(javaFileObject);
    }

    public static JavaFileObject.Kind getKind(Path path) {
        return BaseFileManager.getKind(path.getFileName().toString());
    }

    public static JavaFileObject.Kind getKind(String string) {
        if (string.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T t2) {
        return Objects.requireNonNull(t2);
    }

    protected static <T> Collection<T> nullCheck(Collection<T> collection) {
        for (T t2 : collection) {
            Objects.requireNonNull(t2);
        }
        return collection;
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject javaFileObject, CharBuffer charBuffer) {
            this.timestamp = javaFileObject.getLastModified();
            this.ref = new SoftReference<CharBuffer>(charBuffer);
        }

        boolean isValid(JavaFileObject javaFileObject) {
            return this.timestamp == javaFileObject.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int n) {
            if (n < 20480) {
                n = 20480;
            }
            ByteBuffer byteBuffer = this.cached != null && this.cached.capacity() >= n ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(n + n >> 1);
            this.cached = null;
            return byteBuffer;
        }

        void put(ByteBuffer byteBuffer) {
            this.cached = byteBuffer;
        }
    }
}

