/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.googlejavaformat.java.CommandLineOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class CommandLineOptionsParser {
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static final Splitter COLON_SPLITTER = Splitter.on(':');
    private static final Splitter ARG_SPLITTER = Splitter.on(CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();

    CommandLineOptionsParser() {
    }

    static CommandLineOptions parse(Iterable<String> options) {
        CommandLineOptions.Builder optionsBuilder = CommandLineOptions.builder();
        ArrayList<String> expandedOptions = new ArrayList<String>();
        CommandLineOptionsParser.expandParamsFiles(options, expandedOptions);
        Iterator<String> it = expandedOptions.iterator();
        block48: while (it.hasNext()) {
            String value;
            String flag;
            String option = (String)it.next();
            if (!option.startsWith("-")) {
                ((ImmutableList.Builder)optionsBuilder.filesBuilder().add((Object)option)).addAll(it);
                break;
            }
            int idx = option.indexOf(61);
            if (idx >= 0) {
                flag = option.substring(0, idx);
                value = option.substring(idx + 1, option.length());
            } else {
                flag = option;
                value = null;
            }
            switch (flag) {
                case "-i": 
                case "-r": 
                case "-replace": 
                case "--replace": {
                    optionsBuilder.inPlace(true);
                    continue block48;
                }
                case "--lines": 
                case "-lines": 
                case "--line": 
                case "-line": {
                    CommandLineOptionsParser.parseRangeSet(optionsBuilder.linesBuilder(), CommandLineOptionsParser.getValue(flag, it, value));
                    continue block48;
                }
                case "--offset": 
                case "-offset": {
                    optionsBuilder.addOffset(CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block48;
                }
                case "--length": 
                case "-length": {
                    optionsBuilder.addLength(CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block48;
                }
                case "--aosp": 
                case "-aosp": 
                case "-a": {
                    optionsBuilder.aosp(true);
                    continue block48;
                }
                case "--version": 
                case "-version": 
                case "-v": {
                    optionsBuilder.version(true);
                    continue block48;
                }
                case "--help": 
                case "-help": 
                case "-h": {
                    optionsBuilder.help(true);
                    continue block48;
                }
                case "--fix-imports-only": {
                    optionsBuilder.fixImportsOnly(true);
                    continue block48;
                }
                case "--skip-sorting-imports": {
                    optionsBuilder.sortImports(false);
                    continue block48;
                }
                case "--skip-removing-unused-imports": {
                    optionsBuilder.removeUnusedImports(false);
                    continue block48;
                }
                case "-": {
                    optionsBuilder.stdin(true);
                    continue block48;
                }
                case "-n": 
                case "--dry-run": {
                    optionsBuilder.dryRun(true);
                    continue block48;
                }
                case "--set-exit-if-changed": {
                    optionsBuilder.setExitIfChanged(true);
                    continue block48;
                }
                case "-assume-filename": 
                case "--assume-filename": {
                    optionsBuilder.assumeFilename(CommandLineOptionsParser.getValue(flag, it, value));
                    continue block48;
                }
            }
            throw new IllegalArgumentException("unexpected flag: " + flag);
        }
        return optionsBuilder.build();
    }

    private static Integer parseInteger(Iterator<String> it, String flag, String value) {
        try {
            return Integer.valueOf(CommandLineOptionsParser.getValue(flag, it, value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("invalid integer value for %s: %s", flag, value), e);
        }
    }

    private static String getValue(String flag, Iterator<String> it, String value) {
        if (value != null) {
            return value;
        }
        if (!it.hasNext()) {
            throw new IllegalArgumentException("required value was not provided for: " + flag);
        }
        return it.next();
    }

    private static void parseRangeSet(ImmutableRangeSet.Builder<Integer> result, String ranges) {
        for (String range : COMMA_SPLITTER.split(ranges)) {
            result.add(CommandLineOptionsParser.parseRange(range));
        }
    }

    private static Range<Integer> parseRange(String arg) {
        List<String> args = COLON_SPLITTER.splitToList(arg);
        switch (args.size()) {
            case 1: {
                int line = Integer.parseInt(args.get(0)) - 1;
                return Range.closedOpen(line, line + 1);
            }
            case 2: {
                int line0 = Integer.parseInt(args.get(0)) - 1;
                int line1 = Integer.parseInt(args.get(1)) - 1;
                return Range.closedOpen(line0, line1 + 1);
            }
        }
        throw new IllegalArgumentException(arg);
    }

    private static void expandParamsFiles(Iterable<String> args, List<String> expanded) {
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            if (!arg.startsWith("@")) {
                expanded.add(arg);
                continue;
            }
            if (arg.startsWith("@@")) {
                expanded.add(arg.substring(1));
                continue;
            }
            Path path = Paths.get(arg.substring(1), new String[0]);
            try {
                String sequence = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                CommandLineOptionsParser.expandParamsFiles(ARG_SPLITTER.split(sequence), expanded);
            }
            catch (IOException e) {
                throw new UncheckedIOException(path + ": could not read file: " + e.getMessage(), e);
            }
        }
    }
}

