/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.auth.CredentialTypeForMetrics;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.auth.oauth2.GoogleAuthException;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IamUtils;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.MetricsUtils;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputeEngineCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider {
    static final Duration COMPUTE_EXPIRATION_MARGIN = Duration.ofMinutes(3L);
    static final Duration COMPUTE_REFRESH_MARGIN = Duration.ofMinutes(3L).plusSeconds(45L);
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineCredentials.class.getName());
    static final String DEFAULT_METADATA_SERVER_URL = "http://metadata.google.internal";
    static final String SIGN_BLOB_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
    static final int MAX_COMPUTE_PING_TRIES = 3;
    static final int COMPUTE_PING_CONNECTION_TIMEOUT_MS = 500;
    private static final String METADATA_FLAVOR = "Metadata-Flavor";
    private static final String GOOGLE = "Google";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final String PARSE_ERROR_ACCOUNT = "Error parsing service account response. ";
    private static final long serialVersionUID = -4113476462526554235L;
    private final String transportFactoryClassName;
    private final Collection<String> scopes;
    private transient HttpTransportFactory transportFactory;
    private transient String serviceAccountEmail;
    private String universeDomainFromMetadata = null;

    private ComputeEngineCredentials(Builder builder) {
        super(builder);
        this.transportFactory = MoreObjects.firstNonNull(builder.getHttpTransportFactory(), ComputeEngineCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        Collection<String> scopesToUse = builder.scopes;
        if (scopesToUse == null || scopesToUse.isEmpty()) {
            scopesToUse = builder.getDefaultScopes();
        }
        if (scopesToUse == null) {
            this.scopes = ImmutableSet.of();
        } else {
            ArrayList<String> scopeList = new ArrayList<String>(scopesToUse);
            scopeList.removeAll(Arrays.asList("", null));
            this.scopes = ImmutableSet.copyOf(scopeList);
        }
    }

    @Override
    public CredentialTypeForMetrics getMetricsCredentialType() {
        return CredentialTypeForMetrics.VM_CREDENTIALS;
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return this.createScoped(newScopes, ImmutableList.of());
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes, Collection<String> newDefaultScopes) {
        return this.toBuilder().setHttpTransportFactory(this.transportFactory).setScopes(newScopes).setDefaultScopes(newDefaultScopes).setAccessToken(null).build();
    }

    public static ComputeEngineCredentials create() {
        return new ComputeEngineCredentials(ComputeEngineCredentials.newBuilder());
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    String createTokenUrlWithScopes() {
        GenericUrl tokenUrl = new GenericUrl(ComputeEngineCredentials.getTokenServerEncodedUrl());
        if (!this.scopes.isEmpty()) {
            tokenUrl.set("scopes", Joiner.on(',').join(this.scopes));
        }
        return tokenUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniverseDomain() throws IOException {
        if (this.isExplicitUniverseDomain()) {
            return super.getUniverseDomain();
        }
        ComputeEngineCredentials computeEngineCredentials = this;
        synchronized (computeEngineCredentials) {
            if (this.universeDomainFromMetadata != null) {
                return this.universeDomainFromMetadata;
            }
        }
        String universeDomainFromMetadata = this.getUniverseDomainFromMetadata();
        ComputeEngineCredentials computeEngineCredentials2 = this;
        synchronized (computeEngineCredentials2) {
            this.universeDomainFromMetadata = universeDomainFromMetadata;
        }
        return universeDomainFromMetadata;
    }

    private String getUniverseDomainFromMetadata() throws IOException {
        HttpResponse response = this.getMetadataResponse(ComputeEngineCredentials.getUniverseDomainUrl(), MetricsUtils.RequestType.UNTRACKED, false);
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            return "googleapis.com";
        }
        if (statusCode != 200) {
            IOException cause = new IOException(String.format("Unexpected Error code %s trying to get universe domain from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
            throw new GoogleAuthException(true, (Throwable)cause);
        }
        String responseString = response.parseAsString();
        if (responseString.isEmpty()) {
            return "googleapis.com";
        }
        return responseString;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response = this.getMetadataResponse(this.createTokenUrlWithScopes(), MetricsUtils.RequestType.ACCESS_TOKEN_REQUEST, true);
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            throw new IOException(String.format("Error code %s trying to get security access token from Compute Engine metadata for the default service account. This may be because the virtual machine instance does not have permission scopes specified. It is possible to skip checking for Compute Engine metadata by specifying the environment  variable NO_GCE_CHECK=true.", statusCode));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to get security access token from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        GenericUrl documentUrl = new GenericUrl(ComputeEngineCredentials.getIdentityDocumentUrl());
        if (options != null) {
            if (options.contains((Object)IdTokenProvider.Option.FORMAT_FULL)) {
                documentUrl.set("format", "full");
            }
            if (options.contains((Object)IdTokenProvider.Option.LICENSES_TRUE)) {
                documentUrl.set("format", "full");
                documentUrl.set("license", "TRUE");
            }
        }
        documentUrl.set("audience", targetAudience);
        HttpResponse response = this.getMetadataResponse(documentUrl.toString(), MetricsUtils.RequestType.ID_TOKEN_REQUEST, true);
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        String rawToken = response.parseAsString();
        return IdToken.create(rawToken);
    }

    private HttpResponse getMetadataResponse(String url, MetricsUtils.RequestType requestType, boolean shouldSendMetricsHeader) throws IOException {
        HttpResponse response;
        GenericUrl genericUrl = new GenericUrl(url);
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(genericUrl);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.getHeaders().set(METADATA_FLAVOR, GOOGLE);
        if (shouldSendMetricsHeader) {
            MetricsUtils.setMetricsHeader(request, MetricsUtils.getGoogleCredentialsMetricsHeader(requestType, this.getMetricsCredentialType()));
        }
        request.setThrowExceptionOnExecuteError(false);
        try {
            response = request.execute();
        }
        catch (UnknownHostException exception) {
            throw new IOException("ComputeEngineCredentials cannot find the metadata server. This is likely because code is not running on Google Compute Engine.", exception);
        }
        if (response.getStatusCode() == 503) {
            throw GoogleAuthException.createWithTokenEndpointResponseException(new HttpResponseException(response));
        }
        return response;
    }

    static synchronized boolean isOnGce(HttpTransportFactory transportFactory, DefaultCredentialsProvider provider) {
        if (Boolean.parseBoolean(provider.getEnv("NO_GCE_CHECK"))) {
            return false;
        }
        boolean result = ComputeEngineCredentials.pingComputeEngineMetadata(transportFactory, provider);
        if (!result) {
            result = ComputeEngineCredentials.checkStaticGceDetection(provider);
        }
        if (!result) {
            LOGGER.log(Level.FINE, "Failed to detect whether running on Google Compute Engine.");
        }
        return result;
    }

    @VisibleForTesting
    static boolean checkProductNameOnLinux(BufferedReader reader) throws IOException {
        String name = reader.readLine().trim();
        return name.startsWith(GOOGLE);
    }

    @VisibleForTesting
    static boolean checkStaticGceDetection(DefaultCredentialsProvider provider) {
        String osName = provider.getOsName();
        try {
            if (osName.startsWith(LINUX)) {
                File linuxFile = new File("/sys/class/dmi/id/product_name");
                return ComputeEngineCredentials.checkProductNameOnLinux(new BufferedReader(new InputStreamReader(provider.readStream(linuxFile))));
            }
            if (osName.startsWith(WINDOWS)) {
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Encountered an unexpected exception when checking SMBIOS value", e);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pingComputeEngineMetadata(HttpTransportFactory transportFactory, DefaultCredentialsProvider provider) {
        GenericUrl tokenUrl = new GenericUrl(ComputeEngineCredentials.getMetadataServerUrl(provider));
        for (int i = 1; i <= 3; ++i) {
            boolean bl;
            HttpRequest request2 = transportFactory.create().createRequestFactory().buildGetRequest(tokenUrl);
            request2.setConnectTimeout(500);
            request2.getHeaders().set(METADATA_FLAVOR, GOOGLE);
            MetricsUtils.setMetricsHeader(request2, MetricsUtils.getGoogleCredentialsMetricsHeader(MetricsUtils.RequestType.METADATA_SERVER_PING, CredentialTypeForMetrics.DO_NOT_SEND));
            HttpResponse response = request2.execute();
            try {
                HttpHeaders headers = response.getHeaders();
                bl = OAuth2Utils.headersContainValue(headers, METADATA_FLAVOR, GOOGLE);
            }
            catch (Throwable throwable) {
                try {
                    response.disconnect();
                    throw throwable;
                }
                catch (SocketTimeoutException request2) {
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Encountered an unexpected exception when checking if running on Google Compute Engine using Metadata Service ping.", e);
                }
            }
            response.disconnect();
            return bl;
        }
        return false;
    }

    public static String getMetadataServerUrl(DefaultCredentialsProvider provider) {
        String metadataServerAddress = provider.getEnv("GCE_METADATA_HOST");
        if (metadataServerAddress != null) {
            return "http://" + metadataServerAddress;
        }
        return DEFAULT_METADATA_SERVER_URL;
    }

    public static String getMetadataServerUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT);
    }

    public static String getTokenServerEncodedUrl(DefaultCredentialsProvider provider) {
        return ComputeEngineCredentials.getMetadataServerUrl(provider) + "/computeMetadata/v1/instance/service-accounts/default/token";
    }

    public static String getTokenServerEncodedUrl() {
        return ComputeEngineCredentials.getTokenServerEncodedUrl(DefaultCredentialsProvider.DEFAULT);
    }

    public static String getUniverseDomainUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT) + "/computeMetadata/v1/universe/universe_domain";
    }

    public static String getServiceAccountsUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT) + "/computeMetadata/v1/instance/service-accounts/?recursive=true";
    }

    public static String getIdentityDocumentUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT) + "/computeMetadata/v1/instance/service-accounts/default/identity";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transportFactoryClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        ComputeEngineCredentials computeEngineCredentials = this;
        synchronized (computeEngineCredentials) {
            return super.toStringHelper().add("transportFactoryClassName", this.transportFactoryClassName).add("scopes", this.scopes).add("universeDomainFromMetadata", this.universeDomainFromMetadata);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeEngineCredentials)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ComputeEngineCredentials other = (ComputeEngineCredentials)obj;
        return Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.universeDomainFromMetadata, other.universeDomainFromMetadata);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ComputeEngineCredentials.newInstance(this.transportFactoryClassName);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getAccount() {
        if (this.serviceAccountEmail == null) {
            try {
                this.serviceAccountEmail = this.getDefaultServiceAccount();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to get service account", ex);
            }
        }
        return this.serviceAccountEmail;
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            String account = this.getAccount();
            return IamUtils.sign(account, this, this.transportFactory.create(), toSign, Collections.emptyMap());
        }
        catch (ServiceAccountSigner.SigningException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ServiceAccountSigner.SigningException("Signing failed", ex);
        }
    }

    private String getDefaultServiceAccount() throws IOException {
        HttpResponse response = this.getMetadataResponse(ComputeEngineCredentials.getServiceAccountsUrl(), MetricsUtils.RequestType.UNTRACKED, false);
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            throw new IOException(String.format("Error code %s trying to get service accounts from Compute Engine metadata. This may be because the virtual machine instance does not have permission scopes specified.", statusCode));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to get service accounts from Compute Engine metadata: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        Map<String, Object> defaultAccount = OAuth2Utils.validateMap(responseData, "default", PARSE_ERROR_ACCOUNT);
        return OAuth2Utils.validateString(defaultAccount, "email", PARSE_ERROR_ACCOUNT);
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private HttpTransportFactory transportFactory;
        private Collection<String> scopes;
        private Collection<String> defaultScopes;

        protected Builder() {
            this.setRefreshMargin(COMPUTE_REFRESH_MARGIN);
            this.setExpirationMargin(COMPUTE_EXPIRATION_MARGIN);
        }

        protected Builder(ComputeEngineCredentials credentials) {
            super(credentials);
            this.transportFactory = credentials.transportFactory;
            this.scopes = credentials.scopes;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDefaultScopes(Collection<String> defaultScopes) {
            this.defaultScopes = defaultScopes;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        public Collection<String> getDefaultScopes() {
            return this.defaultScopes;
        }

        @Override
        public ComputeEngineCredentials build() {
            return new ComputeEngineCredentials(this);
        }
    }
}

