/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.List;

public class ListBuffer<A>
extends AbstractQueue<A> {
    private List<A> elems;
    private List<A> last;
    private int count;
    private boolean shared;

    public static <T> ListBuffer<T> of(T t2) {
        ListBuffer<T> listBuffer = new ListBuffer<T>();
        listBuffer.add(t2);
        return listBuffer;
    }

    public ListBuffer() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.elems = List.nil();
        this.last = null;
        this.count = 0;
        this.shared = false;
    }

    public int length() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        if (this.elems.nonEmpty()) {
            List<A> list = this.elems;
            this.last = List.of(list.head);
            this.elems = this.last;
            while ((list = list.tail).nonEmpty()) {
                this.last.tail = List.of(list.head);
                this.last = this.last.tail;
            }
        }
    }

    public ListBuffer<A> prepend(A a) {
        this.elems = this.elems.prepend(a);
        if (this.last == null) {
            this.last = this.elems;
        }
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A a) {
        Assert.checkNonNull(a);
        if (this.shared) {
            this.copy();
        }
        List<A> list = List.of(a);
        if (this.last != null) {
            this.last.tail = list;
            this.last = list;
        } else {
            this.last = list;
            this.elems = this.last;
        }
        ++this.count;
        return this;
    }

    public ListBuffer<A> appendList(List<A> list) {
        while (list.nonEmpty()) {
            this.append(list.head);
            list = list.tail;
        }
        return this;
    }

    public ListBuffer<A> appendList(ListBuffer<A> listBuffer) {
        return this.appendList(listBuffer.toList());
    }

    public ListBuffer<A> appendArray(A[] AArray) {
        for (A a : AArray) {
            this.append(a);
        }
        return this;
    }

    public List<A> toList() {
        this.shared = true;
        return this.elems;
    }

    @Override
    public boolean contains(Object object) {
        return this.elems.contains(object);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.elems.toArray(TArray);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public A first() {
        return this.elems.head;
    }

    public A next() {
        Object a = this.elems.head;
        if (!this.elems.isEmpty()) {
            this.elems = this.elems.tail;
            if (this.elems.isEmpty()) {
                this.last = null;
            }
            --this.count;
        }
        return a;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = ListBuffer.this.elems;
            }

            @Override
            public boolean hasNext() {
                return !this.elems.isEmpty();
            }

            @Override
            public A next() {
                if (this.elems.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object a = this.elems.head;
                this.elems = this.elems.tail;
                return a;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        this.append(a);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends A> collection) {
        for (A a : collection) {
            this.append(a);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(A a) {
        this.append(a);
        return true;
    }

    @Override
    public A poll() {
        return this.next();
    }

    @Override
    public A peek() {
        return this.first();
    }

    public A last() {
        return this.last != null ? (A)this.last.head : null;
    }
}

