/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import com.google.common.base.Preconditions;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.security.CommonTlsContextUtil;
import io.grpc.xds.internal.security.ReferenceCountingMap;
import io.grpc.xds.internal.security.SslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertProviderClientSslContextProviderFactory;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderClientSslContextProviderFactory certProviderClientSslContextProviderFactory;

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderClientSslContextProviderFactory.getInstance());
    }

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderClientSslContextProviderFactory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderClientSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        Preconditions.checkNotNull(upstreamTlsContext.getCommonTlsContext(), "upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderClientSslContextProviderFactory.getProvider(upstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

