/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.GaxProperties;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GaxPropertiesTest {
    private static String originalJavaVersion = System.getProperty("java.version");
    private static String originalJavaVendor = System.getProperty("java.vendor");
    private static String originalJavaVendorVersion = System.getProperty("java.vendor.version");

    @Test
    public void testGaxVersion() {
        String gaxVersion = GaxProperties.getGaxVersion();
        Assert.assertTrue(Pattern.compile("^\\d+\\.\\d+\\.\\d+").matcher(gaxVersion).find());
        String[] versionComponents = gaxVersion.split("\\.");
        int major = Integer.parseInt(versionComponents[0]);
        int minor = Integer.parseInt(versionComponents[1]);
        Assert.assertTrue(major >= 1);
        if (major == 1) {
            Assert.assertTrue(minor >= 56);
        }
    }

    @After
    public void cleanup() {
        if (Strings.isNullOrEmpty(originalJavaVersion)) {
            System.clearProperty("java.version");
        } else {
            System.setProperty("java.version", originalJavaVersion);
        }
        if (Strings.isNullOrEmpty(originalJavaVendor)) {
            System.clearProperty("java.vendor");
        } else {
            System.setProperty("java.vendor", originalJavaVendor);
        }
        if (Strings.isNullOrEmpty(originalJavaVendorVersion)) {
            System.clearProperty("java.vendor.version");
        } else {
            System.setProperty("java.vendor.version", originalJavaVendorVersion);
        }
    }

    @Test
    public void testGetJavaRuntimeInfo_graalVM() {
        System.setProperty("java.version", "17.0.3");
        System.setProperty("java.vendor", "GraalVM Community");
        System.setProperty("java.vendor.version", "GraalVM CE 22.1.0");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("17.0.3__GraalVM-Community__GraalVM-CE-22.1.0", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_temurin() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Eclipse Adoptium");
        System.setProperty("java.vendor.version", "Temurin-11.0.19+7");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("11.0.19__Eclipse-Adoptium__Temurin-11.0.19-7", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_coretto() {
        System.setProperty("java.version", "11.0.19");
        System.setProperty("java.vendor", "Amazon.com Inc.");
        System.setProperty("java.vendor.version", "Corretto-11.0.19.7.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("11.0.19__Amazon.com-Inc.__Corretto-11.0.19.7.1", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_specialCharacters() {
        System.setProperty("java.version", "20%^.&0~.1#45`*");
        System.setProperty("java.vendor", "A^!@#$*B()[]{} C ~%& D-E ?");
        System.setProperty("java.vendor.version", "1!@%$@#.AB!346.9^");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("20--.-0-.1-45--__A------B-------C-----D-E--__1------.AB-346.9-", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_nullVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.setProperty("java.vendor", "Oracle");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("20.0.1__Oracle", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_nullVendorAndVendorVersion() {
        System.setProperty("java.version", "20.0.1");
        System.clearProperty("java.vendor");
        System.clearProperty("java.vendor.version");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("20.0.1", runtimeInfo);
    }

    @Test
    public void testGetJavaRuntimeInfo_nullJavaVersion() {
        System.clearProperty("java.version");
        System.setProperty("java.vendor", "oracle");
        System.setProperty("java.vendor.version", "20.0.1");
        String runtimeInfo = GaxProperties.getRuntimeVersion();
        Assert.assertEquals("null__oracle__20.0.1", runtimeInfo);
    }
}

