/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class ReferenceConstructorExpr
implements Expr {
    @Override
    public abstract TypeNode type();

    public abstract KeywordKind keywordKind();

    public abstract ImmutableList<Expr> arguments();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder thisBuilder() {
        return new AutoValue_ReferenceConstructorExpr.Builder().setArguments(Collections.emptyList()).setKeywordKind(KeywordKind.THIS);
    }

    public static Builder superBuilder() {
        return new AutoValue_ReferenceConstructorExpr.Builder().setArguments(Collections.emptyList()).setKeywordKind(KeywordKind.SUPER);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public Builder setArguments(Expr ... arguments) {
            return this.setArguments(Arrays.asList(arguments));
        }

        public abstract Builder setArguments(List<Expr> var1);

        abstract Builder setKeywordKind(KeywordKind var1);

        abstract TypeNode type();

        abstract ImmutableList<Expr> arguments();

        abstract ReferenceConstructorExpr autoBuild();

        public ReferenceConstructorExpr build() {
            ReferenceConstructorExpr referenceConstructorExpr = this.autoBuild();
            Preconditions.checkState(TypeNode.isReferenceType(referenceConstructorExpr.type()), "A this/super constructor must have a reference type.");
            NodeValidator.checkNoNullElements(this.arguments(), "the \"this\" or \"super\" initialization", this.type().reference().name());
            return referenceConstructorExpr;
        }
    }

    public static enum KeywordKind {
        THIS,
        SUPER;

    }
}

