/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TypeParser {
    private static Reference REFERENCE_BYTE_STRING = ConcreteReference.withClazz(ByteString.class);
    private static TypeNode TYPE_NODE_BYTE_STRING = TypeNode.withReference(REFERENCE_BYTE_STRING);
    private static Map<Descriptors.FieldDescriptor.JavaType, TypeNode> SIMPLE_TYPE_MAP = ImmutableMap.builder().put(Descriptors.FieldDescriptor.JavaType.INT, TypeNode.INT).put(Descriptors.FieldDescriptor.JavaType.LONG, TypeNode.LONG).put(Descriptors.FieldDescriptor.JavaType.FLOAT, TypeNode.FLOAT).put(Descriptors.FieldDescriptor.JavaType.DOUBLE, TypeNode.DOUBLE).put(Descriptors.FieldDescriptor.JavaType.STRING, TypeNode.STRING).put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, TypeNode.BOOLEAN).put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, TYPE_NODE_BYTE_STRING).build();
    private static Map<Descriptors.FieldDescriptor.JavaType, Reference> SIMPLE_REFERENCE_MAP = ImmutableMap.builder().put(Descriptors.FieldDescriptor.JavaType.INT, ConcreteReference.withClazz(Integer.class)).put(Descriptors.FieldDescriptor.JavaType.LONG, ConcreteReference.withClazz(Long.class)).put(Descriptors.FieldDescriptor.JavaType.FLOAT, ConcreteReference.withClazz(Float.class)).put(Descriptors.FieldDescriptor.JavaType.DOUBLE, ConcreteReference.withClazz(Double.class)).put(Descriptors.FieldDescriptor.JavaType.STRING, ConcreteReference.withClazz(String.class)).put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, ConcreteReference.withClazz(Boolean.class)).put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, (ConcreteReference)REFERENCE_BYTE_STRING).build();

    public static TypeNode parseType(@Nonnull Descriptors.FieldDescriptor field) {
        if (field.isMapField()) {
            return TypeParser.createMapType(field);
        }
        if (field.isRepeated()) {
            return TypeParser.createListType(field);
        }
        Descriptors.FieldDescriptor.JavaType protoFieldType = field.getJavaType();
        boolean isEnum = protoFieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM);
        boolean isMessage = protoFieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE);
        if (!isEnum && !isMessage) {
            return SIMPLE_TYPE_MAP.get((Object)protoFieldType);
        }
        return TypeNode.withReference(TypeParser.parseFieldReference(field));
    }

    public static TypeNode parseType(@Nonnull Descriptors.Descriptor messageDescriptor) {
        return TypeNode.withReference(TypeParser.parseMessageReference(messageDescriptor));
    }

    public static TypeNode parseType(@Nonnull Descriptors.EnumDescriptor enumDescriptor) {
        return TypeNode.withReference(TypeParser.parseEnumReference(enumDescriptor));
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        String pakkage = fileDescriptor.getOptions().getJavaPackage();
        if (Strings.isNullOrEmpty(pakkage)) {
            pakkage = fileDescriptor.getPackage();
        }
        Preconditions.checkNotNull(pakkage, String.format("Java package in file %s was null", fileDescriptor.getName()));
        return pakkage;
    }

    @VisibleForTesting
    static Reference parseFieldReference(Descriptors.FieldDescriptor field) {
        Descriptors.FieldDescriptor.JavaType protoFieldType = field.getJavaType();
        boolean isEnum = protoFieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM);
        boolean isMessage = protoFieldType.equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE);
        if (!isEnum && !isMessage) {
            return SIMPLE_REFERENCE_MAP.get((Object)protoFieldType);
        }
        if (isMessage) {
            return TypeParser.parseMessageReference(field.getMessageType());
        }
        return TypeParser.parseEnumReference(field.getEnumType());
    }

    @VisibleForTesting
    static Reference parseMessageReference(@Nonnull Descriptors.Descriptor messageDescriptor) {
        boolean hasJavaOuterClass;
        String javaOuterClassname;
        ArrayList<String> outerNestedTypeNames = new ArrayList<String>();
        DescriptorProtos.FileOptions fileOptions = messageDescriptor.getFile().getOptions();
        String string = javaOuterClassname = fileOptions.hasJavaOuterClassname() ? fileOptions.getJavaOuterClassname() : null;
        if (!fileOptions.getJavaMultipleFiles() && !fileOptions.hasJavaOuterClassname()) {
            String fullFilePath = JavaStyle.toUpperCamelCase(messageDescriptor.getFile().getName());
            javaOuterClassname = JavaStyle.toUpperCamelCase(fullFilePath.substring(fullFilePath.lastIndexOf("/") + 1, fullFilePath.lastIndexOf(".")));
        }
        boolean bl = hasJavaOuterClass = !Strings.isNullOrEmpty(javaOuterClassname) && !fileOptions.getJavaMultipleFiles();
        if (hasJavaOuterClass) {
            outerNestedTypeNames.add(javaOuterClassname);
        }
        for (Descriptors.Descriptor containingType = messageDescriptor.getContainingType(); containingType != null; containingType = containingType.getContainingType()) {
            outerNestedTypeNames.add(hasJavaOuterClass ? 1 : 0, containingType.getName());
        }
        String pakkage = TypeParser.getPackage(messageDescriptor.getFile());
        VaporReference messageReference = VaporReference.builder().setName(messageDescriptor.getName()).setPakkage(pakkage).setEnclosingClassNames(outerNestedTypeNames).build();
        String protoPackage = messageDescriptor.getFile().getPackage();
        String messageFullName = messageDescriptor.getFullName();
        if (hasJavaOuterClass) {
            int packageIndex = protoPackage.length();
            messageFullName = String.format("%s.%s.%s", messageFullName.substring(0, packageIndex), javaOuterClassname, messageFullName.substring(packageIndex + 1));
        }
        Preconditions.checkState(messageReference.fullName().replace(pakkage, protoPackage).equals(messageFullName), String.format("Parsed message name %s does not match actual name %s", messageReference.fullName().replace(pakkage, ""), messageFullName.replace(protoPackage, "")));
        return messageReference;
    }

    @VisibleForTesting
    static Reference parseEnumReference(@Nonnull Descriptors.EnumDescriptor enumDescriptor) {
        String javaOuterClassname;
        DescriptorProtos.FileOptions fileOptions = enumDescriptor.getFile().getOptions();
        String string = javaOuterClassname = fileOptions.hasJavaOuterClassname() ? fileOptions.getJavaOuterClassname() : null;
        if (!fileOptions.getJavaMultipleFiles() && !fileOptions.hasJavaOuterClassname()) {
            String fullFilePath = JavaStyle.toUpperCamelCase(enumDescriptor.getFile().getName());
            javaOuterClassname = JavaStyle.toUpperCamelCase(fullFilePath.substring(fullFilePath.lastIndexOf("/") + 1, fullFilePath.lastIndexOf(".")));
        }
        boolean hasJavaOuterClass = !Strings.isNullOrEmpty(javaOuterClassname) && !fileOptions.getJavaMultipleFiles();
        ArrayList<String> outerNestedTypeNames = new ArrayList<String>();
        if (hasJavaOuterClass) {
            outerNestedTypeNames.add(javaOuterClassname);
        }
        for (Descriptors.Descriptor containingType = enumDescriptor.getContainingType(); containingType != null; containingType = containingType.getContainingType()) {
            outerNestedTypeNames.add(hasJavaOuterClass ? 1 : 0, containingType.getName());
        }
        String pakkage = TypeParser.getPackage(enumDescriptor.getFile());
        VaporReference enumReference = VaporReference.builder().setName(enumDescriptor.getName()).setPakkage(pakkage).setEnclosingClassNames(outerNestedTypeNames).build();
        String protoPackage = enumDescriptor.getFile().getPackage();
        String enumFullName = enumDescriptor.getFullName();
        if (hasJavaOuterClass) {
            int packageIndex = protoPackage.length();
            enumFullName = String.format("%s.%s.%s", enumFullName.substring(0, packageIndex), javaOuterClassname, enumFullName.substring(packageIndex + 1));
        }
        Preconditions.checkState(enumReference.fullName().replace(pakkage, protoPackage).equals(enumFullName), String.format("Parsed enum name %s does not match actual name %s", enumReference.fullName().replace(pakkage, ""), enumDescriptor.getFullName().replace(protoPackage, "")));
        return enumReference;
    }

    @VisibleForTesting
    static TypeNode createListType(Descriptors.FieldDescriptor field) {
        ConcreteReference listReference = ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(TypeParser.parseFieldReference(field))).build();
        return TypeNode.withReference(listReference);
    }

    @VisibleForTesting
    static TypeNode createMapType(Descriptors.FieldDescriptor field) {
        Preconditions.checkState(field.isMapField(), "createMapType can only be called on map-type fields");
        Descriptors.Descriptor type = field.getMessageType();
        Descriptors.FieldDescriptor keyField = type.findFieldByName("key");
        Descriptors.FieldDescriptor valueField = type.findFieldByName("value");
        Reference keyReference = TypeParser.parseFieldReference(keyField);
        Reference valueReference = TypeParser.parseFieldReference(valueField);
        ConcreteReference mapReference = ConcreteReference.builder().setClazz(Map.class).setGenerics(Arrays.asList(keyReference, valueReference)).build();
        return TypeNode.withReference(mapReference);
    }
}

