/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AutoValue_Variable;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class Variable {
    public abstract IdentifierNode identifier();

    public abstract TypeNode type();

    abstract String name();

    public static Builder builder() {
        return new AutoValue_Variable.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public abstract Builder setName(String var1);

        abstract String name();

        abstract Builder setIdentifier(IdentifierNode var1);

        abstract Variable autoBuild();

        public Variable build() {
            IdentifierNode identifier = IdentifierNode.builder().setName(this.name()).buildVariableIdentifier();
            this.setIdentifier(identifier);
            Variable variable = this.autoBuild();
            Preconditions.checkState(!variable.type().typeKind().equals((Object)TypeNode.TypeKind.VOID), "Variable type cannot be void");
            Preconditions.checkState(!variable.type().equals(TypeNode.NULL), "Variable type cannot be null");
            return variable;
        }
    }
}

