/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedInteger;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.Status;
import io.grpc.xds.ClusterSpecifierPlugin;
import io.grpc.xds.ClusterSpecifierPluginRegistry;
import io.grpc.xds.ConfigOrError;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.internal.MatcherParser;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.FilterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RetryPolicy;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class XdsRouteConfigureResource
extends XdsResourceType<RdsUpdate> {
    static final String ADS_TYPE_URL_RDS = "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    private static final String TYPE_URL_FILTER_CONFIG = "type.googleapis.com/envoy.config.route.v3.FilterConfig";
    private static final Set<Status.Code> SUPPORTED_RETRYABLE_CODES = Collections.unmodifiableSet(EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE));
    private static final XdsRouteConfigureResource instance = new XdsRouteConfigureResource();

    XdsRouteConfigureResource() {
    }

    public static XdsRouteConfigureResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof RouteConfiguration)) {
            return null;
        }
        return ((RouteConfiguration)unpackedResource).getName();
    }

    @Override
    String typeName() {
        return "RDS";
    }

    @Override
    String typeUrl() {
        return ADS_TYPE_URL_RDS;
    }

    @Override
    boolean isFullStateOfTheWorld() {
        return false;
    }

    @Override
    Class<RouteConfiguration> unpackedClassName() {
        return RouteConfiguration.class;
    }

    @Override
    RdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsClientImpl.ResourceInvalidException {
        if (!(unpackedMessage instanceof RouteConfiguration)) {
            throw new XdsClientImpl.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        return XdsRouteConfigureResource.processRouteConfiguration((RouteConfiguration)unpackedMessage, args.filterRegistry, enableFaultInjection);
    }

    private static RdsUpdate processRouteConfiguration(RouteConfiguration routeConfig, FilterRegistry filterRegistry, boolean parseHttpFilter) throws XdsClientImpl.ResourceInvalidException {
        return new RdsUpdate(XdsRouteConfigureResource.extractVirtualHosts(routeConfig, filterRegistry, parseHttpFilter));
    }

    static List<io.grpc.xds.VirtualHost> extractVirtualHosts(RouteConfiguration routeConfig, FilterRegistry filterRegistry, boolean parseHttpFilter) throws XdsClientImpl.ResourceInvalidException {
        HashMap<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap = new HashMap<String, ClusterSpecifierPlugin.PluginConfig>();
        ImmutableSet.Builder optionalPlugins = ImmutableSet.builder();
        if (enableRouteLookup) {
            List<io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin> plugins = routeConfig.getClusterSpecifierPluginsList();
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin plugin : plugins) {
                String pluginName = plugin.getExtension().getName();
                ClusterSpecifierPlugin.PluginConfig pluginConfig = XdsRouteConfigureResource.parseClusterSpecifierPlugin(plugin);
                if (pluginConfig != null) {
                    if (pluginConfigMap.put(pluginName, pluginConfig) == null) continue;
                    throw new XdsClientImpl.ResourceInvalidException("Multiple ClusterSpecifierPlugins with the same name: " + pluginName);
                }
                optionalPlugins.add(pluginName);
            }
        }
        ArrayList<io.grpc.xds.VirtualHost> virtualHosts = new ArrayList<io.grpc.xds.VirtualHost>(routeConfig.getVirtualHostsCount());
        for (VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
            XdsResourceType.StructOrError<io.grpc.xds.VirtualHost> virtualHost = XdsRouteConfigureResource.parseVirtualHost(virtualHostProto, filterRegistry, parseHttpFilter, pluginConfigMap, (Set<String>)((Object)optionalPlugins.build()));
            if (virtualHost.getErrorDetail() != null) {
                throw new XdsClientImpl.ResourceInvalidException("RouteConfiguration contains invalid virtual host: " + virtualHost.getErrorDetail());
            }
            virtualHosts.add(virtualHost.getStruct());
        }
        return virtualHosts;
    }

    private static XdsResourceType.StructOrError<io.grpc.xds.VirtualHost> parseVirtualHost(VirtualHost proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        String name = proto.getName();
        ArrayList<VirtualHost.Route> routes = new ArrayList<VirtualHost.Route>(proto.getRoutesCount());
        for (Route routeProto : proto.getRoutesList()) {
            XdsResourceType.StructOrError<VirtualHost.Route> route = XdsRouteConfigureResource.parseRoute(routeProto, filterRegistry, parseHttpFilter, pluginConfigMap, optionalPlugins);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                return XdsResourceType.StructOrError.fromError("Virtual host [" + name + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        if (!parseHttpFilter) {
            return XdsResourceType.StructOrError.fromStruct(io.grpc.xds.VirtualHost.create(name, proto.getDomainsList(), routes, new HashMap<String, Filter.FilterConfig>()));
        }
        XdsResourceType.StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (overrideConfigs.getErrorDetail() != null) {
            return XdsResourceType.StructOrError.fromError("VirtualHost [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigs.getErrorDetail());
        }
        return XdsResourceType.StructOrError.fromStruct(io.grpc.xds.VirtualHost.create(name, proto.getDomainsList(), routes, overrideConfigs.getStruct()));
    }

    @VisibleForTesting
    static XdsResourceType.StructOrError<Map<String, Filter.FilterConfig>> parseOverrideFilterConfigs(Map<String, Any> rawFilterConfigMap, FilterRegistry filterRegistry) {
        HashMap<String, Filter.FilterConfig> overrideConfigs = new HashMap<String, Filter.FilterConfig>();
        for (String name : rawFilterConfigMap.keySet()) {
            Any anyConfig = rawFilterConfigMap.get(name);
            String typeUrl = anyConfig.getTypeUrl();
            boolean isOptional = false;
            if (typeUrl.equals(TYPE_URL_FILTER_CONFIG)) {
                FilterConfig filterConfig;
                try {
                    filterConfig = anyConfig.unpack(FilterConfig.class);
                }
                catch (InvalidProtocolBufferException e) {
                    return XdsResourceType.StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
                }
                isOptional = filterConfig.getIsOptional();
                anyConfig = filterConfig.getConfig();
                typeUrl = anyConfig.getTypeUrl();
            }
            GeneratedMessageV3 rawConfig = anyConfig;
            try {
                if (typeUrl.equals("type.googleapis.com/udpa.type.v1.TypedStruct")) {
                    io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct typedStruct = anyConfig.unpack(io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class);
                    typeUrl = typedStruct.getTypeUrl();
                    rawConfig = typedStruct.getValue();
                } else if (typeUrl.equals("type.googleapis.com/xds.type.v3.TypedStruct")) {
                    TypedStruct newTypedStruct = anyConfig.unpack(TypedStruct.class);
                    typeUrl = newTypedStruct.getTypeUrl();
                    rawConfig = newTypedStruct.getValue();
                }
            }
            catch (InvalidProtocolBufferException e) {
                return XdsResourceType.StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
            }
            Filter filter = filterRegistry.get(typeUrl);
            if (filter == null) {
                if (isOptional) continue;
                return XdsResourceType.StructOrError.fromError("HttpFilter [" + name + "](" + typeUrl + ") is required but unsupported");
            }
            ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfigOverride(rawConfig);
            if (filterConfig.errorDetail != null) {
                return XdsResourceType.StructOrError.fromError("Invalid filter config for HttpFilter [" + name + "]: " + filterConfig.errorDetail);
            }
            overrideConfigs.put(name, (Filter.FilterConfig)filterConfig.config);
        }
        return XdsResourceType.StructOrError.fromStruct(overrideConfigs);
    }

    @Nullable
    @VisibleForTesting
    static XdsResourceType.StructOrError<VirtualHost.Route> parseRoute(Route proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        XdsResourceType.StructOrError<VirtualHost.Route.RouteMatch> routeMatch = XdsRouteConfigureResource.parseRouteMatch(proto.getMatch());
        if (routeMatch == null) {
            return null;
        }
        if (routeMatch.getErrorDetail() != null) {
            return XdsResourceType.StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteMatch: " + routeMatch.getErrorDetail());
        }
        Map<String, Filter.FilterConfig> overrideConfigs = Collections.emptyMap();
        if (parseHttpFilter) {
            XdsResourceType.StructOrError<Map<String, Filter.FilterConfig>> overrideConfigsOrError = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
            if (overrideConfigsOrError.getErrorDetail() != null) {
                return XdsResourceType.StructOrError.fromError("Route [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigsOrError.getErrorDetail());
            }
            overrideConfigs = overrideConfigsOrError.getStruct();
        }
        switch (proto.getActionCase()) {
            case ROUTE: {
                XdsResourceType.StructOrError<VirtualHost.Route.RouteAction> routeAction = XdsRouteConfigureResource.parseRouteAction(proto.getRoute(), filterRegistry, parseHttpFilter, pluginConfigMap, optionalPlugins);
                if (routeAction == null) {
                    return null;
                }
                if (routeAction.getErrorDetail() != null) {
                    return XdsResourceType.StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteAction: " + routeAction.getErrorDetail());
                }
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.forAction(routeMatch.getStruct(), routeAction.getStruct(), overrideConfigs));
            }
            case NON_FORWARDING_ACTION: {
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.forNonForwardingAction(routeMatch.getStruct(), overrideConfigs));
            }
        }
        return XdsResourceType.StructOrError.fromError("Route [" + proto.getName() + "] with unknown action type: " + proto.getActionCase());
    }

    @Nullable
    @VisibleForTesting
    static XdsResourceType.StructOrError<VirtualHost.Route.RouteMatch> parseRouteMatch(RouteMatch proto) {
        if (proto.getQueryParametersCount() != 0) {
            return null;
        }
        XdsResourceType.StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> pathMatch = XdsRouteConfigureResource.parsePathMatcher(proto);
        if (pathMatch.getErrorDetail() != null) {
            return XdsResourceType.StructOrError.fromError(pathMatch.getErrorDetail());
        }
        Matchers.FractionMatcher fractionMatch = null;
        if (proto.hasRuntimeFraction()) {
            XdsResourceType.StructOrError<Matchers.FractionMatcher> parsedFraction = XdsRouteConfigureResource.parseFractionMatcher(proto.getRuntimeFraction().getDefaultValue());
            if (parsedFraction.getErrorDetail() != null) {
                return XdsResourceType.StructOrError.fromError(parsedFraction.getErrorDetail());
            }
            fractionMatch = parsedFraction.getStruct();
        }
        ArrayList<Matchers.HeaderMatcher> headerMatchers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher hmProto : proto.getHeadersList()) {
            XdsResourceType.StructOrError<Matchers.HeaderMatcher> headerMatcher = XdsRouteConfigureResource.parseHeaderMatcher(hmProto);
            if (headerMatcher.getErrorDetail() != null) {
                return XdsResourceType.StructOrError.fromError(headerMatcher.getErrorDetail());
            }
            headerMatchers.add(headerMatcher.getStruct());
        }
        return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteMatch.create(pathMatch.getStruct(), headerMatchers, fractionMatch));
    }

    @VisibleForTesting
    static XdsResourceType.StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> parsePathMatcher(RouteMatch proto) {
        boolean caseSensitive = proto.getCaseSensitive().getValue();
        switch (proto.getPathSpecifierCase()) {
            case PREFIX: {
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPrefix(proto.getPrefix(), caseSensitive));
            }
            case PATH: {
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPath(proto.getPath(), caseSensitive));
            }
            case SAFE_REGEX: {
                Pattern safeRegEx;
                String rawPattern = proto.getSafeRegex().getRegex();
                try {
                    safeRegEx = Pattern.compile(rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return XdsResourceType.StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                }
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromRegEx(safeRegEx));
            }
        }
        return XdsResourceType.StructOrError.fromError("Unknown path match type");
    }

    private static XdsResourceType.StructOrError<Matchers.FractionMatcher> parseFractionMatcher(FractionalPercent proto) {
        int numerator = proto.getNumerator();
        int denominator = 0;
        switch (proto.getDenominator()) {
            case HUNDRED: {
                denominator = 100;
                break;
            }
            case TEN_THOUSAND: {
                denominator = 10000;
                break;
            }
            case MILLION: {
                denominator = 1000000;
                break;
            }
            default: {
                return XdsResourceType.StructOrError.fromError("Unrecognized fractional percent denominator: " + proto.getDenominator());
            }
        }
        return XdsResourceType.StructOrError.fromStruct(Matchers.FractionMatcher.create(numerator, denominator));
    }

    @VisibleForTesting
    static XdsResourceType.StructOrError<Matchers.HeaderMatcher> parseHeaderMatcher(HeaderMatcher proto) {
        try {
            Matchers.HeaderMatcher headerMatcher = MatcherParser.parseHeaderMatcher(proto);
            return XdsResourceType.StructOrError.fromStruct(headerMatcher);
        }
        catch (IllegalArgumentException e) {
            return XdsResourceType.StructOrError.fromError(e.getMessage());
        }
    }

    @Nullable
    @VisibleForTesting
    static XdsResourceType.StructOrError<VirtualHost.Route.RouteAction> parseRouteAction(RouteAction proto, FilterRegistry filterRegistry, boolean parseHttpFilter, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins) {
        XdsResourceType.StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> retryPolicyOrError;
        Long timeoutNano = null;
        if (proto.hasMaxStreamDuration()) {
            RouteAction.MaxStreamDuration maxStreamDuration = proto.getMaxStreamDuration();
            if (maxStreamDuration.hasGrpcTimeoutHeaderMax()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getGrpcTimeoutHeaderMax());
            } else if (maxStreamDuration.hasMaxStreamDuration()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getMaxStreamDuration());
            }
        }
        VirtualHost.Route.RouteAction.RetryPolicy retryPolicy = null;
        if (enableRetry && proto.hasRetryPolicy() && (retryPolicyOrError = XdsRouteConfigureResource.parseRetryPolicy(proto.getRetryPolicy())) != null) {
            if (retryPolicyOrError.getErrorDetail() != null) {
                return XdsResourceType.StructOrError.fromError(retryPolicyOrError.getErrorDetail());
            }
            retryPolicy = retryPolicyOrError.getStruct();
        }
        ArrayList<VirtualHost.Route.RouteAction.HashPolicy> hashPolicies = new ArrayList<VirtualHost.Route.RouteAction.HashPolicy>();
        for (RouteAction.HashPolicy config : proto.getHashPolicyList()) {
            VirtualHost.Route.RouteAction.HashPolicy policy = null;
            boolean terminal = config.getTerminal();
            switch (config.getPolicySpecifierCase()) {
                case HEADER: {
                    RouteAction.HashPolicy.Header headerCfg = config.getHeader();
                    Pattern regEx = null;
                    String regExSubstitute = null;
                    if (headerCfg.hasRegexRewrite() && headerCfg.getRegexRewrite().hasPattern() && headerCfg.getRegexRewrite().getPattern().hasGoogleRe2()) {
                        regEx = Pattern.compile(headerCfg.getRegexRewrite().getPattern().getRegex());
                        regExSubstitute = headerCfg.getRegexRewrite().getSubstitution();
                    }
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forHeader(terminal, headerCfg.getHeaderName(), regEx, regExSubstitute);
                    break;
                }
                case FILTER_STATE: {
                    if (!config.getFilterState().getKey().equals("io.grpc.channel_id")) break;
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forChannelId(terminal);
                    break;
                }
            }
            if (policy == null) continue;
            hashPolicies.add(policy);
        }
        switch (proto.getClusterSpecifierCase()) {
            case CLUSTER: {
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.forCluster(proto.getCluster(), hashPolicies, timeoutNano, retryPolicy));
            }
            case CLUSTER_HEADER: {
                return null;
            }
            case WEIGHTED_CLUSTERS: {
                List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                if (clusterWeights.isEmpty()) {
                    return XdsResourceType.StructOrError.fromError("No cluster found in weighted cluster list");
                }
                ArrayList<VirtualHost.Route.RouteAction.ClusterWeight> weightedClusters = new ArrayList<VirtualHost.Route.RouteAction.ClusterWeight>();
                long clusterWeightSum = 0L;
                for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                    XdsResourceType.StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> clusterWeightOrError = XdsRouteConfigureResource.parseClusterWeight(clusterWeight, filterRegistry, parseHttpFilter);
                    if (clusterWeightOrError.getErrorDetail() != null) {
                        return XdsResourceType.StructOrError.fromError("RouteAction contains invalid ClusterWeight: " + clusterWeightOrError.getErrorDetail());
                    }
                    clusterWeightSum += (long)clusterWeight.getWeight().getValue();
                    weightedClusters.add(clusterWeightOrError.getStruct());
                }
                if (clusterWeightSum <= 0L) {
                    return XdsResourceType.StructOrError.fromError("Sum of cluster weights should be above 0.");
                }
                if (clusterWeightSum > UnsignedInteger.MAX_VALUE.longValue()) {
                    return XdsResourceType.StructOrError.fromError(String.format("Sum of cluster weights should be less than the maximum unsigned integer (%d), but was %d. ", UnsignedInteger.MAX_VALUE.longValue(), clusterWeightSum));
                }
                return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.forWeightedClusters(weightedClusters, hashPolicies, timeoutNano, retryPolicy));
            }
            case CLUSTER_SPECIFIER_PLUGIN: {
                if (enableRouteLookup) {
                    String pluginName = proto.getClusterSpecifierPlugin();
                    ClusterSpecifierPlugin.PluginConfig pluginConfig = pluginConfigMap.get(pluginName);
                    if (pluginConfig == null) {
                        if (optionalPlugins.contains(pluginName)) {
                            return null;
                        }
                        return XdsResourceType.StructOrError.fromError("ClusterSpecifierPlugin for [" + pluginName + "] not found");
                    }
                    ClusterSpecifierPlugin.NamedPluginConfig namedPluginConfig = ClusterSpecifierPlugin.NamedPluginConfig.create(pluginName, pluginConfig);
                    return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.forClusterSpecifierPlugin(namedPluginConfig, hashPolicies, timeoutNano, retryPolicy));
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static XdsResourceType.StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> parseRetryPolicy(RetryPolicy retryPolicyProto) {
        int maxAttempts = 2;
        if (retryPolicyProto.hasNumRetries()) {
            maxAttempts = retryPolicyProto.getNumRetries().getValue() + 1;
        }
        Duration initialBackoff = Durations.fromMillis(25L);
        Duration maxBackoff = Durations.fromMillis(250L);
        if (retryPolicyProto.hasRetryBackOff()) {
            RetryPolicy.RetryBackOff retryBackOff = retryPolicyProto.getRetryBackOff();
            if (!retryBackOff.hasBaseInterval()) {
                return XdsResourceType.StructOrError.fromError("No base_interval specified in retry_backoff");
            }
            Duration originalInitialBackoff = initialBackoff = retryBackOff.getBaseInterval();
            if (Durations.compare(initialBackoff, Durations.ZERO) <= 0) {
                return XdsResourceType.StructOrError.fromError("base_interval in retry_backoff must be positive");
            }
            if (Durations.compare(initialBackoff, Durations.fromMillis(1L)) < 0) {
                initialBackoff = Durations.fromMillis(1L);
            }
            if (retryBackOff.hasMaxInterval()) {
                maxBackoff = retryPolicyProto.getRetryBackOff().getMaxInterval();
                if (Durations.compare(maxBackoff, originalInitialBackoff) < 0) {
                    return XdsResourceType.StructOrError.fromError("max_interval in retry_backoff cannot be less than base_interval");
                }
                if (Durations.compare(maxBackoff, Durations.fromMillis(1L)) < 0) {
                    maxBackoff = Durations.fromMillis(1L);
                }
            } else {
                maxBackoff = Durations.fromNanos(Durations.toNanos(initialBackoff) * 10L);
            }
        }
        Iterable<String> retryOns = Splitter.on(',').omitEmptyStrings().trimResults().split(retryPolicyProto.getRetryOn());
        ImmutableList.Builder retryableStatusCodesBuilder = ImmutableList.builder();
        for (String retryOn : retryOns) {
            Status.Code code;
            try {
                code = Status.Code.valueOf(retryOn.toUpperCase(Locale.US).replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!SUPPORTED_RETRYABLE_CODES.contains((Object)code)) continue;
            retryableStatusCodesBuilder.add((Object)code);
        }
        ImmutableCollection retryableStatusCodes = retryableStatusCodesBuilder.build();
        return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.RetryPolicy.create(maxAttempts, (List<Status.Code>)((Object)retryableStatusCodes), initialBackoff, maxBackoff, null));
    }

    @VisibleForTesting
    static XdsResourceType.StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> parseClusterWeight(WeightedCluster.ClusterWeight proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        if (!parseHttpFilter) {
            return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), new HashMap<String, Filter.FilterConfig>()));
        }
        XdsResourceType.StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (overrideConfigs.getErrorDetail() != null) {
            return XdsResourceType.StructOrError.fromError("ClusterWeight [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigs.getErrorDetail());
        }
        return XdsResourceType.StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), overrideConfigs.getStruct()));
    }

    @Nullable
    private static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto) throws XdsClientImpl.ResourceInvalidException {
        return XdsRouteConfigureResource.parseClusterSpecifierPlugin(pluginProto, ClusterSpecifierPluginRegistry.getDefaultRegistry());
    }

    @Nullable
    @VisibleForTesting
    static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto, ClusterSpecifierPluginRegistry registry) throws XdsClientImpl.ResourceInvalidException {
        ClusterSpecifierPlugin plugin;
        TypedExtensionConfig extension = pluginProto.getExtension();
        String pluginName = extension.getName();
        Any anyConfig = extension.getTypedConfig();
        String typeUrl = anyConfig.getTypeUrl();
        GeneratedMessageV3 rawConfig = anyConfig;
        if (typeUrl.equals("type.googleapis.com/udpa.type.v1.TypedStruct") || typeUrl.equals("type.googleapis.com/xds.type.v3.TypedStruct")) {
            try {
                io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct typedStruct = XdsRouteConfigureResource.unpackCompatibleType(anyConfig, io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class, "type.googleapis.com/udpa.type.v1.TypedStruct", "type.googleapis.com/xds.type.v3.TypedStruct");
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            }
            catch (InvalidProtocolBufferException e) {
                throw new XdsClientImpl.ResourceInvalidException("ClusterSpecifierPlugin [" + pluginName + "] contains invalid proto", e);
            }
        }
        if ((plugin = registry.get(typeUrl)) == null) {
            if (!pluginProto.getIsOptional()) {
                throw new XdsClientImpl.ResourceInvalidException("Unsupported ClusterSpecifierPlugin type: " + typeUrl);
            }
            return null;
        }
        ConfigOrError<? extends ClusterSpecifierPlugin.PluginConfig> pluginConfigOrError = plugin.parsePlugin(rawConfig);
        if (pluginConfigOrError.errorDetail != null) {
            throw new XdsClientImpl.ResourceInvalidException(pluginConfigOrError.errorDetail);
        }
        return (ClusterSpecifierPlugin.PluginConfig)pluginConfigOrError.config;
    }

    static final class RdsUpdate
    implements XdsClient.ResourceUpdate {
        final List<io.grpc.xds.VirtualHost> virtualHosts;

        RdsUpdate(List<io.grpc.xds.VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(virtualHosts, "virtualHosts")));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }
}

