/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.ClientProto;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.ResourceReference;
import com.google.api.generator.gapic.protoparser.ResourceParserHelpers;
import com.google.api.generator.gapic.protoparser.ResourceReferenceParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodSignatureParser {
    private static final String DOT = ".";
    private static final String METHOD_SIGNATURE_DELIMITER = "\\s*,\\s*";

    public static List<List<MethodArgument>> parseMethodSignatures(Descriptors.MethodDescriptor methodDescriptor, String servicePackage, TypeNode methodInputType, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Set<ResourceName> outputArgResourceNames) {
        List<String> stringSigs = methodDescriptor.getOptions().getExtension(ClientProto.methodSignature);
        ArrayList<List<MethodArgument>> signatures = new ArrayList<List<MethodArgument>>();
        if (stringSigs.isEmpty()) {
            return signatures;
        }
        Map<String, ResourceName> patternsToResourceNames = ResourceParserHelpers.createPatternResourceNameMap(resourceNames);
        Message inputMessage = messageTypes.get(methodInputType.reference().fullName());
        for (String stringSig : stringSigs) {
            if (Strings.isNullOrEmpty(stringSig)) {
                signatures.add(Collections.emptyList());
                continue;
            }
            ArrayList<String> argumentNames = new ArrayList<String>();
            HashMap<String, List<MethodArgument>> argumentNameToOverloads = new HashMap<String, List<MethodArgument>>();
            for (String argumentName : stringSig.split(METHOD_SIGNATURE_DELIMITER)) {
                ArrayList<Field> argumentFieldPathAcc = new ArrayList<Field>();
                Map<TypeNode, Field> argumentTypes = MethodSignatureParser.parseTypeFromArgumentName(argumentName, servicePackage, inputMessage, messageTypes, resourceNames, patternsToResourceNames, argumentFieldPathAcc, outputArgResourceNames);
                int dotLastIndex = argumentName.lastIndexOf(DOT);
                String actualArgumentName = dotLastIndex < 0 ? argumentName : argumentName.substring(dotLastIndex + 1);
                argumentNames.add(actualArgumentName);
                argumentNameToOverloads.put(actualArgumentName, argumentTypes.entrySet().stream().map(e -> MethodArgument.builder().setName(actualArgumentName).setType((TypeNode)e.getKey()).setField((Field)e.getValue()).setIsResourceNameHelper(argumentTypes.size() > 1 && !((TypeNode)e.getKey()).equals(TypeNode.STRING)).setNestedFields(argumentFieldPathAcc).build()).collect(Collectors.toList()));
            }
            signatures.addAll(MethodSignatureParser.flattenMethodSignatureVariants(argumentNames, argumentNameToOverloads));
        }
        List<List<MethodArgument>> sortedMethodSignatures = signatures.stream().sorted((s1, s2) -> {
            if (s1.size() != s2.size()) {
                return s1.size() - s2.size();
            }
            for (int i = 0; i < s1.size(); ++i) {
                int compareVal = ((MethodArgument)s1.get(i)).compareTo((MethodArgument)s2.get(i));
                if (compareVal == 0) continue;
                return compareVal;
            }
            return 0;
        }).collect(Collectors.toList());
        return sortedMethodSignatures;
    }

    @VisibleForTesting
    static List<List<MethodArgument>> flattenMethodSignatureVariants(List<String> argumentNames, Map<String, List<MethodArgument>> argumentNameToOverloads) {
        Preconditions.checkState(argumentNames.size() == argumentNameToOverloads.size(), String.format("Cardinality of argument names %s do not match that of overloaded types %s", argumentNames, argumentNameToOverloads));
        for (String name : argumentNames) {
            Preconditions.checkNotNull(argumentNameToOverloads.get(name), String.format("No corresponding overload types found for argument %s", name));
        }
        return MethodSignatureParser.flattenMethodSignatureVariants(argumentNames, argumentNameToOverloads, 0);
    }

    private static List<List<MethodArgument>> flattenMethodSignatureVariants(List<String> argumentNames, Map<String, List<MethodArgument>> argumentNameToOverloads, int depth) {
        ArrayList<List<MethodArgument>> methodArgs = new ArrayList<List<MethodArgument>>();
        if (depth >= argumentNames.size() - 1) {
            for (MethodArgument methodArg : argumentNameToOverloads.get(argumentNames.get(depth))) {
                methodArgs.add(Lists.newArrayList(methodArg));
            }
            return methodArgs;
        }
        List<List<MethodArgument>> subsequentArgs = MethodSignatureParser.flattenMethodSignatureVariants(argumentNames, argumentNameToOverloads, depth + 1);
        for (MethodArgument methodArg : argumentNameToOverloads.get(argumentNames.get(depth))) {
            for (List<MethodArgument> subsequentArg : subsequentArgs) {
                ArrayList<MethodArgument> appendedArgs = new ArrayList<MethodArgument>(subsequentArg);
                appendedArgs.add(0, methodArg);
                methodArgs.add(appendedArgs);
            }
        }
        return methodArgs;
    }

    private static Map<TypeNode, Field> parseTypeFromArgumentName(String argumentName, String servicePackage, Message inputMessage, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Map<String, ResourceName> patternsToResourceNames, List<Field> argumentFieldPathAcc, Set<ResourceName> outputArgResourceNames) {
        HashMap<TypeNode, Field> typeToField = new HashMap<TypeNode, Field>();
        int dotIndex = argumentName.indexOf(DOT);
        if (dotIndex < 1) {
            Field field = inputMessage.fieldMap().get(argumentName);
            Preconditions.checkNotNull(field, String.format("Field %s not found from input message %s values %s", argumentName, inputMessage.name(), inputMessage.fieldMap().keySet()));
            if (!field.hasResourceReference()) {
                typeToField.put(field.type(), field);
                return typeToField;
            }
            List<ResourceName> resourceNameArgs = ResourceReferenceParser.parseResourceNames(field.resourceReference(), servicePackage, field.description(), resourceNames, patternsToResourceNames);
            outputArgResourceNames.addAll(resourceNameArgs);
            typeToField.put(TypeNode.STRING, field);
            typeToField.putAll(resourceNameArgs.stream().collect(Collectors.toMap(r -> r.type(), r -> field.toBuilder().setResourceReference(ResourceReference.withType(r.resourceTypeString())).build())));
            if (typeToField.size() > 1) {
                typeToField.entrySet().stream().forEach(e -> {
                    if (((TypeNode)e.getKey()).equals(TypeNode.STRING) || ((TypeNode)e.getKey()).reference().name().equals("ResourceName")) {
                        return;
                    }
                    String resourceJavaTypeName = ((TypeNode)e.getKey()).reference().name();
                    String resourceTypeName = ((Field)e.getValue()).resourceReference().resourceTypeString();
                    int indexOfSlash = resourceTypeName.indexOf("/");
                    Preconditions.checkState(resourceJavaTypeName.substring(0, resourceJavaTypeName.length() - 4).equals(resourceTypeName.substring(indexOfSlash + 1)), String.format("Resource Java type %s does not correspond to proto type %s", resourceJavaTypeName, resourceTypeName));
                });
            }
            return typeToField;
        }
        Preconditions.checkState(dotIndex < argumentName.length() - 1, String.format("Invalid argument name found: dot cannot be at the end of name %s", argumentName));
        String firstFieldName = argumentName.substring(0, dotIndex);
        String remainingArgumentName = argumentName.substring(dotIndex + 1);
        Field firstField = inputMessage.fieldMap().get(firstFieldName);
        Preconditions.checkState(!firstField.isRepeated(), String.format("Cannot descend into repeated field %s", firstField.name()));
        TypeNode firstFieldType = firstField.type();
        Preconditions.checkState(TypeNode.isReferenceType(firstFieldType) && !firstFieldType.equals(TypeNode.STRING), String.format("Field reference on %s cannot be a primitive type", firstFieldName));
        String firstFieldTypeName = firstFieldType.reference().fullName();
        Message firstFieldMessage = messageTypes.get(firstFieldTypeName);
        Preconditions.checkNotNull(firstFieldMessage, String.format("Message type %s for field reference %s invalid", firstFieldTypeName, firstFieldName));
        argumentFieldPathAcc.add(firstField);
        return MethodSignatureParser.parseTypeFromArgumentName(remainingArgumentName, servicePackage, firstFieldMessage, messageTypes, resourceNames, patternsToResourceNames, argumentFieldPathAcc, outputArgResourceNames);
    }
}

