/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.resourcename;

import com.google.api.core.BetaApi;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AssignmentOperationExpr;
import com.google.api.generator.engine.ast.CastExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.ForStatement;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.JavaDocComment;
import com.google.api.generator.engine.ast.LogicalOperationExpr;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.SynchronizedStatement;
import com.google.api.generator.engine.ast.TernaryExpr;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.comment.CommentComposer;
import com.google.api.generator.gapic.composer.resourcename.ResourceNameTokenizer;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;

public class ResourceNameHelperClassComposer {
    private static final String CLASS_NAME_PATTERN = "%sName";
    private static final String BUILDER_CLASS_HEADER_PATTERN = "Builder for %s.";
    private static final ResourceNameHelperClassComposer INSTANCE = new ResourceNameHelperClassComposer();
    private static final TypeStore FIXED_TYPESTORE = ResourceNameHelperClassComposer.createStaticTypes();
    private static final Map<String, VariableExpr> FIXED_CLASS_VARS = ResourceNameHelperClassComposer.createFixedClassMemberVariables();
    private static Reference javaObjectReference = ConcreteReference.withClazz(Object.class);

    private ResourceNameHelperClassComposer() {
    }

    public static ResourceNameHelperClassComposer instance() {
        return INSTANCE;
    }

    public GapicClass generate(ResourceName resourceName, GapicContext context) {
        List<List<String>> tokenHierarchies = ResourceNameTokenizer.parseTokenHierarchy(resourceName.patterns());
        TypeStore typeStore = ResourceNameHelperClassComposer.createDynamicTypes(resourceName, tokenHierarchies);
        if (context.messages().keySet().stream().anyMatch(s2 -> s2.equals("Object") || s2.endsWith(".Object"))) {
            javaObjectReference = ConcreteReference.builder().setClazz(Object.class).setUseFullName(true).build();
        }
        List<VariableExpr> templateFinalVarExprs = ResourceNameHelperClassComposer.createTemplateClassMembers(tokenHierarchies);
        Map<String, VariableExpr> patternTokenVarExprs = ResourceNameHelperClassComposer.createPatternTokenClassMembers(tokenHierarchies);
        Preconditions.checkState(patternTokenVarExprs.size() > 0, String.format("No patterns found for resource name %s", resourceName.resourceTypeString()));
        Preconditions.checkState(templateFinalVarExprs.size() > 0 && tokenHierarchies.size() == templateFinalVarExprs.size(), String.format("Cardinalities of patterns (%d) and associated variables (%d) do not match for resource name %s ", templateFinalVarExprs.size(), tokenHierarchies.size(), resourceName.resourceTypeString()));
        String className = ResourceNameHelperClassComposer.getThisClassName(resourceName);
        ClassDefinition classDef = ClassDefinition.builder().setPackageString(resourceName.pakkage()).setHeaderCommentStatements(CommentComposer.AUTO_GENERATED_CLASS_COMMENT).setAnnotations(ResourceNameHelperClassComposer.createClassAnnotations()).setScope(ScopeNode.PUBLIC).setName(className).setImplementsTypes(ResourceNameHelperClassComposer.createImplementsTypes()).setStatements(ResourceNameHelperClassComposer.createClassStatements(templateFinalVarExprs, patternTokenVarExprs, resourceName.patterns(), tokenHierarchies)).setMethods(ResourceNameHelperClassComposer.createClassMethods(resourceName, templateFinalVarExprs, patternTokenVarExprs, tokenHierarchies, typeStore)).setNestedClasses(ResourceNameHelperClassComposer.createNestedBuilderClasses(resourceName, tokenHierarchies, templateFinalVarExprs, typeStore)).build();
        return GapicClass.create(GapicClass.Kind.PROTO, classDef);
    }

    private static List<AnnotationNode> createClassAnnotations() {
        return Arrays.asList(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("Generated")).setDescription("by gapic-generator-java").build());
    }

    private static List<TypeNode> createImplementsTypes() {
        return Arrays.asList(FIXED_TYPESTORE.get("ResourceName"));
    }

    private static List<VariableExpr> createTemplateClassMembers(List<List<String>> tokenHierarchies) {
        return tokenHierarchies.stream().map(ts -> VariableExpr.withVariable(Variable.builder().setName(ResourceNameHelperClassComposer.concatToUpperSnakeCaseName(ts)).setType(ts.contains("_deleted-topic_") ? TypeNode.STRING : FIXED_TYPESTORE.get("PathTemplate")).build())).collect(Collectors.toList());
    }

    private static Map<String, VariableExpr> createPatternTokenClassMembers(List<List<String>> tokenHierarchies) {
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(ts -> !ts.contains("_deleted-topic_")).collect(Collectors.toList());
        Set<String> tokenSet = ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies);
        return tokenSet.stream().collect(Collectors.toMap(t -> t, t -> VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(t)).setType(TypeNode.STRING).build())));
    }

    private static List<Statement> createClassStatements(List<VariableExpr> templateFinalVarExprs, Map<String, VariableExpr> patternTokenVarExprs, List<String> patterns, List<List<String>> tokenHierarchies) {
        boolean hasVariants;
        ArrayList<Expr> memberVars = new ArrayList<Expr>();
        for (int i = 0; i < patterns.size(); ++i) {
            VariableExpr varExpr = templateFinalVarExprs.get(i).toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build();
            String pattern = patterns.get(i);
            Expr valueExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("PathTemplate")).setMethodName("createWithoutUrlEncoding").setArguments(Arrays.asList(ValueExpr.withValue(StringObjectValue.withValue(pattern)))).setReturnType(FIXED_TYPESTORE.get("PathTemplate")).build();
            if (pattern.equals("_deleted-topic_")) {
                valueExpr = ValueExpr.withValue(StringObjectValue.withValue(pattern));
            }
            memberVars.add(AssignmentExpr.builder().setVariableExpr(varExpr).setValueExpr(valueExpr).build());
        }
        memberVars.add(FIXED_CLASS_VARS.get("fieldValuesMap").toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsVolatile(true).build());
        boolean bl = hasVariants = tokenHierarchies.size() > 1;
        if (hasVariants) {
            Function<VariableExpr, VariableExpr> toDeclFn = v -> v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).build();
            memberVars.add(toDeclFn.apply(FIXED_CLASS_VARS.get("pathTemplate")));
            memberVars.add(toDeclFn.apply(FIXED_CLASS_VARS.get("fixedValue")));
        }
        Function<VariableExpr, VariableExpr> toFinalDeclFn = v -> v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsFinal(true).build();
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(tokens -> !tokens.contains("_deleted-topic_")).collect(Collectors.toList());
        memberVars.addAll(ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies).stream().map(t -> (VariableExpr)toFinalDeclFn.apply((VariableExpr)patternTokenVarExprs.get(t))).collect(Collectors.toList()));
        return memberVars.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
    }

    private static List<MethodDefinition> createClassMethods(ResourceName resourceName, List<VariableExpr> templateFinalVarExprs, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.addAll(ResourceNameHelperClassComposer.createConstructorMethods(resourceName, templateFinalVarExprs, patternTokenVarExprs, tokenHierarchies, typeStore));
        javaMethods.addAll(ResourceNameHelperClassComposer.createTokenGetterMethods(patternTokenVarExprs, tokenHierarchies));
        javaMethods.addAll(ResourceNameHelperClassComposer.createBuilderCreatorMethods(resourceName, tokenHierarchies, typeStore));
        javaMethods.addAll(ResourceNameHelperClassComposer.createOfCreatorMethods(resourceName, patternTokenVarExprs, tokenHierarchies, typeStore));
        javaMethods.addAll(ResourceNameHelperClassComposer.createFormatCreatorMethods(resourceName, patternTokenVarExprs, tokenHierarchies, typeStore));
        javaMethods.addAll(ResourceNameHelperClassComposer.createParsingAndSplittingMethods(resourceName, templateFinalVarExprs, tokenHierarchies, typeStore));
        javaMethods.addAll(ResourceNameHelperClassComposer.createFieldValueGetterMethods(resourceName, patternTokenVarExprs, tokenHierarchies, typeStore));
        javaMethods.add(ResourceNameHelperClassComposer.createToStringMethod(templateFinalVarExprs, patternTokenVarExprs, tokenHierarchies));
        javaMethods.add(ResourceNameHelperClassComposer.createEqualsMethod(resourceName, tokenHierarchies, typeStore));
        javaMethods.add(ResourceNameHelperClassComposer.createHashCodeMethod(tokenHierarchies));
        return javaMethods;
    }

    private static List<MethodDefinition> createConstructorMethods(ResourceName resourceName, List<VariableExpr> templateFinalVarExprs, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        String thisClassName = ResourceNameHelperClassComposer.getThisClassName(resourceName);
        TypeNode thisClassType = typeStore.get(thisClassName);
        boolean hasVariants = tokenHierarchies.size() > 1;
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        ValueExpr nullExpr = ValueExpr.createNullExpr();
        Function<String, AssignmentExpr> assignTokenToNullExpr = t -> AssignmentExpr.builder().setVariableExpr((VariableExpr)patternTokenVarExprs.get(t)).setValueExpr(nullExpr).build();
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(tokens -> !tokens.contains("_deleted-topic_")).collect(Collectors.toList());
        boolean hasDeletedTopicPattern = tokenHierarchies.size() > processedTokenHierarchies.size();
        javaMethods.add(MethodDefinition.constructorBuilder().setAnnotations(Arrays.asList(AnnotationNode.withType(TypeNode.withReference(ConcreteReference.withClazz(Deprecated.class))))).setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).setBody(ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies).stream().map(t -> ExprStatement.withExpr((Expr)assignTokenToNullExpr.apply((String)t))).collect(Collectors.toList())).build());
        for (int i = 0; i < processedTokenHierarchies.size(); ++i) {
            List<String> tokens2 = processedTokenHierarchies.get(i);
            ArrayList<Expr> bodyExprs = new ArrayList<Expr>();
            TypeNode argType = ResourceNameHelperClassComposer.getBuilderType(typeStore, processedTokenHierarchies, i);
            VariableExpr builderArgExpr = VariableExpr.withVariable(Variable.builder().setName("builder").setType(argType).build());
            for (String token : tokens2) {
                MethodInvocationExpr checkNotNullExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Preconditions")).setMethodName("checkNotNull").setReturnType(TypeNode.STRING).setArguments(Arrays.asList(MethodInvocationExpr.builder().setExprReferenceExpr(builderArgExpr).setMethodName(String.format("get%s", JavaStyle.toUpperCamelCase(token))).build())).build();
                bodyExprs.add(AssignmentExpr.builder().setVariableExpr(patternTokenVarExprs.get(token)).setValueExpr(checkNotNullExpr).build());
            }
            for (String token : ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies)) {
                if (tokens2.contains(token)) continue;
                bodyExprs.add(assignTokenToNullExpr.apply(token));
            }
            if (hasVariants) {
                AssignmentExpr pathTemplateAssignExpr = AssignmentExpr.builder().setVariableExpr(FIXED_CLASS_VARS.get("pathTemplate")).setValueExpr(templateFinalVarExprs.get(i)).build();
                bodyExprs.add(pathTemplateAssignExpr);
            }
            javaMethods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(thisClassType).setArguments(Arrays.asList(builderArgExpr.toBuilder().setIsDecl(true).build())).setBody(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build());
        }
        if (hasDeletedTopicPattern) {
            ValueExpr thisExpr = ValueExpr.withValue(ThisObjectValue.withType(thisClassType));
            VariableExpr fixedValueVarExpr = VariableExpr.withVariable(Variable.builder().setName("fixedValue").setType(TypeNode.STRING).build());
            ArrayList<AssignmentExpr> specialCtorBodyExprs = new ArrayList<AssignmentExpr>();
            specialCtorBodyExprs.add(AssignmentExpr.builder().setVariableExpr(VariableExpr.builder().setExprReferenceExpr(thisExpr).setVariable(fixedValueVarExpr.variable()).build()).setValueExpr(fixedValueVarExpr).build());
            specialCtorBodyExprs.add(AssignmentExpr.builder().setVariableExpr(FIXED_CLASS_VARS.get("fieldValuesMap")).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ImmutableMap")).setMethodName("of").setArguments(ValueExpr.withValue(StringObjectValue.withValue("")), fixedValueVarExpr).setReturnType(FIXED_TYPESTORE.get("ImmutableMap")).build()).build());
            specialCtorBodyExprs.addAll(ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies).stream().map(t -> (AssignmentExpr)assignTokenToNullExpr.apply((String)t)).collect(Collectors.toList()));
            javaMethods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(thisClassType).setArguments(Arrays.asList(fixedValueVarExpr.toBuilder().setIsDecl(true).build())).setBody(specialCtorBodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build());
        }
        return javaMethods;
    }

    private static List<MethodDefinition> createTokenGetterMethods(Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies) {
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(ts -> !ts.contains("_deleted-topic_")).collect(Collectors.toList());
        return ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies).stream().map(t -> MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.STRING).setName(String.format("get%s", JavaStyle.toUpperCamelCase(t))).setReturnExpr((Expr)patternTokenVarExprs.get(t)).build()).collect(Collectors.toList());
    }

    private static List<MethodDefinition> createBuilderCreatorMethods(ResourceName resourceName, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        String newMethodNameFormat = "new%s";
        AnnotationNode betaAnnotation = AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).setDescription("The per-pattern Builders are not stable yet and may be changed in the future.").build();
        List<AnnotationNode> annotations = Arrays.asList(betaAnnotation);
        for (int i = 0; i < tokenHierarchies.size(); ++i) {
            if (tokenHierarchies.get(i).contains("_deleted-topic_")) continue;
            TypeNode returnType = ResourceNameHelperClassComposer.getBuilderType(typeStore, tokenHierarchies, i);
            NewObjectExpr returnExpr = NewObjectExpr.withType(returnType);
            Function<String, MethodDefinition.Builder> methodDefStarterFn = methodName -> MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName((String)methodName).setReturnExpr(returnExpr);
            String variantName = ResourceNameHelperClassComposer.getBuilderTypeName(tokenHierarchies, i);
            javaMethods.add(methodDefStarterFn.apply(String.format(newMethodNameFormat, variantName)).setAnnotations(i == 0 ? Collections.emptyList() : annotations).build());
            if (i != 0 || tokenHierarchies.size() <= 1) continue;
            javaMethods.add(methodDefStarterFn.apply(String.format(newMethodNameFormat, ResourceNameHelperClassComposer.getBuilderTypeName(tokenHierarchies.get(i)))).setAnnotations(annotations).build());
        }
        TypeNode toBuilderReturnType = ResourceNameHelperClassComposer.getBuilderType(typeStore, tokenHierarchies, 0);
        TypeNode thisClassType = typeStore.get(ResourceNameHelperClassComposer.getThisClassName(resourceName));
        javaMethods.add(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(toBuilderReturnType).setName("toBuilder").setReturnExpr(NewObjectExpr.builder().setType(toBuilderReturnType).setArguments(Arrays.asList(ValueExpr.withValue(ThisObjectValue.withType(thisClassType)))).build()).build());
        return javaMethods;
    }

    private static List<MethodDefinition> createOfCreatorMethods(ResourceName resourceName, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        return ResourceNameHelperClassComposer.createOfOrFormatMethodHelper(resourceName, patternTokenVarExprs, tokenHierarchies, typeStore, false);
    }

    private static List<MethodDefinition> createFormatCreatorMethods(ResourceName resourceName, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        return ResourceNameHelperClassComposer.createOfOrFormatMethodHelper(resourceName, patternTokenVarExprs, tokenHierarchies, typeStore, true);
    }

    private static List<MethodDefinition> createOfOrFormatMethodHelper(ResourceName resourceName, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore, boolean isFormatMethod) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        String methodNameFormat = isFormatMethod ? "format%s" : "of%s";
        String newBuilderMethodNameFormat = "new%s";
        String setMethodNameFormat = "set%s";
        String buildMethodName = "build";
        String toStringMethodName = "toString";
        AnnotationNode betaAnnotation = AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).setDescription(String.format("The static %s methods are not stable yet and may be changed in the future.", isFormatMethod ? "format" : "create")).build();
        List<AnnotationNode> annotations = Arrays.asList(betaAnnotation);
        TypeNode thisClassType = typeStore.get(ResourceNameHelperClassComposer.getThisClassName(resourceName));
        TypeNode returnType = isFormatMethod ? TypeNode.STRING : thisClassType;
        boolean hasVariants = tokenHierarchies.size() > 1;
        for (int i = 0; i < tokenHierarchies.size(); ++i) {
            List<String> tokens = tokenHierarchies.get(i);
            if (tokens.contains("_deleted-topic_")) {
                ValueExpr deletedTopicStringValExpr = ValueExpr.withValue(StringObjectValue.withValue("_deleted-topic_"));
                javaMethods.add(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setAnnotations(annotations).setReturnType(returnType).setName(String.format(methodNameFormat, ResourceNameHelperClassComposer.concatToUpperCamelCaseName(tokens) + "Name")).setReturnExpr(returnType.equals(TypeNode.STRING) ? deletedTopicStringValExpr : NewObjectExpr.builder().setType(returnType).setArguments(deletedTopicStringValExpr).build()).build());
                continue;
            }
            String builderMethodName = String.format(newBuilderMethodNameFormat, ResourceNameHelperClassComposer.getBuilderTypeName(tokenHierarchies, i));
            MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setMethodName(builderMethodName).build();
            for (String token : tokens) {
                String javaTokenVarName = JavaStyle.toLowerCamelCase(token);
                returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName(String.format(setMethodNameFormat, JavaStyle.toUpperCamelCase(token))).setArguments(Arrays.asList(VariableExpr.withVariable(Variable.builder().setName(javaTokenVarName).setType(TypeNode.STRING).build()))).build();
            }
            returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName(buildMethodName).setReturnType(thisClassType).build();
            if (isFormatMethod) {
                returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName(toStringMethodName).setReturnType(TypeNode.STRING).build();
            }
            List<VariableExpr> methodArgs = tokens.stream().map(t -> ((VariableExpr)patternTokenVarExprs.get(t)).toBuilder().setIsDecl(true).build()).collect(Collectors.toList());
            javaMethods.add(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setAnnotations(i == 0 ? Collections.emptyList() : annotations).setReturnType(returnType).setName(String.format(methodNameFormat, i == 0 ? "" : ResourceNameHelperClassComposer.concatToUpperCamelCaseName(tokens) + "Name")).setArguments(methodArgs).setReturnExpr(returnExpr).build());
            if (i != 0 || !hasVariants) continue;
            javaMethods.add(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setAnnotations(annotations).setReturnType(returnType).setName(String.format(methodNameFormat, ResourceNameHelperClassComposer.concatToUpperCamelCaseName(tokenHierarchies.get(i)) + "Name")).setArguments(methodArgs).setReturnExpr(returnExpr).build());
        }
        return javaMethods;
    }

    private static List<MethodDefinition> createParsingAndSplittingMethods(ResourceName resourceName, List<VariableExpr> templateFinalVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        TypeNode thisClassType = typeStore.get(ResourceNameHelperClassComposer.getThisClassName(resourceName));
        javaMethods.add(ResourceNameHelperClassComposer.createParseMethod(thisClassType, templateFinalVarExprs, tokenHierarchies, typeStore));
        javaMethods.add(ResourceNameHelperClassComposer.createParseListMethod(thisClassType));
        javaMethods.add(ResourceNameHelperClassComposer.createToStringListMethod(thisClassType));
        javaMethods.add(ResourceNameHelperClassComposer.createIsParseableFromMethod(templateFinalVarExprs));
        return javaMethods;
    }

    private static MethodDefinition createParseMethod(TypeNode thisClassType, List<VariableExpr> templateFinalVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        boolean hasVariants;
        String formattedStringArgName = "formattedString";
        VariableExpr formattedStringArgExpr = VariableExpr.withVariable(Variable.builder().setName(formattedStringArgName).setType(TypeNode.STRING).build());
        String exceptionMessageString = String.format("%s.parse: %s not in valid format", thisClassType.reference().name(), formattedStringArgName);
        ValueExpr exceptionMessageExpr = ValueExpr.withValue(StringObjectValue.withValue(exceptionMessageString));
        TypeNode mapStringType = TypeNode.withReference(ConcreteReference.builder().setClazz(Map.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(String.class), ConcreteReference.withClazz(String.class))).build());
        VariableExpr matchMapVarExpr = VariableExpr.withVariable(Variable.builder().setName("matchMap").setType(mapStringType).build());
        ArrayList<Statement> body = new ArrayList<Statement>();
        body.add(IfStatement.builder().setConditionExpr(MethodInvocationExpr.builder().setExprReferenceExpr(formattedStringArgExpr).setMethodName("isEmpty").setReturnType(TypeNode.BOOLEAN).build()).setBody(Arrays.asList(ExprStatement.withExpr(ReturnExpr.withExpr(ValueExpr.createNullExpr())))).build());
        List<Expr> formattedStringArgList = Arrays.asList(formattedStringArgExpr);
        List<VariableExpr> formattedStringArgDeclList = Arrays.asList(formattedStringArgExpr.toBuilder().setIsDecl(true).build());
        boolean bl = hasVariants = tokenHierarchies.size() > 1;
        if (!hasVariants) {
            List<Expr> methodArgs = Arrays.asList(formattedStringArgExpr, exceptionMessageExpr);
            MethodInvocationExpr validatedMatchExpr = MethodInvocationExpr.builder().setExprReferenceExpr(templateFinalVarExprs.get(0)).setMethodName("validatedMatch").setArguments(methodArgs).setReturnType(mapStringType).build();
            AssignmentExpr matchMapAssignExpr = AssignmentExpr.builder().setVariableExpr(matchMapVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(validatedMatchExpr).build();
            body.add(ExprStatement.withExpr(matchMapAssignExpr));
            List<Expr> ofMethodArgExprs = tokenHierarchies.get(0).stream().map(t -> MethodInvocationExpr.builder().setExprReferenceExpr(matchMapVarExpr).setMethodName("get").setArguments(Arrays.asList(ValueExpr.withValue(StringObjectValue.withValue(t)))).build()).collect(Collectors.toList());
            MethodInvocationExpr ofMethodExpr = MethodInvocationExpr.builder().setMethodName("of").setArguments(ofMethodArgExprs).setReturnType(thisClassType).build();
            return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(thisClassType).setName("parse").setArguments(formattedStringArgDeclList).setBody(body).setReturnExpr(ofMethodExpr).build();
        }
        IfStatement.Builder ifStatementBuilder = IfStatement.builder();
        String ofMethodNamePattern = "of%sName";
        for (int i = 0; i < tokenHierarchies.size(); ++i) {
            boolean isDeletedTopicPattern = tokenHierarchies.get(i).contains("_deleted-topic_");
            VariableExpr templateVarExpr = templateFinalVarExprs.get(i);
            MethodInvocationExpr conditionExpr = MethodInvocationExpr.builder().setExprReferenceExpr(templateVarExpr).setMethodName(isDeletedTopicPattern ? "equals" : "matches").setArguments(formattedStringArgList).setReturnType(TypeNode.BOOLEAN).build();
            MethodInvocationExpr matchValueExpr = MethodInvocationExpr.builder().setExprReferenceExpr(templateVarExpr).setMethodName("match").setArguments(formattedStringArgList).setReturnType(mapStringType).build();
            AssignmentExpr matchMapAssignExpr = AssignmentExpr.builder().setVariableExpr(matchMapVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(matchValueExpr).build();
            List<String> tokens = tokenHierarchies.get(i);
            MethodInvocationExpr ofMethodExpr = MethodInvocationExpr.builder().setMethodName(String.format(ofMethodNamePattern, ResourceNameHelperClassComposer.concatToUpperCamelCaseName(tokens))).setArguments(tokens.stream().map(t -> MethodInvocationExpr.builder().setExprReferenceExpr(matchMapVarExpr).setMethodName("get").setArguments(Arrays.asList(ValueExpr.withValue(StringObjectValue.withValue(t)))).build()).collect(Collectors.toList())).setReturnType(thisClassType).build();
            ReturnExpr subReturnExpr = ReturnExpr.withExpr(ofMethodExpr);
            List<Statement> ifStatements = Arrays.asList(matchMapAssignExpr, subReturnExpr).stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
            if (i == 0) {
                ifStatementBuilder = ifStatementBuilder.setConditionExpr(conditionExpr).setBody(ifStatements);
                continue;
            }
            if (isDeletedTopicPattern) {
                ifStatements.clear();
                ifStatements.add(ExprStatement.withExpr(ReturnExpr.withExpr(NewObjectExpr.builder().setType(thisClassType).setArguments(ValueExpr.withValue(StringObjectValue.withValue("_deleted-topic_"))).build())));
            }
            ifStatementBuilder = ifStatementBuilder.addElseIf(conditionExpr, ifStatements);
        }
        body.add(ifStatementBuilder.build());
        body.add(ExprStatement.withExpr(ThrowExpr.builder().setType(FIXED_TYPESTORE.get("ValidationException")).setMessageExpr(exceptionMessageString).build()));
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(thisClassType).setName("parse").setArguments(formattedStringArgDeclList).setBody(body).build();
    }

    private static MethodDefinition createParseListMethod(TypeNode thisClassType) {
        TypeNode listStringType = TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(String.class))).build());
        TypeNode returnType = TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(thisClassType.reference())).build());
        VariableExpr formattedStringsVarExpr = VariableExpr.withVariable(Variable.builder().setName("formattedStrings").setType(listStringType).build());
        VariableExpr listVarExpr = VariableExpr.withVariable(Variable.builder().setName("list").setType(returnType).build());
        AssignmentExpr listAssignExpr = AssignmentExpr.builder().setVariableExpr(listVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(ArrayList.class).build())).setIsGeneric(true).setArguments(Arrays.asList(MethodInvocationExpr.builder().setExprReferenceExpr(formattedStringsVarExpr).setMethodName("size").build())).build()).build();
        VariableExpr singleStrVarExpr = VariableExpr.withVariable(Variable.builder().setName("formattedString").setType(TypeNode.STRING).build());
        ForStatement forStatement = ForStatement.builder().setLocalVariableExpr(singleStrVarExpr.toBuilder().setIsDecl(true).build()).setCollectionExpr(formattedStringsVarExpr).setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(listVarExpr).setMethodName("add").setArguments(Arrays.asList(MethodInvocationExpr.builder().setMethodName("parse").setArguments(Arrays.asList(singleStrVarExpr)).build())).build()))).build();
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("parseList").setArguments(Arrays.asList(formattedStringsVarExpr.toBuilder().setIsDecl(true).build())).setBody(Arrays.asList(ExprStatement.withExpr(listAssignExpr), forStatement)).setReturnExpr(listVarExpr).build();
    }

    private static MethodDefinition createToStringListMethod(TypeNode thisClassType) {
        TypeNode listClassType = TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(thisClassType.reference())).build());
        VariableExpr valuesVarExpr = VariableExpr.withVariable(Variable.builder().setName("values").setType(listClassType).build());
        TypeNode listStringType = TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(String.class))).build());
        VariableExpr listVarExpr = VariableExpr.withVariable(Variable.builder().setName("list").setType(listStringType).build());
        AssignmentExpr listAssignExpr = AssignmentExpr.builder().setVariableExpr(listVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(TypeNode.withReference(ConcreteReference.withClazz(ArrayList.class))).setIsGeneric(true).setArguments(Arrays.asList(MethodInvocationExpr.builder().setExprReferenceExpr(valuesVarExpr).setMethodName("size").build())).build()).build();
        VariableExpr valueVarExpr = VariableExpr.withVariable(Variable.builder().setName("value").setType(thisClassType).build());
        RelationalOperationExpr isNullCheck = RelationalOperationExpr.equalToWithExprs(valueVarExpr, ValueExpr.createNullExpr());
        ExprStatement listAddEmptyStringStatement = ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(listVarExpr).setMethodName("add").setArguments(Arrays.asList(ValueExpr.withValue(StringObjectValue.withValue("")))).build());
        ExprStatement listAddValueStatement = ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(listVarExpr).setMethodName("add").setArguments(Arrays.asList(MethodInvocationExpr.builder().setExprReferenceExpr(valueVarExpr).setMethodName("toString").build())).build());
        IfStatement ifStatement = IfStatement.builder().setConditionExpr(isNullCheck).setBody(Arrays.asList(listAddEmptyStringStatement)).setElseBody(Arrays.asList(listAddValueStatement)).build();
        ForStatement forStatement = ForStatement.builder().setLocalVariableExpr(valueVarExpr.toBuilder().setIsDecl(true).build()).setCollectionExpr(valuesVarExpr).setBody(Arrays.asList(ifStatement)).build();
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(listStringType).setName("toStringList").setArguments(Arrays.asList(valuesVarExpr.toBuilder().setIsDecl(true).build())).setBody(Arrays.asList(ExprStatement.withExpr(listAssignExpr), forStatement)).setReturnExpr(listVarExpr).build();
    }

    private static MethodDefinition createIsParseableFromMethod(List<VariableExpr> templateFinalVarExprs) {
        VariableExpr formattedStringVarExpr = VariableExpr.withVariable(Variable.builder().setName("formattedString").setType(TypeNode.STRING).build());
        Expr returnOrExpr = MethodInvocationExpr.builder().setExprReferenceExpr(templateFinalVarExprs.get(0)).setMethodName("matches").setArguments(Arrays.asList(formattedStringVarExpr)).setReturnType(TypeNode.BOOLEAN).build();
        for (int i = 1; i < templateFinalVarExprs.size(); ++i) {
            VariableExpr templateVarExpr = templateFinalVarExprs.get(i);
            returnOrExpr = LogicalOperationExpr.logicalOrWithExprs(returnOrExpr, MethodInvocationExpr.builder().setExprReferenceExpr(templateVarExpr).setMethodName(templateVarExpr.variable().identifier().name().equals("DELETED_TOPIC") ? "equals" : "matches").setArguments(Arrays.asList(formattedStringVarExpr)).setReturnType(TypeNode.BOOLEAN).build());
        }
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(TypeNode.BOOLEAN).setName("isParsableFrom").setArguments(Arrays.asList(formattedStringVarExpr.toBuilder().setIsDecl(true).build())).setReturnExpr(returnOrExpr).build();
    }

    private static List<MethodDefinition> createFieldValueGetterMethods(ResourceName resourceName, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        TypeNode thisClassType = typeStore.get(ResourceNameHelperClassComposer.getThisClassName(resourceName));
        javaMethods.add(ResourceNameHelperClassComposer.createGetFieldValuesMapMethod(resourceName, thisClassType, patternTokenVarExprs, tokenHierarchies));
        javaMethods.add(ResourceNameHelperClassComposer.createGetFieldValueMethod());
        return javaMethods;
    }

    private static MethodDefinition createGetFieldValuesMapMethod(ResourceName resourceName, TypeNode thisClassType, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies) {
        Reference strRef = TypeNode.STRING.reference();
        TypeNode mapBuilderType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableMap.Builder.class).setGenerics(Arrays.asList(strRef, strRef)).build());
        VariableExpr fieldMapBuilderVarExpr = VariableExpr.withVariable(Variable.builder().setName("fieldMapBuilder").setType(mapBuilderType).build());
        AssignmentExpr builderAssignExpr = AssignmentExpr.builder().setVariableExpr(fieldMapBuilderVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ImmutableMap")).setMethodName("builder").setReturnType(mapBuilderType).build()).build();
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(tokens -> !tokens.contains("_deleted-topic_")).collect(Collectors.toList());
        ArrayList<IfStatement> tokenIfStatements = new ArrayList<IfStatement>();
        for (String token : ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies)) {
            VariableExpr tokenVarExpr = patternTokenVarExprs.get(token);
            Preconditions.checkNotNull(tokenVarExpr, String.format("No variable found for %s among %s", token, patternTokenVarExprs.keySet()));
            StringObjectValue tokenStrVal = StringObjectValue.withValue(token);
            MethodInvocationExpr putExpr = MethodInvocationExpr.builder().setExprReferenceExpr(fieldMapBuilderVarExpr).setMethodName("put").setArguments(ValueExpr.withValue(tokenStrVal), tokenVarExpr).build();
            RelationalOperationExpr notNullCheckExpr = RelationalOperationExpr.notEqualToWithExprs(tokenVarExpr, ValueExpr.createNullExpr());
            tokenIfStatements.add(IfStatement.builder().setConditionExpr(notNullCheckExpr).setBody(Arrays.asList(ExprStatement.withExpr(putExpr))).build());
        }
        VariableExpr fieldValuesMapVarExpr = FIXED_CLASS_VARS.get("fieldValuesMap");
        AssignmentExpr fieldValuesMapAssignExpr = AssignmentExpr.builder().setVariableExpr(fieldValuesMapVarExpr).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(fieldMapBuilderVarExpr).setMethodName("build").setReturnType(fieldValuesMapVarExpr.type()).build()).build();
        ArrayList<Statement> middleIfBlockStatements = new ArrayList<Statement>();
        middleIfBlockStatements.add(ExprStatement.withExpr(builderAssignExpr));
        middleIfBlockStatements.addAll(tokenIfStatements);
        middleIfBlockStatements.add(ExprStatement.withExpr(fieldValuesMapAssignExpr));
        RelationalOperationExpr fieldValuesMapNullCheckExpr = RelationalOperationExpr.equalToWithExprs(fieldValuesMapVarExpr, ValueExpr.createNullExpr());
        IfStatement fieldValuesMapIfStatement = IfStatement.builder().setConditionExpr(fieldValuesMapNullCheckExpr).setBody(middleIfBlockStatements).build();
        IfStatement outerIfStatement = IfStatement.builder().setConditionExpr(fieldValuesMapNullCheckExpr).setBody(Arrays.asList(SynchronizedStatement.builder().setLock(ThisObjectValue.withType(thisClassType)).setBody(Arrays.asList(fieldValuesMapIfStatement)).build())).build();
        TypeNode mapStringType = fieldValuesMapVarExpr.type();
        return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(mapStringType).setName("getFieldValuesMap").setBody(Arrays.asList(outerIfStatement)).setReturnExpr(fieldValuesMapVarExpr).build();
    }

    private static MethodDefinition createGetFieldValueMethod() {
        VariableExpr fieldNameVarExpr = VariableExpr.withVariable(Variable.builder().setName("fieldName").setType(TypeNode.STRING).build());
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setMethodName("getFieldValuesMap").build();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName("get").setArguments(fieldNameVarExpr).setReturnType(TypeNode.STRING).build();
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.STRING).setName("getFieldValue").setArguments(fieldNameVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(returnExpr).build();
    }

    private static MethodDefinition createToStringMethod(List<VariableExpr> templateFinalVarExprs, Map<String, VariableExpr> patternTokenVarExprs, List<List<String>> tokenHierarchies) {
        boolean hasVariants;
        boolean bl = hasVariants = tokenHierarchies.size() > 1;
        if (!hasVariants) {
            ArrayList<Expr> instantiateArgExprs = new ArrayList<Expr>();
            List tokens = ResourceNameHelperClassComposer.getTokenSet(tokenHierarchies).stream().collect(Collectors.toList());
            for (String token : tokens) {
                Preconditions.checkNotNull(patternTokenVarExprs.get(token), String.format("No expression found for token %s amongst values %s", token, patternTokenVarExprs.toString()));
                instantiateArgExprs.add(ValueExpr.withValue(StringObjectValue.withValue(token)));
                instantiateArgExprs.add(patternTokenVarExprs.get(token));
            }
            MethodInvocationExpr returnInstantiateExpr = MethodInvocationExpr.builder().setExprReferenceExpr(templateFinalVarExprs.get(0)).setMethodName("instantiate").setArguments(instantiateArgExprs).setReturnType(TypeNode.STRING).build();
            return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.STRING).setName("toString").setReturnExpr(returnInstantiateExpr).build();
        }
        VariableExpr fixedValueVarExpr = FIXED_CLASS_VARS.get("fixedValue");
        RelationalOperationExpr fixedValueNullCheck = RelationalOperationExpr.notEqualToWithExprs(fixedValueVarExpr, ValueExpr.createNullExpr());
        MethodInvocationExpr instantiateExpr = MethodInvocationExpr.builder().setExprReferenceExpr(FIXED_CLASS_VARS.get("pathTemplate")).setMethodName("instantiate").setArguments(MethodInvocationExpr.builder().setMethodName("getFieldValuesMap").build()).setReturnType(TypeNode.STRING).build();
        TernaryExpr returnExpr = TernaryExpr.builder().setConditionExpr(fixedValueNullCheck).setElseExpr(instantiateExpr).setThenExpr(fixedValueVarExpr).build();
        return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.STRING).setName("toString").setReturnExpr(returnExpr).build();
    }

    private static MethodDefinition createEqualsMethod(ResourceName resourceName, List<List<String>> tokenHierarchies, TypeStore typeStore) {
        Variable oVariable = Variable.builder().setType(TypeNode.withReference(javaObjectReference)).setName("o").build();
        VariableExpr argVarExpr = VariableExpr.builder().setIsDecl(false).setVariable(oVariable).build();
        TypeNode thisClassType = typeStore.get(ResourceNameHelperClassComposer.getThisClassName(resourceName));
        ValueExpr thisValueExpr = ValueExpr.withValue(ThisObjectValue.withType(thisClassType));
        ValueExpr trueValueExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.BOOLEAN).setValue("true").build());
        ReturnExpr returnTrueExpr = ReturnExpr.withExpr(trueValueExpr);
        RelationalOperationExpr oEqualsThisExpr = RelationalOperationExpr.equalToWithExprs(argVarExpr, thisValueExpr);
        RelationalOperationExpr oNotEqualsNullExpr = RelationalOperationExpr.notEqualToWithExprs(argVarExpr, ValueExpr.createNullExpr());
        MethodInvocationExpr getClassMethodInvocationExpr = MethodInvocationExpr.builder().setMethodName("getClass").build();
        RelationalOperationExpr getClassEqualsExpr = RelationalOperationExpr.equalToWithExprs(getClassMethodInvocationExpr, getClassMethodInvocationExpr.toBuilder().setExprReferenceExpr(argVarExpr).build());
        LogicalOperationExpr orLogicalExpr = LogicalOperationExpr.logicalOrWithExprs(oNotEqualsNullExpr, getClassEqualsExpr);
        Variable thatVariable = Variable.builder().setName("that").setType(thisClassType).build();
        VariableExpr thatVariableExpr = VariableExpr.builder().setIsDecl(false).setVariable(thatVariable).build();
        CastExpr oCastExpr = CastExpr.builder().setExpr(argVarExpr).setType(thisClassType).build();
        AssignmentExpr thatAssignmentExpr = AssignmentExpr.builder().setVariableExpr(thatVariableExpr.toBuilder().setIsDecl(true).build()).setValueExpr(oCastExpr).build();
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(ts -> !ts.contains("_deleted-topic_")).collect(Collectors.toList());
        Set<String> tokenSet = ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies);
        Iterator<String> itToken = tokenSet.iterator();
        Expr curTokenExpr = ResourceNameHelperClassComposer.createObjectsEqualsForTokenMethodExpr(thisValueExpr, thatVariableExpr, Variable.builder().setType(TypeNode.STRING).setName(JavaStyle.toLowerCamelCase(itToken.next())).build());
        while (itToken.hasNext()) {
            MethodInvocationExpr nextTokenExpr = ResourceNameHelperClassComposer.createObjectsEqualsForTokenMethodExpr(thisValueExpr, thatVariableExpr, Variable.builder().setType(TypeNode.STRING).setName(JavaStyle.toLowerCamelCase(itToken.next())).build());
            curTokenExpr = LogicalOperationExpr.logicalAndWithExprs(curTokenExpr, nextTokenExpr);
        }
        ReturnExpr secondIfReturnExpr = ReturnExpr.withExpr(curTokenExpr);
        IfStatement firstIfStatement = IfStatement.builder().setConditionExpr(oEqualsThisExpr).setBody(Arrays.asList(ExprStatement.withExpr(returnTrueExpr))).build();
        IfStatement secondIfStatement = IfStatement.builder().setConditionExpr(orLogicalExpr).setBody(Arrays.asList(ExprStatement.withExpr(thatAssignmentExpr), ExprStatement.withExpr(secondIfReturnExpr))).build();
        ValueExpr falseValueExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.BOOLEAN).setValue("false").build());
        return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setArguments(argVarExpr.toBuilder().setIsDecl(true).build()).setReturnType(TypeNode.BOOLEAN).setName("equals").setReturnExpr(falseValueExpr).setBody(Arrays.asList(firstIfStatement, secondIfStatement)).build();
    }

    private static MethodInvocationExpr createObjectsEqualsForTokenMethodExpr(Expr thisExpr, Expr thatExpr, Variable tokenVar) {
        VariableExpr varThisExpr = VariableExpr.builder().setVariable(tokenVar).setExprReferenceExpr(thisExpr).build();
        VariableExpr varThatExpr = VariableExpr.builder().setVariable(tokenVar).setExprReferenceExpr(thatExpr).build();
        return MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Objects")).setMethodName("equals").setArguments(Arrays.asList(varThisExpr, varThatExpr)).setReturnType(TypeNode.BOOLEAN).build();
    }

    private static MethodDefinition createHashCodeMethod(List<List<String>> tokenHierarchies) {
        boolean hasVariants;
        ArrayList<Statement> assignmentBody = new ArrayList<Statement>();
        Variable hVar = Variable.builder().setType(TypeNode.INT).setName("h").build();
        VariableExpr hVarExpr = VariableExpr.builder().setVariable(hVar).build();
        ValueExpr hValueExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("1").build());
        AssignmentExpr hAssignmentExpr = AssignmentExpr.builder().setVariableExpr(hVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(hValueExpr).build();
        assignmentBody.add(ExprStatement.withExpr(hAssignmentExpr));
        ValueExpr numValueExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("1000003").build());
        AssignmentOperationExpr multiplyAssignmentOpExpr = AssignmentOperationExpr.multiplyAssignmentWithExprs(hVarExpr, numValueExpr);
        List<List<String>> processedTokenHierarchies = tokenHierarchies.stream().filter(ts -> !ts.contains("_deleted-topic_")).collect(Collectors.toList());
        boolean bl = hasVariants = processedTokenHierarchies.size() > 1;
        if (hasVariants) {
            VariableExpr fixedValueVarExpr = FIXED_CLASS_VARS.get("fixedValue");
            assignmentBody.add(ExprStatement.withExpr(multiplyAssignmentOpExpr));
            assignmentBody.add(ExprStatement.withExpr(AssignmentOperationExpr.xorAssignmentWithExprs(hVarExpr, ResourceNameHelperClassComposer.createObjectsHashCodeForVarMethod(fixedValueVarExpr))));
        }
        Set<String> tokenSet = ResourceNameHelperClassComposer.getTokenSet(processedTokenHierarchies);
        tokenSet.stream().forEach(token -> {
            VariableExpr tokenVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(token)).setType(TypeNode.STRING).build());
            assignmentBody.add(ExprStatement.withExpr(multiplyAssignmentOpExpr));
            assignmentBody.add(ExprStatement.withExpr(AssignmentOperationExpr.xorAssignmentWithExprs(hVarExpr, ResourceNameHelperClassComposer.createObjectsHashCodeForVarMethod(tokenVarExpr))));
        });
        return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.INT).setName("hashCode").setBody(assignmentBody).setReturnExpr(hVarExpr).build();
    }

    private static MethodInvocationExpr createObjectsHashCodeForVarMethod(VariableExpr varExpr) {
        return MethodInvocationExpr.builder().setMethodName("hashCode").setStaticReferenceType(FIXED_TYPESTORE.get("Objects")).setArguments(varExpr).setReturnType(TypeNode.INT).build();
    }

    private static List<ClassDefinition> createNestedBuilderClasses(ResourceName resourceName, List<List<String>> tokenHierarchies, List<VariableExpr> templateFinalVarExprs, TypeStore typeStore) {
        String thisClassName = ResourceNameHelperClassComposer.getThisClassName(resourceName);
        TypeNode outerThisClassType = typeStore.get(thisClassName);
        boolean hasVariants = tokenHierarchies.size() > 1;
        ArrayList<ClassDefinition> nestedClasses = new ArrayList<ClassDefinition>();
        for (int i = 0; i < tokenHierarchies.size(); ++i) {
            List<String> tokens = tokenHierarchies.get(i);
            if (tokens.contains("_deleted-topic_")) continue;
            nestedClasses.add(ResourceNameHelperClassComposer.createNestedBuilderClass(outerThisClassType, tokens, templateFinalVarExprs.get(i), (String)resourceName.patterns().get(i), typeStore, hasVariants, i == 0));
        }
        return nestedClasses;
    }

    private static ClassDefinition createNestedBuilderClass(TypeNode outerClassType, List<String> tokens, VariableExpr templateFinalVarExpr, String resourceNamePattern, TypeStore typeStore, boolean hasVariants, boolean isDefaultClass) {
        String className = isDefaultClass ? "Builder" : ResourceNameHelperClassComposer.getBuilderTypeName(tokens);
        List classMemberVarExprs = tokens.stream().map(t -> VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(t)).setType(TypeNode.STRING).build())).collect(Collectors.toList());
        List<Statement> classMemberDecls = classMemberVarExprs.stream().map(v -> ExprStatement.withExpr(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).build())).collect(Collectors.toList());
        ArrayList<MethodDefinition> nestedClassMethods = new ArrayList<MethodDefinition>();
        TypeNode thisClassType = typeStore.get(className);
        MethodDefinition ctor = MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).build();
        nestedClassMethods.add(ctor);
        ArrayList<MethodDefinition> getterMethods = new ArrayList<MethodDefinition>();
        ArrayList<MethodDefinition> setterMethods = new ArrayList<MethodDefinition>();
        ValueExpr thisExpr = ValueExpr.withValue(ThisObjectValue.withType(thisClassType));
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            String upperCamelTokenName = JavaStyle.toUpperCamelCase(token);
            VariableExpr currClassTokenVarExpr = (VariableExpr)classMemberVarExprs.get(i);
            MethodDefinition getterMethod = MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.STRING).setName(String.format("get%s", upperCamelTokenName)).setReturnExpr(currClassTokenVarExpr).build();
            getterMethods.add(getterMethod);
            VariableExpr tokenArgVarExpr = currClassTokenVarExpr;
            AssignmentExpr fieldAssignExpr = AssignmentExpr.builder().setVariableExpr(currClassTokenVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(tokenArgVarExpr).build();
            MethodDefinition setterMethod = MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(thisClassType).setName(String.format("set%s", upperCamelTokenName)).setArguments(((VariableExpr)classMemberVarExprs.get(i)).toBuilder().setIsDecl(true).build()).setBody(Arrays.asList(ExprStatement.withExpr(fieldAssignExpr))).setReturnExpr(thisExpr).build();
            setterMethods.add(setterMethod);
        }
        nestedClassMethods.addAll(getterMethods);
        nestedClassMethods.addAll(setterMethods);
        if (isDefaultClass) {
            VariableExpr outerClassVarExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(outerClassType.reference().name())).setType(outerClassType).build());
            ArrayList<Expr> builderCtorBodyExprs = new ArrayList<Expr>();
            if (hasVariants) {
                MethodInvocationExpr equalsCheckExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Objects")).setMethodName("equals").setArguments(FIXED_CLASS_VARS.get("pathTemplate").toBuilder().setExprReferenceExpr(outerClassVarExpr).build(), templateFinalVarExpr).build();
                builderCtorBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Preconditions")).setMethodName("checkArgument").setArguments(equalsCheckExpr, ValueExpr.withValue(StringObjectValue.withValue(String.format("toBuilder is only supported when %s has the pattern of %s", outerClassType.reference().name(), resourceNamePattern)))).build());
            }
            for (VariableExpr memberVarExpr : classMemberVarExprs) {
                VariableExpr currClassTokenVarExpr = memberVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build();
                builderCtorBodyExprs.add(AssignmentExpr.builder().setVariableExpr(currClassTokenVarExpr).setValueExpr(currClassTokenVarExpr.toBuilder().setExprReferenceExpr(outerClassVarExpr).build()).build());
            }
            MethodDefinition fromOuterTypeCtor = MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(thisClassType).setArguments(outerClassVarExpr.toBuilder().setIsDecl(true).build()).setBody(builderCtorBodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build();
            nestedClassMethods.add(fromOuterTypeCtor);
        }
        MethodDefinition buildMethod = MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(outerClassType).setName("build").setReturnExpr(NewObjectExpr.builder().setType(outerClassType).setArguments(thisExpr).build()).build();
        nestedClassMethods.add(buildMethod);
        AnnotationNode betaAnnotation = AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).setDescription("The per-pattern Builders are not stable yet and may be changed in the future.").build();
        List<AnnotationNode> classAnnotations = isDefaultClass ? Collections.emptyList() : Arrays.asList(betaAnnotation);
        return ClassDefinition.builder().setHeaderCommentStatements(CommentStatement.withComment(JavaDocComment.withComment(String.format(BUILDER_CLASS_HEADER_PATTERN, resourceNamePattern)))).setAnnotations(classAnnotations).setIsNested(true).setScope(ScopeNode.PUBLIC).setIsStatic(true).setName(className).setStatements(classMemberDecls).setMethods(nestedClassMethods).build();
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(ArrayList.class, BetaApi.class, Generated.class, ImmutableMap.class, List.class, Map.class, Objects.class, PathTemplate.class, Preconditions.class, com.google.api.resourcenames.ResourceName.class, ValidationException.class);
        return new TypeStore(concreteClazzes);
    }

    private static TypeStore createDynamicTypes(ResourceName resourceName, List<List<String>> tokenHierarchies) {
        String thisClassName = ResourceNameHelperClassComposer.getThisClassName(resourceName);
        TypeStore typeStore = new TypeStore();
        typeStore.put(resourceName.pakkage(), thisClassName);
        typeStore.put(resourceName.pakkage(), "Builder", true, thisClassName);
        List processedTokenHierarchies = tokenHierarchies.stream().filter(tokens -> !tokens.contains("_deleted-topic_")).collect(Collectors.toList());
        if (processedTokenHierarchies.size() > 1) {
            typeStore.putAll(resourceName.pakkage(), tokenHierarchies.subList(1, tokenHierarchies.size()).stream().map(ts -> ResourceNameHelperClassComposer.getBuilderTypeName(ts)).collect(Collectors.toList()));
        }
        return typeStore;
    }

    private static Map<String, VariableExpr> createFixedClassMemberVariables() {
        HashMap<String, TypeNode> memberVars = new HashMap<String, TypeNode>();
        ConcreteReference stringRef = ConcreteReference.withClazz(String.class);
        memberVars.put("fieldValuesMap", TypeNode.withReference(ConcreteReference.builder().setClazz(Map.class).setGenerics(Arrays.asList(stringRef, stringRef)).build()));
        memberVars.put("pathTemplate", TypeNode.withReference(ConcreteReference.withClazz(PathTemplate.class)));
        memberVars.put("fixedValue", TypeNode.STRING);
        return memberVars.entrySet().stream().map(e -> Variable.builder().setName((String)e.getKey()).setType((TypeNode)e.getValue()).build()).collect(Collectors.toMap(v -> v.identifier().name(), v -> VariableExpr.withVariable(v)));
    }

    private static String getThisClassName(ResourceName resourceName) {
        return String.format(CLASS_NAME_PATTERN, JavaStyle.toUpperCamelCase(resourceName.resourceTypeName()));
    }

    private static String getBuilderTypeName(List<List<String>> tokenHierarchies, int index) {
        return index == 0 ? "Builder" : ResourceNameHelperClassComposer.getBuilderTypeName(tokenHierarchies.get(index));
    }

    private static String getBuilderTypeName(List<String> tokens) {
        return String.format("%sBuilder", ResourceNameHelperClassComposer.concatToUpperCamelCaseName(tokens));
    }

    private static TypeNode getBuilderType(TypeStore typeStore, List<List<String>> tokenHierarchies, int index) {
        return index == 0 ? typeStore.get("Builder") : typeStore.get(ResourceNameHelperClassComposer.getBuilderTypeName(tokenHierarchies, index));
    }

    @VisibleForTesting
    static Set<String> getTokenSet(List<List<String>> tokenHierarchy) {
        return tokenHierarchy.stream().flatMap(tokens -> tokens.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @VisibleForTesting
    static String concatToUpperSnakeCaseName(List<String> tokens) {
        return JavaStyle.toUpperSnakeCase(tokens.stream().collect(Collectors.joining("_")));
    }

    @VisibleForTesting
    static String concatToUpperCamelCaseName(List<String> tokens) {
        return JavaStyle.toUpperCamelCase(tokens.stream().collect(Collectors.joining("_")));
    }
}

