/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.common.collect.Queues;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class MockStreamingApi {

    public static class MockResponseObserver<T>
    extends StateCheckingResponseObserver<T> {
        private final boolean autoFlowControl;
        private StreamController controller;
        private final BlockingQueue<T> responses = Queues.newLinkedBlockingDeque();
        private final SettableApiFuture<Void> done = SettableApiFuture.create();

        public MockResponseObserver(boolean autoFlowControl) {
            this.autoFlowControl = autoFlowControl;
        }

        @Override
        protected void onStartImpl(StreamController controller) {
            this.controller = controller;
            if (!this.autoFlowControl) {
                controller.disableAutoInboundFlowControl();
            }
        }

        @Override
        protected void onResponseImpl(T response) {
            this.responses.add(response);
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            this.done.setException(t);
        }

        @Override
        protected void onCompleteImpl() {
            this.done.set(null);
        }

        public StreamController getController() {
            return this.controller;
        }

        public T popNextResponse() {
            try {
                return this.responses.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public Throwable getFinalError() {
            try {
                this.done.get(1L, TimeUnit.SECONDS);
                return null;
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
            catch (Throwable t) {
                return t;
            }
        }

        public boolean isDone() {
            return this.done.isDone();
        }
    }

    public static class MockStreamController<ResponseT>
    implements StreamController {
        private final ResponseObserver<ResponseT> downstreamObserver;
        private final BlockingQueue<Integer> pulls = Queues.newLinkedBlockingQueue();
        private SettableApiFuture<Boolean> cancelFuture = SettableApiFuture.create();
        private boolean autoFlowControl = true;

        public MockStreamController(ResponseObserver<ResponseT> downstreamObserver) {
            this.downstreamObserver = downstreamObserver;
        }

        @Override
        public void disableAutoInboundFlowControl() {
            this.autoFlowControl = false;
        }

        @Override
        public void request(int count) {
            this.pulls.add(count);
        }

        @Override
        public void cancel() {
            this.cancelFuture.set(true);
        }

        public ResponseObserver<ResponseT> getObserver() {
            return this.downstreamObserver;
        }

        public boolean isAutoFlowControlEnabled() {
            return this.autoFlowControl;
        }

        public boolean isCancelled() {
            return this.cancelFuture.isDone();
        }

        public void waitForCancel() {
            try {
                this.cancelFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int popLastPull() {
            Integer results;
            try {
                results = this.pulls.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            if (results == null) {
                return 0;
            }
            return results;
        }
    }

    public static class MockServerStreamingCall<RequestT, ResponseT> {
        private final RequestT request;
        private final MockStreamController<ResponseT> controller;

        public MockServerStreamingCall(RequestT request, MockStreamController<ResponseT> controller) {
            this.request = request;
            this.controller = controller;
        }

        public RequestT getRequest() {
            return this.request;
        }

        public MockStreamController<ResponseT> getController() {
            return this.controller;
        }
    }

    public static class MockServerStreamingCallable<RequestT, ResponseT>
    extends ServerStreamingCallable<RequestT, ResponseT> {
        private final BlockingQueue<MockServerStreamingCall<RequestT, ResponseT>> calls = Queues.newLinkedBlockingDeque();

        @Override
        public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
            MockStreamController<ResponseT> controller = new MockStreamController<ResponseT>(responseObserver);
            this.calls.add(new MockServerStreamingCall<RequestT, ResponseT>(request, controller));
            responseObserver.onStart(controller);
        }

        public MockServerStreamingCall<RequestT, ResponseT> popLastCall() {
            try {
                return this.calls.poll(1L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                return null;
            }
        }
    }
}

