/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.collect.ImmutableBiMap;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.common.collect.Maps;
import autovalue.shaded.com.google.common.collect.Sets;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.processor.AutoBuilderTemplateVars;
import com.google.auto.value.processor.AutoValueOrBuilderTemplateVars;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.BuilderMethodClassifierForAutoValue;
import com.google.auto.value.processor.BuilderRequiredProperties;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeMirrorSet;
import com.google.auto.value.processor.TypeSimplifier;
import com.google.auto.value.processor.TypeVariables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

class BuilderSpec {
    private final TypeElement autoValueClass;
    private final ProcessingEnvironment processingEnv;
    private final ErrorReporter errorReporter;
    private static final ImmutableSet<ElementKind> CLASS_OR_INTERFACE = Sets.immutableEnumSet((Enum)ElementKind.CLASS, (Enum[])new ElementKind[]{ElementKind.INTERFACE});

    BuilderSpec(TypeElement autoValueClass, ProcessingEnvironment processingEnv, ErrorReporter errorReporter) {
        this.autoValueClass = autoValueClass;
        this.processingEnv = processingEnv;
        this.errorReporter = errorReporter;
    }

    Optional<Builder> getBuilder() {
        Optional<Object> builderTypeElement = Optional.empty();
        for (TypeElement containedClass : ElementFilter.typesIn(this.autoValueClass.getEnclosedElements())) {
            if (!AutoValueishProcessor.hasAnnotationMirror(containedClass, "com.google.auto.value.AutoValue.Builder")) continue;
            this.findBuilderError(containedClass).ifPresent(error -> this.errorReporter.reportError(containedClass, "%s", error));
            if (builderTypeElement.isPresent()) {
                this.errorReporter.reportError(containedClass, "[AutoValueTwoBuilders] %s already has a Builder: %s", this.autoValueClass, builderTypeElement.get());
                continue;
            }
            builderTypeElement = Optional.of(containedClass);
        }
        if (builderTypeElement.isPresent()) {
            return this.builderFrom((TypeElement)builderTypeElement.get());
        }
        return Optional.empty();
    }

    private Optional<String> findBuilderError(TypeElement builderTypeElement) {
        if (!CLASS_OR_INTERFACE.contains((Object)builderTypeElement.getKind())) {
            return Optional.of("[AutoValueBuilderClass] @AutoValue.Builder can only apply to a class or an interface");
        }
        if (!builderTypeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return Optional.of("[AutoValueInnerBuilder] @AutoValue.Builder cannot be applied to a non-static class");
        }
        if (builderTypeElement.getKind().equals((Object)ElementKind.CLASS) && !AutoValueishProcessor.hasVisibleNoArgConstructor(builderTypeElement)) {
            return Optional.of("[AutoValueBuilderConstructor] @AutoValue.Builder class must have a non-private no-arg constructor");
        }
        return Optional.empty();
    }

    private Optional<Builder> builderFrom(TypeElement builderTypeElement) {
        if (!BuilderSpec.sameTypeParameters(this.autoValueClass, builderTypeElement)) {
            this.errorReporter.reportError(builderTypeElement, "[AutoValueTypeParamMismatch] Type parameters of %s must have same names and bounds as type parameters of %s", builderTypeElement, this.autoValueClass);
            return Optional.empty();
        }
        return Optional.of(new Builder(builderTypeElement));
    }

    private static boolean sameTypeParameters(TypeElement a, TypeElement b) {
        return BuilderSpec.sameTypeParameters(a.getTypeParameters(), b.getTypeParameters());
    }

    static boolean sameTypeParameters(List<? extends TypeParameterElement> aParams, List<? extends TypeParameterElement> bParams) {
        int nTypeParameters = aParams.size();
        if (nTypeParameters != bParams.size()) {
            return false;
        }
        for (int i = 0; i < nTypeParameters; ++i) {
            TypeMirrorSet bBounds;
            TypeParameterElement aParam = aParams.get(i);
            TypeParameterElement bParam = bParams.get(i);
            if (!aParam.getSimpleName().equals(bParam.getSimpleName())) {
                return false;
            }
            TypeMirrorSet aBounds = new TypeMirrorSet(aParam.getBounds());
            if (aBounds.equals(bBounds = new TypeMirrorSet(bParam.getBounds()))) continue;
            return false;
        }
        return true;
    }

    static ImmutableSet<ExecutableElement> abstractMethods(TypeElement typeElement, ProcessingEnvironment processingEnv) {
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(typeElement, processingEnv.getTypeUtils(), processingEnv.getElementUtils());
        ImmutableSet.Builder abstractMethods = ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            MissingTypes.deferIfMissingTypesIn(method);
            abstractMethods.add(method);
        }
        return abstractMethods.build();
    }

    private String typeParamsString() {
        return TypeSimplifier.actualTypeParametersString(this.autoValueClass);
    }

    public static class PropertySetter {
        private final ExecutableElement setter;
        private final String access;
        private final String name;
        private final String parameterTypeString;
        private final boolean primitiveParameter;
        private final String nullableAnnotation;
        private final Copier copier;

        PropertySetter(ExecutableElement setter, TypeMirror parameterType, Copier copier) {
            this.setter = setter;
            this.copier = copier;
            this.access = SimpleMethod.access(setter);
            this.name = setter.getSimpleName().toString();
            this.primitiveParameter = parameterType.getKind().isPrimitive();
            this.parameterTypeString = PropertySetter.parameterTypeString(setter, parameterType);
            VariableElement parameterElement = Iterables.getOnlyElement(setter.getParameters());
            Optional<String> maybeNullable = AutoValueishProcessor.nullableAnnotationFor(parameterElement, parameterType);
            this.nullableAnnotation = maybeNullable.orElse("");
        }

        ExecutableElement getSetter() {
            return this.setter;
        }

        private static String parameterTypeString(ExecutableElement setter, TypeMirror parameterType) {
            if (setter.isVarArgs()) {
                TypeMirror componentType = MoreTypes.asArray(parameterType).getComponentType();
                return TypeEncoder.encodeWithAnnotations(componentType) + "...";
            }
            return TypeEncoder.encodeWithAnnotations(parameterType);
        }

        public String getAccess() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public String getParameterType() {
            return this.parameterTypeString;
        }

        public boolean getPrimitiveParameter() {
            return this.primitiveParameter;
        }

        public String getNullableAnnotation() {
            return this.nullableAnnotation;
        }

        public String copy(AutoValueishProcessor.Property property) {
            String copy = (String)this.copier.copy.apply(property.toString());
            if (property.isNullable() && !this.copier.acceptsNull) {
                copy = String.format("(%s == null ? null : %s)", property, copy);
            }
            return copy;
        }
    }

    static class Copier {
        static final Copier IDENTITY = Copier.acceptingNull(x -> x);
        private final Function<String, String> copy;
        private final boolean acceptsNull;

        private Copier(Function<String, String> copy, boolean acceptsNull) {
            this.copy = copy;
            this.acceptsNull = acceptsNull;
        }

        static Copier acceptingNull(Function<String, String> copy) {
            return new Copier(copy, true);
        }

        static Copier notAcceptingNull(Function<String, String> copy) {
            return new Copier(copy, false);
        }
    }

    public static class PropertyGetter {
        private final String name;
        private final String access;
        private final String type;
        private final Optionalish optional;

        PropertyGetter(ExecutableElement method, String type, Optionalish optional) {
            this.name = method.getSimpleName().toString();
            this.access = SimpleMethod.access(method);
            this.type = type;
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public String getAccess() {
            return this.access;
        }

        public String getType() {
            return this.type;
        }

        public Optionalish getOptional() {
            return this.optional;
        }
    }

    class Builder
    implements AutoValueExtension.BuilderContext {
        private final TypeElement builderTypeElement;
        private ImmutableSet<ExecutableElement> toBuilderMethods;
        private ExecutableElement buildMethod;
        private BuilderMethodClassifier<?> classifier;

        Builder(TypeElement builderTypeElement) {
            this.builderTypeElement = builderTypeElement;
        }

        @Override
        public TypeElement builderType() {
            return this.builderTypeElement;
        }

        @Override
        public Set<ExecutableElement> builderMethods() {
            return ElementFilter.methodsIn(BuilderSpec.this.autoValueClass.getEnclosedElements()).stream().filter(m3 -> m3.getParameters().isEmpty() && m3.getModifiers().contains((Object)Modifier.STATIC) && !m3.getModifiers().contains((Object)Modifier.PRIVATE) && this.erasedTypeIs(m3.getReturnType(), this.builderTypeElement)).collect(Collectors.toSet());
        }

        @Override
        public Optional<ExecutableElement> buildMethod() {
            Types typeUtils = BuilderSpec.this.processingEnv.getTypeUtils();
            DeclaredType builderTypeMirror = MoreTypes.asDeclared(this.builderTypeElement.asType());
            return MoreElements.getLocalAndInheritedMethods(this.builderTypeElement, typeUtils, BuilderSpec.this.processingEnv.getElementUtils()).stream().filter(m3 -> m3.getSimpleName().contentEquals("build") && !m3.getModifiers().contains((Object)Modifier.PRIVATE) && !m3.getModifiers().contains((Object)Modifier.STATIC) && m3.getParameters().isEmpty()).filter(m3 -> {
                ExecutableType methodMirror = MoreTypes.asExecutable(typeUtils.asMemberOf(builderTypeMirror, (Element)m3));
                return this.erasedTypeIs(methodMirror.getReturnType(), BuilderSpec.this.autoValueClass);
            }).findFirst();
        }

        @Override
        public ExecutableElement autoBuildMethod() {
            return this.buildMethod;
        }

        @Override
        public Map<String, Set<ExecutableElement>> setters() {
            return Maps.transformValues(this.classifier.propertyNameToSetters().asMap(), propertySetters -> propertySetters.stream().map(PropertySetter::getSetter).collect(Collectors.toSet()));
        }

        @Override
        public Map<String, ExecutableElement> propertyBuilders() {
            return Maps.transformValues(this.classifier.propertyNameToPropertyBuilder(), PropertyBuilderClassifier.PropertyBuilder::getPropertyBuilderMethod);
        }

        private boolean erasedTypeIs(TypeMirror type, TypeElement baseType) {
            return type.getKind().equals((Object)TypeKind.DECLARED) && MoreTypes.asDeclared(type).asElement().equals(baseType);
        }

        @Override
        public Set<ExecutableElement> toBuilderMethods() {
            return this.toBuilderMethods;
        }

        ImmutableSet<ExecutableElement> toBuilderMethods(Types typeUtils, TypeElement autoValueType, Set<ExecutableElement> abstractMethods) {
            List builderTypeParamNames = this.builderTypeElement.getTypeParameters().stream().map(e -> e.getSimpleName().toString()).collect(Collectors.toList());
            DeclaredType autoValueTypeMirror = MoreTypes.asDeclared(autoValueType.asType());
            ImmutableSet.Builder methods = ImmutableSet.builder();
            for (ExecutableElement method : abstractMethods) {
                ExecutableType methodMirror;
                TypeMirror returnTypeMirror;
                if (!method.getParameters().isEmpty() || !this.builderTypeElement.equals(typeUtils.asElement(returnTypeMirror = (methodMirror = MoreTypes.asExecutable(typeUtils.asMemberOf(autoValueTypeMirror, method))).getReturnType()))) continue;
                methods.add(method);
                DeclaredType returnType = MoreTypes.asDeclared(returnTypeMirror);
                List typeArguments = returnType.getTypeArguments().stream().filter(t -> t.getKind().equals((Object)TypeKind.TYPEVAR)).map(t -> typeUtils.asElement((TypeMirror)t).getSimpleName().toString()).collect(Collectors.toList());
                if (builderTypeParamNames.equals(typeArguments)) continue;
                BuilderSpec.this.errorReporter.reportError(method, "[AutoValueBuilderConverterReturn] Builder converter method should return %s%s", this.builderTypeElement, TypeSimplifier.actualTypeParametersString(this.builderTypeElement));
            }
            ImmutableCollection builderMethods = methods.build();
            if (builderMethods.size() > 1) {
                BuilderSpec.this.errorReporter.reportError((Element)((ImmutableSet)builderMethods).iterator().next(), "[AutoValueTwoBuilderConverters] There can be at most one builder converter method", new Object[0]);
            }
            this.toBuilderMethods = builderMethods;
            return builderMethods;
        }

        void defineVarsForAutoValue(AutoValueOrBuilderTemplateVars vars, ImmutableBiMap<ExecutableElement, String> getterToPropertyName) {
            ImmutableSet<ExecutableElement> builderMethods = BuilderSpec.abstractMethods(this.builderTypeElement, BuilderSpec.this.processingEnv);
            boolean autoValueHasToBuilder = this.toBuilderMethods != null && !this.toBuilderMethods.isEmpty();
            ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType = TypeVariables.rewriteReturnTypes(BuilderSpec.this.processingEnv.getElementUtils(), BuilderSpec.this.processingEnv.getTypeUtils(), getterToPropertyName.keySet(), BuilderSpec.this.autoValueClass, this.builderTypeElement);
            ImmutableMap.Builder rewrittenPropertyTypes = ImmutableMap.builder();
            getterToPropertyType.forEach((getter, type) -> rewrittenPropertyTypes.put((String)getterToPropertyName.get(getter), type));
            Optional<BuilderMethodClassifier<ExecutableElement>> optionalClassifier = BuilderMethodClassifierForAutoValue.classify(builderMethods, BuilderSpec.this.errorReporter, BuilderSpec.this.processingEnv, BuilderSpec.this.autoValueClass, this.builderTypeElement, getterToPropertyName, rewrittenPropertyTypes.build(), autoValueHasToBuilder);
            if (!optionalClassifier.isPresent()) {
                return;
            }
            for (ExecutableElement method : ElementFilter.methodsIn(this.builderTypeElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals("builder") || !method.getModifiers().contains((Object)Modifier.STATIC) || !method.getAnnotationMirrors().isEmpty() || vars instanceof AutoBuilderTemplateVars) continue;
                BuilderSpec.this.errorReporter.reportWarning(method, "[AutoValueBuilderInBuilder] Static builder() method should be in the containing class", new Object[0]);
            }
            this.defineVars(vars, optionalClassifier.get());
        }

        void defineVars(AutoValueOrBuilderTemplateVars vars, BuilderMethodClassifier<?> classifier) {
            this.classifier = classifier;
            Set<ExecutableElement> buildMethods = classifier.buildMethods();
            if (buildMethods.size() != 1) {
                Set<ExecutableElement> errorElements = buildMethods.isEmpty() ? ImmutableSet.of(this.builderTypeElement) : buildMethods;
                for (Element element : errorElements) {
                    BuilderSpec.this.errorReporter.reportError(element, "[AutoValueBuilderBuild] Builder must have a single no-argument method, typically called build(), that returns %s%s", BuilderSpec.this.autoValueClass, BuilderSpec.this.typeParamsString());
                }
                BuilderSpec.this.errorReporter.abortIfAnyError();
                return;
            }
            this.buildMethod = Iterables.getOnlyElement(buildMethods);
            vars.builderIsInterface = this.builderTypeElement.getKind() == ElementKind.INTERFACE;
            vars.builderTypeName = TypeSimplifier.classNameOf(this.builderTypeElement);
            vars.builderFormalTypes = TypeEncoder.typeParametersString(this.builderTypeElement.getTypeParameters());
            vars.builderActualTypes = TypeSimplifier.actualTypeParametersString(this.builderTypeElement);
            vars.buildMethod = Optional.of(new SimpleMethod(this.buildMethod));
            vars.builderGetters = classifier.builderGetters();
            vars.builderSetters = classifier.propertyNameToSetters();
            vars.builderPropertyBuilders = ImmutableMap.copyOf(classifier.propertyNameToPropertyBuilder());
            ImmutableSet<AutoValueishProcessor.Property> requiredProperties = vars.props.stream().filter(p -> !p.isNullable()).filter(p -> p.getBuilderInitializer().isEmpty()).filter(p -> !p.hasDefault()).filter(p -> !vars.builderPropertyBuilders.containsKey(p.getName())).collect(MoreStreams.toImmutableSet());
            vars.builderRequiredProperties = BuilderRequiredProperties.of(vars.props, requiredProperties);
        }
    }
}

