/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.LineComment;
import com.google.api.generator.gapic.model.AutoValue_RegionTag;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class RegionTag {
    public abstract String apiShortName();

    public abstract String apiVersion();

    public abstract String serviceName();

    public abstract String rpcName();

    public abstract String overloadDisambiguation();

    public abstract Boolean isAsynchronous();

    public static Builder builder() {
        return new AutoValue_RegionTag.Builder().setApiVersion("").setApiShortName("").setOverloadDisambiguation("").setIsAsynchronous(false);
    }

    public abstract Builder toBuilder();

    public final RegionTag withApiVersion(String apiVersion) {
        return this.toBuilder().setApiVersion(apiVersion).build();
    }

    public final RegionTag withApiShortName(String apiShortName) {
        return this.toBuilder().setApiShortName(apiShortName).build();
    }

    public final RegionTag withOverloadDisambiguation(String overloadDisambiguation) {
        return this.toBuilder().setOverloadDisambiguation(overloadDisambiguation).build();
    }

    public String generate() {
        Preconditions.checkState(!this.apiShortName().isEmpty(), "apiShortName can't be empty");
        Preconditions.checkState(!this.serviceName().isEmpty(), "serviceName can't be empty");
        Preconditions.checkState(!this.rpcName().isEmpty(), "rpcName can't be empty");
        String rt = this.apiShortName() + "_";
        if (!this.apiVersion().isEmpty()) {
            rt = rt + this.apiVersion() + "_";
        }
        rt = rt.toLowerCase() + "generated_" + this.serviceName() + "_" + this.rpcName();
        if (!this.overloadDisambiguation().isEmpty()) {
            rt = rt + "_" + this.overloadDisambiguation();
        }
        rt = this.isAsynchronous() != false ? rt + "_async" : rt + "_sync";
        return rt;
    }

    public static CommentStatement generateTag(RegionTagRegion regionTagRegion, String regionTagContent) {
        return CommentStatement.withComment(LineComment.withComment("[" + regionTagRegion.name() + " " + regionTagContent + "]"));
    }

    public static enum RegionTagRegion {
        START,
        END;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setApiVersion(String var1);

        public abstract Builder setApiShortName(String var1);

        public abstract Builder setServiceName(String var1);

        public abstract Builder setRpcName(String var1);

        public abstract Builder setOverloadDisambiguation(String var1);

        public abstract Builder setIsAsynchronous(Boolean var1);

        abstract String apiVersion();

        abstract String apiShortName();

        abstract String serviceName();

        abstract String rpcName();

        abstract String overloadDisambiguation();

        abstract RegionTag autoBuild();

        public final RegionTag build() {
            this.setApiVersion(this.sanitizeAttributes(this.apiVersion()));
            this.setApiShortName(this.sanitizeAttributes(this.apiShortName()));
            this.setServiceName(this.sanitizeAttributes(this.serviceName()));
            this.setRpcName(this.sanitizeAttributes(this.rpcName()));
            this.setOverloadDisambiguation(this.sanitizeAttributes(this.overloadDisambiguation()));
            return this.autoBuild();
        }

        private final String sanitizeAttributes(String attribute) {
            return JavaStyle.toUpperCamelCase(attribute.replaceAll("[^a-zA-Z0-9]", ""));
        }
    }
}

