/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GdchCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class GoogleCredentials
extends OAuth2Credentials
implements QuotaProjectIdProvider {
    private static final long serialVersionUID = -1522852442442473691L;
    static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    static final String USER_FILE_TYPE = "authorized_user";
    static final String SERVICE_ACCOUNT_FILE_TYPE = "service_account";
    static final String GDCH_SERVICE_ACCOUNT_FILE_TYPE = "gdch_service_account";
    protected final String quotaProjectId;
    private static final DefaultCredentialsProvider defaultCredentialsProvider = new DefaultCredentialsProvider();

    public static GoogleCredentials create(AccessToken accessToken) {
        return GoogleCredentials.newBuilder().setAccessToken(accessToken).build();
    }

    public static GoogleCredentials getApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault(OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials getApplicationDefault(HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(transportFactory);
        return defaultCredentialsProvider.getDefaultCredentials(transportFactory);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream) throws IOException {
        return GoogleCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        Preconditions.checkNotNull(transportFactory);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get("type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if (USER_FILE_TYPE.equals(fileType)) {
            return UserCredentials.fromJson(fileContents, transportFactory);
        }
        if (SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return ServiceAccountCredentials.fromJson(fileContents, transportFactory);
        }
        if (GDCH_SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return GdchCredentials.fromJson(fileContents);
        }
        if ("external_account".equals(fileType)) {
            return ExternalAccountCredentials.fromJson(fileContents, transportFactory);
        }
        if ("impersonated_service_account".equals(fileType)) {
            return ImpersonatedCredentials.fromJson(fileContents, transportFactory);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s' or '%s'.", fileType, USER_FILE_TYPE, SERVICE_ACCOUNT_FILE_TYPE));
    }

    public GoogleCredentials createWithQuotaProject(String quotaProject) {
        return this.toBuilder().setQuotaProjectId(quotaProject).build();
    }

    static Map<String, List<String>> addQuotaProjectIdToRequestMetadata(String quotaProjectId, Map<String, List<String>> requestMetadata) {
        Preconditions.checkNotNull(requestMetadata);
        HashMap<String, List<String>> newRequestMetadata = new HashMap<String, List<String>>(requestMetadata);
        if (quotaProjectId != null && !requestMetadata.containsKey(QUOTA_PROJECT_ID_HEADER_KEY)) {
            newRequestMetadata.put(QUOTA_PROJECT_ID_HEADER_KEY, Collections.singletonList(quotaProjectId));
        }
        return Collections.unmodifiableMap(newRequestMetadata);
    }

    @Override
    protected Map<String, List<String>> getAdditionalHeaders() {
        Map<String, List<String>> headers = super.getAdditionalHeaders();
        String quotaProjectId = this.getQuotaProjectId();
        if (quotaProjectId != null) {
            return GoogleCredentials.addQuotaProjectIdToRequestMetadata(quotaProjectId, headers);
        }
        return headers;
    }

    protected GoogleCredentials() {
        this(new Builder());
    }

    protected GoogleCredentials(AccessToken accessToken, String quotaProjectId) {
        super(accessToken);
        this.quotaProjectId = quotaProjectId;
    }

    public GoogleCredentials(AccessToken accessToken) {
        this(accessToken, null);
    }

    protected GoogleCredentials(Builder builder) {
        this(builder.getAccessToken(), builder.getQuotaProjectId());
    }

    protected GoogleCredentials(AccessToken accessToken, Duration refreshMargin, Duration expirationMargin) {
        super(accessToken, refreshMargin, expirationMargin);
        this.quotaProjectId = null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    public boolean createScopedRequired() {
        return false;
    }

    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this;
    }

    public GoogleCredentials createScoped(Collection<String> scopes, Collection<String> defaultScopes) {
        return this;
    }

    public GoogleCredentials createScoped(String ... scopes) {
        return this.createScoped(ImmutableList.copyOf(scopes));
    }

    public GoogleCredentials createWithCustomRetryStrategy(boolean defaultRetriesEnabled) {
        return this;
    }

    public GoogleCredentials createDelegated(String user) {
        return this;
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        @Nullable
        protected String quotaProjectId;

        protected Builder() {
        }

        protected Builder(GoogleCredentials credentials) {
            this.setAccessToken(credentials.getAccessToken());
            this.quotaProjectId = credentials.quotaProjectId;
        }

        @Override
        public GoogleCredentials build() {
            return new GoogleCredentials(this);
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        @Override
        public Builder setAccessToken(AccessToken token) {
            super.setAccessToken(token);
            return this;
        }
    }
}

