/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.common;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.JavaDocComment;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.comment.StubCommentComposer;
import com.google.api.generator.gapic.composer.common.ClassComposer;
import com.google.api.generator.gapic.composer.common.TransportContext;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.composer.utils.PackageChecker;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.Nullable;

public abstract class AbstractTransportServiceStubClassComposer
implements ClassComposer {
    private static final Statement EMPTY_LINE_STATEMENT = EmptyLineStatement.create();
    private static final String METHOD_DESCRIPTOR_NAME_PATTERN = "%sMethodDescriptor";
    private static final String PAGED_RESPONSE_TYPE_NAME_PATTERN = "%sPagedResponse";
    private static final String PAGED_CALLABLE_CLASS_MEMBER_PATTERN = "%sPagedCallable";
    private static final String BACKGROUND_RESOURCES_MEMBER_NAME = "backgroundResources";
    private static final String CALLABLE_NAME = "Callable";
    private static final String CALLABLE_FACTORY_MEMBER_NAME = "callableFactory";
    private static final String CALLABLE_CLASS_MEMBER_PATTERN = "%sCallable";
    private static final String OPERATION_CALLABLE_CLASS_MEMBER_PATTERN = "%sOperationCallable";
    private static final String OPERATION_CALLABLE_NAME = "OperationCallable";
    private static final String PAGED_CALLABLE_NAME = "PagedCallable";
    protected static final TypeStore FIXED_TYPESTORE = AbstractTransportServiceStubClassComposer.createStaticTypes();
    private final TransportContext transportContext;

    protected AbstractTransportServiceStubClassComposer(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public TransportContext getTransportContext() {
        return this.transportContext;
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(BackgroundResource.class, BackgroundResourceAggregation.class, BetaApi.class, BidiStreamingCallable.class, ClientContext.class, ClientStreamingCallable.class, Generated.class, ImmutableMap.class, InterruptedException.class, IOException.class, Operation.class, OperationCallable.class, OperationSnapshot.class, RequestParamsExtractor.class, ServerStreamingCallable.class, TimeUnit.class, UnaryCallable.class);
        return new TypeStore(concreteClazzes);
    }

    @Override
    public GapicClass generate(GapicContext context, Service service) {
        VariableExpr longRunningVarExpr;
        boolean operationPollingMethod;
        String pakkage = service.pakkage() + ".stub";
        TypeStore typeStore = this.createDynamicTypes(service, pakkage);
        String className = this.getTransportContext().classNames().getTransportServiceStubClassName(service);
        GapicClass.Kind kind = GapicClass.Kind.STUB;
        Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs = this.createProtoMethodNameToDescriptorClassMembers(service, this.getTransportContext().methodDescriptorClass());
        Map<String, VariableExpr> callableClassMemberVarExprs = this.createCallableClassMembers(service, typeStore);
        LinkedHashMap<String, VariableExpr> classMemberVarExprs = new LinkedHashMap<String, VariableExpr>();
        classMemberVarExprs.put(BACKGROUND_RESOURCES_MEMBER_NAME, VariableExpr.withVariable(Variable.builder().setName(BACKGROUND_RESOURCES_MEMBER_NAME).setType(FIXED_TYPESTORE.get("BackgroundResource")).build()));
        if (this.generateOperationsStubLogic(service)) {
            TypeNode operationsStubType = this.getTransportOperationsStubType(service);
            classMemberVarExprs.put(this.getTransportContext().transportOperationsStubNames().get(0), VariableExpr.withVariable(Variable.builder().setName(this.getTransportContext().transportOperationsStubNames().get(0)).setType(operationsStubType).build()));
        }
        if ((operationPollingMethod = this.checkOperationPollingMethod(service)) && (longRunningVarExpr = this.declareLongRunningClient()) != null) {
            classMemberVarExprs.put("longRunningClient", longRunningVarExpr);
        }
        classMemberVarExprs.put(CALLABLE_FACTORY_MEMBER_NAME, VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build()));
        ImmutableMap<String, Message> messageTypes = context.messages();
        List<Statement> classStatements = this.createClassStatements(service, protoMethodNameToDescriptorVarExprs, callableClassMemberVarExprs, classMemberVarExprs, messageTypes, context.restNumericEnumsEnabled());
        StubCommentComposer commentComposer = new StubCommentComposer(this.getTransportContext().transportNames().get(0));
        ClassDefinition.Builder builder = ClassDefinition.builder().setPackageString(pakkage).setHeaderCommentStatements(commentComposer.createTransportServiceStubClassHeaderComments(service.name(), service.isDeprecated())).setAnnotations(this.createClassAnnotations(service)).setScope(ScopeNode.PUBLIC).setName(className);
        this.getTransportContext().classNames();
        ClassDefinition classDef = builder.setExtendsType(typeStore.get(ClassNames.getServiceStubClassName(service))).setMethods(this.createClassMethods(context, service, typeStore, classMemberVarExprs, callableClassMemberVarExprs, protoMethodNameToDescriptorVarExprs, classStatements)).setStatements(classStatements).build();
        return GapicClass.create(kind, classDef);
    }

    protected boolean isSupportedMethod(Method method) {
        return true;
    }

    protected abstract Statement createMethodDescriptorVariableDecl(Service var1, Method var2, VariableExpr var3, Map<String, Message> var4, boolean var5);

    protected boolean generateOperationsStubLogic(Service service) {
        return true;
    }

    protected List<MethodDefinition> createOperationsStubGetterMethod(Service service, VariableExpr operationsStubVarExpr) {
        if (!this.generateOperationsStubLogic(service)) {
            return Collections.emptyList();
        }
        String methodName = String.format("get%s", JavaStyle.toUpperCamelCase(this.getTransportContext().transportOperationsStubNames().get(0)));
        return Arrays.asList(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(operationsStubVarExpr.type()).setName(methodName).setReturnExpr(operationsStubVarExpr).build());
    }

    protected abstract Expr createTransportSettingsInitExpr(Method var1, VariableExpr var2, VariableExpr var3, List<Statement> var4);

    protected List<MethodDefinition> createGetMethodDescriptorsMethod(Service service, TypeStore typeStore, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs) {
        return Arrays.asList(new MethodDefinition[0]);
    }

    protected List<Statement> createTypeRegistry(Service service) {
        return Arrays.asList(new Statement[0]);
    }

    protected List<Statement> createClassStatements(Service service, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, Map<String, VariableExpr> callableClassMemberVarExprs, Map<String, VariableExpr> classMemberVarExprs, Map<String, Message> messageTypes, boolean restNumericEnumsEnabled) {
        ArrayList<Statement> classStatements = new ArrayList<Statement>();
        classStatements.addAll(this.createTypeRegistry(service));
        if (!classStatements.isEmpty()) {
            classStatements.add(EMPTY_LINE_STATEMENT);
        }
        for (Statement statement : this.createMethodDescriptorVariableDecls(service, protoMethodNameToDescriptorVarExprs, messageTypes, restNumericEnumsEnabled)) {
            classStatements.add(statement);
            classStatements.add(EMPTY_LINE_STATEMENT);
        }
        classStatements.addAll(AbstractTransportServiceStubClassComposer.createClassMemberFieldDeclarations(callableClassMemberVarExprs));
        classStatements.add(EMPTY_LINE_STATEMENT);
        classStatements.addAll(AbstractTransportServiceStubClassComposer.createClassMemberFieldDeclarations(classMemberVarExprs));
        classStatements.add(EMPTY_LINE_STATEMENT);
        return classStatements;
    }

    protected List<Statement> createMethodDescriptorVariableDecls(Service service, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, Map<String, Message> messageTypes, boolean restNumericEnumsEnabled) {
        return service.methods().stream().filter(this::isSupportedMethod).map(m3 -> this.createMethodDescriptorVariableDecl(service, (Method)m3, (VariableExpr)protoMethodNameToDescriptorVarExprs.get(m3.name()), messageTypes, restNumericEnumsEnabled)).collect(Collectors.toList());
    }

    private static List<Statement> createClassMemberFieldDeclarations(Map<String, VariableExpr> fieldNameToVarExprs) {
        return fieldNameToVarExprs.values().stream().map(v -> ExprStatement.withExpr(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsFinal(true).build())).collect(Collectors.toList());
    }

    protected Map<String, VariableExpr> createProtoMethodNameToDescriptorClassMembers(Service service, Class<?> descriptorClass) {
        return service.methods().stream().filter(this::isSupportedMethod).collect(Collectors.toMap(Method::name, m3 -> VariableExpr.withVariable(Variable.builder().setName(String.format(METHOD_DESCRIPTOR_NAME_PATTERN, JavaStyle.toLowerCamelCase(m3.name()))).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(descriptorClass).setGenerics(Arrays.asList(m3.inputType().reference(), m3.outputType().reference())).build())).build()), (u, v) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    private Map<String, VariableExpr> createCallableClassMembers(Service service, TypeStore typeStore) {
        LinkedHashMap<String, VariableExpr> callableClassMembers = new LinkedHashMap<String, VariableExpr>();
        for (Method protoMethod : service.methods()) {
            if (!this.isSupportedMethod(protoMethod)) continue;
            String javaStyleProtoMethodName = JavaStyle.toLowerCamelCase(protoMethod.name());
            String callableName = String.format(CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
            callableClassMembers.put(callableName, VariableExpr.withVariable(Variable.builder().setName(callableName).setType(AbstractTransportServiceStubClassComposer.getCallableType(protoMethod)).build()));
            if (protoMethod.hasLro()) {
                callableName = String.format(OPERATION_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
                callableClassMembers.put(callableName, VariableExpr.withVariable(Variable.builder().setName(callableName).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(OperationCallable.class).setGenerics(Arrays.asList(protoMethod.inputType().reference(), protoMethod.lro().responseType().reference(), protoMethod.lro().metadataType().reference())).build())).build()));
            }
            if (!protoMethod.isPaged()) continue;
            callableName = String.format(PAGED_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
            callableClassMembers.put(callableName, VariableExpr.withVariable(Variable.builder().setName(callableName).setType(TypeNode.withReference(AbstractTransportServiceStubClassComposer.getCallableType(protoMethod).reference().copyAndSetGenerics(Arrays.asList(protoMethod.inputType().reference(), typeStore.get(String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, protoMethod.name())).reference())))).build()));
        }
        return callableClassMembers;
    }

    protected List<AnnotationNode> createClassAnnotations(Service service) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (!PackageChecker.isGaApi(service.pakkage())) {
            annotations.add(AnnotationNode.withType(FIXED_TYPESTORE.get("BetaApi")));
        }
        if (service.isDeprecated()) {
            annotations.add(AnnotationNode.withType(TypeNode.DEPRECATED));
        }
        annotations.add(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("Generated")).setDescription("by gapic-generator-java").build());
        return annotations;
    }

    protected List<MethodDefinition> createClassMethods(GapicContext context, Service service, TypeStore typeStore, Map<String, VariableExpr> classMemberVarExprs, Map<String, VariableExpr> callableClassMemberVarExprs, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, List<Statement> classStatements) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.addAll(this.createStaticCreatorMethods(service, typeStore, "newBuilder"));
        javaMethods.addAll(this.createConstructorMethods(context, service, typeStore, classMemberVarExprs, callableClassMemberVarExprs, protoMethodNameToDescriptorVarExprs, classStatements));
        javaMethods.addAll(this.createGetMethodDescriptorsMethod(service, typeStore, protoMethodNameToDescriptorVarExprs));
        javaMethods.addAll(this.createOperationsStubGetterMethod(service, classMemberVarExprs.get(this.getTransportContext().transportOperationsStubNames().get(0))));
        javaMethods.addAll(AbstractTransportServiceStubClassComposer.createCallableGetterMethods(callableClassMemberVarExprs));
        javaMethods.addAll(this.createStubOverrideMethods(classMemberVarExprs.get(BACKGROUND_RESOURCES_MEMBER_NAME), service));
        return javaMethods;
    }

    protected List<MethodDefinition> createStaticCreatorMethods(Service service, TypeStore typeStore, String newBuilderMethod) {
        TypeNode creatorMethodReturnType = typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service));
        Function<List, MethodDefinition.Builder> creatorMethodStarterFn = argList -> MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setIsFinal(true).setReturnType(creatorMethodReturnType).setName("create").setArguments(argList.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(TypeNode.withReference(ConcreteReference.withClazz(IOException.class))));
        Function<List, Expr> instantiatorExprFn = argList -> NewObjectExpr.builder().setType(creatorMethodReturnType).setArguments((List<Expr>)argList).build();
        this.getTransportContext().classNames();
        TypeNode stubSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(stubSettingsType).build());
        TypeNode clientContextType = FIXED_TYPESTORE.get("ClientContext");
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setName("clientContext").setType(clientContextType).build());
        VariableExpr callableFactoryVarExpr = VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build());
        MethodInvocationExpr clientContextCreateMethodExpr = MethodInvocationExpr.builder().setMethodName("create").setStaticReferenceType(clientContextType).setArguments(Arrays.asList(settingsVarExpr)).build();
        MethodInvocationExpr settingsBuilderMethodExpr = MethodInvocationExpr.builder().setMethodName(newBuilderMethod).setStaticReferenceType(stubSettingsType).build();
        settingsBuilderMethodExpr = MethodInvocationExpr.builder().setMethodName("build").setExprReferenceExpr(settingsBuilderMethodExpr).build();
        return Arrays.asList(creatorMethodStarterFn.apply(Arrays.asList(settingsVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsVarExpr, clientContextCreateMethodExpr))).build(), creatorMethodStarterFn.apply(Arrays.asList(clientContextVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsBuilderMethodExpr, clientContextVarExpr))).build(), creatorMethodStarterFn.apply(Arrays.asList(clientContextVarExpr, callableFactoryVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsBuilderMethodExpr, clientContextVarExpr, callableFactoryVarExpr))).build());
    }

    protected List<MethodDefinition> createConstructorMethods(GapicContext context, Service service, TypeStore typeStore, Map<String, VariableExpr> classMemberVarExprs, Map<String, VariableExpr> callableClassMemberVarExprs, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, List<Statement> classStatements) {
        this.getTransportContext().classNames();
        TypeNode stubSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(stubSettingsType).build());
        TypeNode clientContextType = FIXED_TYPESTORE.get("ClientContext");
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setName("clientContext").setType(clientContextType).build());
        VariableExpr callableFactoryVarExpr = VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build());
        TypeNode thisClassType = typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service));
        TypeNode ioExceptionType = TypeNode.withReference(ConcreteReference.withClazz(IOException.class));
        BiFunction<List, List, MethodDefinition> ctorMakerFn = (args2, body) -> MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).setHeaderCommentStatements(Arrays.asList(this.createProtectedCtorComment(service))).setArguments(args2.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(ioExceptionType)).setBody((List<Statement>)body).build();
        MethodDefinition firstCtor = ctorMakerFn.apply(Arrays.asList(settingsVarExpr, clientContextVarExpr), Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.thisBuilder().setType(thisClassType).setArguments(settingsVarExpr, clientContextVarExpr, NewObjectExpr.builder().setType(typeStore.get(this.getTransportContext().classNames().getTransportServiceCallableFactoryClassName(service))).build()).build())));
        ValueExpr thisExpr = ValueExpr.withValue(ThisObjectValue.withType(typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service))));
        ArrayList<Statement> secondCtorStatements = new ArrayList<Statement>();
        ArrayList<Expr> secondCtorExprs = new ArrayList<Expr>();
        secondCtorExprs.add(AssignmentExpr.builder().setVariableExpr(classMemberVarExprs.get(CALLABLE_FACTORY_MEMBER_NAME).toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(callableFactoryVarExpr).build());
        VariableExpr operationsStubClassVarExpr = classMemberVarExprs.get(this.getTransportContext().transportOperationsStubNames().get(0));
        if (this.generateOperationsStubLogic(service)) {
            secondCtorExprs.addAll(this.createOperationsStubInitExpr(service, thisExpr, operationsStubClassVarExpr, clientContextVarExpr, callableFactoryVarExpr));
        }
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        Map<String, VariableExpr> javaStyleMethodNameToTransportSettingsVarExprs = service.methods().stream().filter(this::isSupportedMethod).collect(Collectors.toMap(m3 -> JavaStyle.toLowerCamelCase(m3.name()), m3 -> VariableExpr.withVariable(Variable.builder().setName(String.format("%sTransportSettings", JavaStyle.toLowerCamelCase(m3.name()))).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(this.getTransportContext().callSettingsClass()).setGenerics(Arrays.asList(m3.inputType().reference(), m3.outputType().reference())).build())).build())));
        secondCtorExprs.addAll(service.methods().stream().filter(this::isSupportedMethod).map(m3 -> this.createTransportSettingsInitExpr((Method)m3, (VariableExpr)javaStyleMethodNameToTransportSettingsVarExprs.get(JavaStyle.toLowerCamelCase(m3.name())), (VariableExpr)protoMethodNameToDescriptorVarExprs.get(m3.name()), classStatements)).collect(Collectors.toList()));
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        secondCtorExprs.addAll(callableClassMemberVarExprs.entrySet().stream().map(e -> this.createCallableInitExpr(context, service, (String)e.getKey(), (VariableExpr)e.getValue(), callableFactoryVarExpr, settingsVarExpr, clientContextVarExpr, operationsStubClassVarExpr, thisExpr, javaStyleMethodNameToTransportSettingsVarExprs)).collect(Collectors.toList()));
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        secondCtorStatements.addAll(this.createLongRunningClient(service, typeStore));
        MethodInvocationExpr getBackgroundResourcesMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientContextVarExpr).setMethodName("getBackgroundResources").build();
        VariableExpr backgroundResourcesVarExpr = classMemberVarExprs.get(BACKGROUND_RESOURCES_MEMBER_NAME);
        secondCtorExprs.add(AssignmentExpr.builder().setVariableExpr(backgroundResourcesVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(NewObjectExpr.builder().setType(FIXED_TYPESTORE.get("BackgroundResourceAggregation")).setArguments(Arrays.asList(getBackgroundResourcesMethodExpr)).build()).build());
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        MethodDefinition secondCtor = ctorMakerFn.apply(Arrays.asList(settingsVarExpr, clientContextVarExpr, callableFactoryVarExpr), secondCtorStatements);
        return Arrays.asList(firstCtor, secondCtor);
    }

    protected List<Expr> createOperationsStubInitExpr(Service service, Expr thisExpr, VariableExpr operationsStubClassVarExpr, VariableExpr clientContextVarExpr, VariableExpr callableFactoryVarExpr) {
        TypeNode operationsStubType = this.getTransportOperationsStubType(service);
        return Collections.singletonList(AssignmentExpr.builder().setVariableExpr(operationsStubClassVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(operationsStubType).setMethodName("create").setArguments(Arrays.asList(clientContextVarExpr, callableFactoryVarExpr)).setReturnType(operationsStubClassVarExpr.type()).build()).build());
    }

    protected List<Statement> createLongRunningClient(Service service, TypeStore typeStore) {
        return ImmutableList.of();
    }

    @Nullable
    protected VariableExpr declareLongRunningClient() {
        return null;
    }

    private Expr createCallableInitExpr(GapicContext context, Service service, String callableVarName, VariableExpr callableVarExpr, VariableExpr callableFactoryVarExpr, VariableExpr settingsVarExpr, VariableExpr clientContextVarExpr, VariableExpr operationsStubClassVarExpr, Expr thisExpr, Map<String, VariableExpr> javaStyleMethodNameToTransportSettingsVarExprs) {
        boolean isOperation = callableVarName.endsWith(OPERATION_CALLABLE_NAME);
        boolean isPaged = callableVarName.endsWith(PAGED_CALLABLE_NAME);
        int sublength = isOperation ? OPERATION_CALLABLE_NAME.length() : (isPaged ? PAGED_CALLABLE_NAME.length() : CALLABLE_NAME.length());
        String javaStyleMethodName = callableVarName.substring(0, callableVarName.length() - sublength);
        Expr transportSettingsVarExpr = javaStyleMethodNameToTransportSettingsVarExprs.get(javaStyleMethodName);
        if (transportSettingsVarExpr == null && isOperation) {
            isOperation = false;
            sublength = CALLABLE_NAME.length();
            javaStyleMethodName = callableVarName.substring(0, callableVarName.length() - sublength);
            transportSettingsVarExpr = javaStyleMethodNameToTransportSettingsVarExprs.get(javaStyleMethodName);
        }
        Preconditions.checkNotNull(transportSettingsVarExpr, String.format("No transport settings variable found for method name %s", javaStyleMethodName));
        List<Expr> creatorMethodArgVarExprs = isOperation ? Arrays.asList(transportSettingsVarExpr, MethodInvocationExpr.builder().setExprReferenceExpr(settingsVarExpr).setMethodName(String.format("%sOperationSettings", javaStyleMethodName)).build(), clientContextVarExpr, operationsStubClassVarExpr) : Arrays.asList(transportSettingsVarExpr, MethodInvocationExpr.builder().setExprReferenceExpr(settingsVarExpr).setMethodName(String.format("%sSettings", javaStyleMethodName)).build(), clientContextVarExpr);
        String methodName = JavaStyle.toUpperCamelCase(javaStyleMethodName);
        Optional<String> callableCreatorMethodName = this.getCallableCreatorMethodName(context, service, callableVarExpr.type(), methodName);
        Expr initExpr = callableCreatorMethodName.isPresent() ? MethodInvocationExpr.builder().setExprReferenceExpr(callableFactoryVarExpr).setMethodName(callableCreatorMethodName.get()).setArguments(creatorMethodArgVarExprs).setReturnType(callableVarExpr.type()).build() : ValueExpr.createNullExpr();
        return AssignmentExpr.builder().setVariableExpr(callableVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(initExpr).build();
    }

    protected Optional<String> getCallableCreatorMethodName(GapicContext context, Service service, TypeNode callableVarExprType, String serviceMethodName) {
        GapicServiceConfig serviceConfig = context.serviceConfig();
        if (serviceConfig != null && serviceConfig.hasBatchingSetting(service.protoPakkage(), service.name(), serviceMethodName)) {
            return Optional.of("createBatchingCallable");
        }
        if (callableVarExprType.reference().generics().size() == 2 && ((Reference)callableVarExprType.reference().generics().get(1)).name().endsWith("PagedResponse")) {
            return Optional.of("createPagedCallable");
        }
        String typeName = callableVarExprType.reference().name();
        if (typeName.startsWith("Client")) {
            return Optional.of("createClientStreamingCallable");
        }
        if (typeName.startsWith("Server")) {
            return Optional.of("createServerStreamingCallable");
        }
        if (typeName.startsWith("Bidi")) {
            return Optional.of("createBidiStreamingCallable");
        }
        if (typeName.startsWith("Operation")) {
            return Optional.of("createOperationCallable");
        }
        return Optional.of("createUnaryCallable");
    }

    private static List<MethodDefinition> createCallableGetterMethods(Map<String, VariableExpr> callableClassMemberVarExprs) {
        return callableClassMemberVarExprs.entrySet().stream().map(e -> MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(((VariableExpr)e.getValue()).type()).setName((String)e.getKey()).setReturnExpr((Expr)e.getValue()).build()).collect(Collectors.toList());
    }

    private List<MethodDefinition> createStubOverrideMethods(VariableExpr backgroundResourcesVarExpr, Service service) {
        Function<String, MethodDefinition.Builder> methodMakerStarterFn = methodName -> MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setName((String)methodName);
        Function<String, MethodDefinition> voidMethodMakerFn = methodName -> ((MethodDefinition.Builder)methodMakerStarterFn.apply((String)methodName)).setReturnType(TypeNode.VOID).setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName((String)methodName).build()))).build();
        Function<String, MethodDefinition> booleanMethodMakerFn = methodName -> ((MethodDefinition.Builder)methodMakerStarterFn.apply((String)methodName)).setReturnType(TypeNode.BOOLEAN).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName((String)methodName).setReturnType(TypeNode.BOOLEAN).build()).build();
        VariableExpr catchRuntimeExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(RuntimeException.class)).setName("e").build()).build();
        VariableExpr catchExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(Exception.class)).setName("e").build()).build();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        if (service.operationPollingMethod() != null) {
            javaMethods.addAll(this.createLongRunningClientGetters());
        }
        javaMethods.add(methodMakerStarterFn.apply("close").setIsFinal(true).setReturnType(TypeNode.VOID).setBody(Arrays.asList(TryCatchStatement.builder().setTryBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName("close").build()))).addCatch(catchRuntimeExceptionVarExpr.toBuilder().setIsDecl(true).build(), Arrays.asList(ExprStatement.withExpr(ThrowExpr.builder().setThrowExpr(catchRuntimeExceptionVarExpr).build()))).addCatch(catchExceptionVarExpr.toBuilder().setIsDecl(true).build(), Arrays.asList(ExprStatement.withExpr(ThrowExpr.builder().setType(TypeNode.withExceptionClazz(IllegalStateException.class)).setMessageExpr("Failed to close resource").setCauseExpr(catchExceptionVarExpr).build()))).build())).build());
        javaMethods.add(voidMethodMakerFn.apply("shutdown"));
        javaMethods.add(booleanMethodMakerFn.apply("isShutdown"));
        javaMethods.add(booleanMethodMakerFn.apply("isTerminated"));
        javaMethods.add(voidMethodMakerFn.apply("shutdownNow"));
        List<VariableExpr> awaitTerminationArgs = Arrays.asList(VariableExpr.withVariable(Variable.builder().setName("duration").setType(TypeNode.LONG).build()), VariableExpr.withVariable(Variable.builder().setName("unit").setType(FIXED_TYPESTORE.get("TimeUnit")).build()));
        javaMethods.add(methodMakerStarterFn.apply("awaitTermination").setReturnType(TypeNode.BOOLEAN).setArguments(awaitTerminationArgs.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(FIXED_TYPESTORE.get("InterruptedException"))).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName("awaitTermination").setArguments(awaitTerminationArgs.stream().map(v -> v).collect(Collectors.toList())).setReturnType(TypeNode.BOOLEAN).build()).build());
        return javaMethods;
    }

    private boolean checkOperationPollingMethod(Service service) {
        return service.methods().stream().filter(this::isSupportedMethod).anyMatch(Method::isOperationPollingMethod);
    }

    protected List<MethodDefinition> createLongRunningClientGetters() {
        VariableExpr longRunningClient = VariableExpr.withVariable(Variable.builder().setName("longRunningClient").setType(TypeNode.withReference(ConcreteReference.withClazz(LongRunningClient.class))).build());
        return ImmutableList.of(MethodDefinition.builder().setName("longRunningClient").setScope(ScopeNode.PUBLIC).setIsOverride(true).setReturnType(TypeNode.withReference(ConcreteReference.withClazz(LongRunningClient.class))).setReturnExpr(longRunningClient).build());
    }

    private TypeStore createDynamicTypes(Service service, String stubPakkage) {
        TypeStore typeStore = new TypeStore();
        String[] stringArray = new String[4];
        stringArray[0] = this.getTransportContext().classNames().getTransportServiceStubClassName(service);
        this.getTransportContext().classNames();
        stringArray[1] = ClassNames.getServiceStubSettingsClassName(service);
        this.getTransportContext().classNames();
        stringArray[2] = ClassNames.getServiceStubClassName(service);
        stringArray[3] = this.getTransportContext().classNames().getTransportServiceCallableFactoryClassName(service);
        typeStore.putAll(stubPakkage, Arrays.asList(stringArray));
        String string = service.pakkage();
        String[] stringArray2 = new String[1];
        this.getTransportContext().classNames();
        stringArray2[0] = ClassNames.getServiceClientClassName(service);
        typeStore.putAll(string, service.methods().stream().filter(this::isSupportedMethod).filter(Method::isPaged).map(m3 -> String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, m3.name())).collect(Collectors.toList()), true, stringArray2);
        return typeStore;
    }

    private static TypeNode getCallableType(Method protoMethod) {
        TypeNode callableType = FIXED_TYPESTORE.get("UnaryCallable");
        switch (protoMethod.stream()) {
            case CLIENT: {
                callableType = FIXED_TYPESTORE.get("ClientStreamingCallable");
                break;
            }
            case SERVER: {
                callableType = FIXED_TYPESTORE.get("ServerStreamingCallable");
                break;
            }
            case BIDI: {
                callableType = FIXED_TYPESTORE.get("BidiStreamingCallable");
                break;
            }
        }
        return TypeNode.withReference(callableType.reference().copyAndSetGenerics(Arrays.asList(protoMethod.inputType().reference(), protoMethod.outputType().reference())));
    }

    private CommentStatement createProtectedCtorComment(Service service) {
        return CommentStatement.withComment(JavaDocComment.withComment(String.format("Constructs an instance of %s, using the given settings. This is protected so that it is easy to make a subclass, but otherwise, the static factory methods should be  preferred.", this.getTransportContext().classNames().getTransportServiceStubClassName(service))));
    }

    protected String getProtoRpcFullMethodName(Service protoService, Method protoMethod) {
        if (protoMethod.isMixin()) {
            return String.format("%s/%s", protoMethod.mixedInApiName(), protoMethod.name());
        }
        return String.format("%s.%s/%s", protoService.protoPakkage(), protoService.name(), protoMethod.name());
    }

    protected TypeNode getTransportOperationsStubType(Service service) {
        TypeNode transportOpeationsStubType = service.operationServiceStubType();
        transportOpeationsStubType = transportOpeationsStubType == null ? this.getTransportContext().transportOperationsStubTypes().get(0) : TypeNode.withReference(VaporReference.builder().setName("HttpJson" + transportOpeationsStubType.reference().simpleName()).setPakkage(transportOpeationsStubType.reference().pakkage()).build());
        return transportOpeationsStubType;
    }
}

