/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.serviceconfig;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.Value;
import com.google.protobuf.ValueOrBuilder;
import io.grpc.serviceconfig.ServiceConfigProto;
import io.grpc.serviceconfig.XdsServerOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class XdsServer
extends GeneratedMessageV3
implements XdsServerOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int SERVER_URI_FIELD_NUMBER = 1;
    private volatile Object serverUri_ = "";
    public static final int CHANNEL_CREDS_FIELD_NUMBER = 2;
    private List<ChannelCredentials> channelCreds_;
    public static final int SERVER_FEATURES_FIELD_NUMBER = 3;
    private List<Value> serverFeatures_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final XdsServer DEFAULT_INSTANCE = new XdsServer();
    private static final Parser<XdsServer> PARSER = new AbstractParser<XdsServer>(){

        @Override
        public XdsServer parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = XdsServer.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private XdsServer(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private XdsServer() {
        this.serverUri_ = "";
        this.channelCreds_ = Collections.emptyList();
        this.serverFeatures_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new XdsServer();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_fieldAccessorTable.ensureFieldAccessorsInitialized(XdsServer.class, Builder.class);
    }

    @Override
    public String getServerUri() {
        Object ref = this.serverUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.serverUri_ = s2;
        return s2;
    }

    @Override
    public ByteString getServerUriBytes() {
        Object ref = this.serverUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.serverUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<ChannelCredentials> getChannelCredsList() {
        return this.channelCreds_;
    }

    @Override
    public List<? extends ChannelCredentialsOrBuilder> getChannelCredsOrBuilderList() {
        return this.channelCreds_;
    }

    @Override
    public int getChannelCredsCount() {
        return this.channelCreds_.size();
    }

    @Override
    public ChannelCredentials getChannelCreds(int index) {
        return this.channelCreds_.get(index);
    }

    @Override
    public ChannelCredentialsOrBuilder getChannelCredsOrBuilder(int index) {
        return this.channelCreds_.get(index);
    }

    @Override
    public List<Value> getServerFeaturesList() {
        return this.serverFeatures_;
    }

    @Override
    public List<? extends ValueOrBuilder> getServerFeaturesOrBuilderList() {
        return this.serverFeatures_;
    }

    @Override
    public int getServerFeaturesCount() {
        return this.serverFeatures_.size();
    }

    @Override
    public Value getServerFeatures(int index) {
        return this.serverFeatures_.get(index);
    }

    @Override
    public ValueOrBuilder getServerFeaturesOrBuilder(int index) {
        return this.serverFeatures_.get(index);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty(this.serverUri_)) {
            GeneratedMessageV3.writeString(output, 1, this.serverUri_);
        }
        for (i = 0; i < this.channelCreds_.size(); ++i) {
            output.writeMessage(2, this.channelCreds_.get(i));
        }
        for (i = 0; i < this.serverFeatures_.size(); ++i) {
            output.writeMessage(3, this.serverFeatures_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty(this.serverUri_)) {
            size += GeneratedMessageV3.computeStringSize(1, this.serverUri_);
        }
        for (i = 0; i < this.channelCreds_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(2, this.channelCreds_.get(i));
        }
        for (i = 0; i < this.serverFeatures_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(3, this.serverFeatures_.get(i));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XdsServer)) {
            return super.equals(obj);
        }
        XdsServer other = (XdsServer)obj;
        if (!this.getServerUri().equals(other.getServerUri())) {
            return false;
        }
        if (!this.getChannelCredsList().equals(other.getChannelCredsList())) {
            return false;
        }
        if (!this.getServerFeaturesList().equals(other.getServerFeaturesList())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + XdsServer.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getServerUri().hashCode();
        if (this.getChannelCredsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getChannelCredsList().hashCode();
        }
        if (this.getServerFeaturesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getServerFeaturesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static XdsServer parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static XdsServer parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static XdsServer parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static XdsServer parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static XdsServer parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static XdsServer parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static XdsServer parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static XdsServer parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static XdsServer parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static XdsServer parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static XdsServer parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static XdsServer parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return XdsServer.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(XdsServer prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static XdsServer getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<XdsServer> parser() {
        return PARSER;
    }

    public Parser<XdsServer> getParserForType() {
        return PARSER;
    }

    @Override
    public XdsServer getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements XdsServerOrBuilder {
        private int bitField0_;
        private Object serverUri_ = "";
        private List<ChannelCredentials> channelCreds_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ChannelCredentials, ChannelCredentials.Builder, ChannelCredentialsOrBuilder> channelCredsBuilder_;
        private List<Value> serverFeatures_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Value, Value.Builder, ValueOrBuilder> serverFeaturesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_fieldAccessorTable.ensureFieldAccessorsInitialized(XdsServer.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.serverUri_ = "";
            if (this.channelCredsBuilder_ == null) {
                this.channelCreds_ = Collections.emptyList();
            } else {
                this.channelCreds_ = null;
                this.channelCredsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.serverFeaturesBuilder_ == null) {
                this.serverFeatures_ = Collections.emptyList();
            } else {
                this.serverFeatures_ = null;
                this.serverFeaturesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_descriptor;
        }

        @Override
        public XdsServer getDefaultInstanceForType() {
            return XdsServer.getDefaultInstance();
        }

        @Override
        public XdsServer build() {
            XdsServer result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public XdsServer buildPartial() {
            XdsServer result = new XdsServer(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(XdsServer result) {
            if (this.channelCredsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.channelCreds_ = Collections.unmodifiableList(this.channelCreds_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.channelCreds_ = this.channelCreds_;
            } else {
                result.channelCreds_ = this.channelCredsBuilder_.build();
            }
            if (this.serverFeaturesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.serverFeatures_ = Collections.unmodifiableList(this.serverFeatures_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.serverFeatures_ = this.serverFeatures_;
            } else {
                result.serverFeatures_ = this.serverFeaturesBuilder_.build();
            }
        }

        private void buildPartial0(XdsServer result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.serverUri_ = this.serverUri_;
            }
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof XdsServer) {
                return this.mergeFrom((XdsServer)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(XdsServer other) {
            if (other == XdsServer.getDefaultInstance()) {
                return this;
            }
            if (!other.getServerUri().isEmpty()) {
                this.serverUri_ = other.serverUri_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (this.channelCredsBuilder_ == null) {
                if (!other.channelCreds_.isEmpty()) {
                    if (this.channelCreds_.isEmpty()) {
                        this.channelCreds_ = other.channelCreds_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureChannelCredsIsMutable();
                        this.channelCreds_.addAll(other.channelCreds_);
                    }
                    this.onChanged();
                }
            } else if (!other.channelCreds_.isEmpty()) {
                if (this.channelCredsBuilder_.isEmpty()) {
                    this.channelCredsBuilder_.dispose();
                    this.channelCredsBuilder_ = null;
                    this.channelCreds_ = other.channelCreds_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.channelCredsBuilder_ = alwaysUseFieldBuilders ? this.getChannelCredsFieldBuilder() : null;
                } else {
                    this.channelCredsBuilder_.addAllMessages(other.channelCreds_);
                }
            }
            if (this.serverFeaturesBuilder_ == null) {
                if (!other.serverFeatures_.isEmpty()) {
                    if (this.serverFeatures_.isEmpty()) {
                        this.serverFeatures_ = other.serverFeatures_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureServerFeaturesIsMutable();
                        this.serverFeatures_.addAll(other.serverFeatures_);
                    }
                    this.onChanged();
                }
            } else if (!other.serverFeatures_.isEmpty()) {
                if (this.serverFeaturesBuilder_.isEmpty()) {
                    this.serverFeaturesBuilder_.dispose();
                    this.serverFeaturesBuilder_ = null;
                    this.serverFeatures_ = other.serverFeatures_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.serverFeaturesBuilder_ = alwaysUseFieldBuilders ? this.getServerFeaturesFieldBuilder() : null;
                } else {
                    this.serverFeaturesBuilder_.addAllMessages(other.serverFeatures_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            this.serverUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            GeneratedMessageV3 m3 = input.readMessage(ChannelCredentials.parser(), extensionRegistry);
                            if (this.channelCredsBuilder_ == null) {
                                this.ensureChannelCredsIsMutable();
                                this.channelCreds_.add((ChannelCredentials)m3);
                                continue block11;
                            }
                            this.channelCredsBuilder_.addMessage((ChannelCredentials)m3);
                            continue block11;
                        }
                        case 26: {
                            GeneratedMessageV3 m3 = input.readMessage(Value.parser(), extensionRegistry);
                            if (this.serverFeaturesBuilder_ == null) {
                                this.ensureServerFeaturesIsMutable();
                                this.serverFeatures_.add((Value)m3);
                                continue block11;
                            }
                            this.serverFeaturesBuilder_.addMessage((Value)m3);
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getServerUri() {
            Object ref = this.serverUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.serverUri_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServerUriBytes() {
            Object ref = this.serverUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.serverUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServerUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serverUri_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearServerUri() {
            this.serverUri_ = XdsServer.getDefaultInstance().getServerUri();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setServerUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            XdsServer.checkByteStringIsUtf8(value);
            this.serverUri_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureChannelCredsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.channelCreds_ = new ArrayList<ChannelCredentials>(this.channelCreds_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<ChannelCredentials> getChannelCredsList() {
            if (this.channelCredsBuilder_ == null) {
                return Collections.unmodifiableList(this.channelCreds_);
            }
            return this.channelCredsBuilder_.getMessageList();
        }

        @Override
        public int getChannelCredsCount() {
            if (this.channelCredsBuilder_ == null) {
                return this.channelCreds_.size();
            }
            return this.channelCredsBuilder_.getCount();
        }

        @Override
        public ChannelCredentials getChannelCreds(int index) {
            if (this.channelCredsBuilder_ == null) {
                return this.channelCreds_.get(index);
            }
            return this.channelCredsBuilder_.getMessage(index);
        }

        public Builder setChannelCreds(int index, ChannelCredentials value) {
            if (this.channelCredsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.set(index, value);
                this.onChanged();
            } else {
                this.channelCredsBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setChannelCreds(int index, ChannelCredentials.Builder builderForValue) {
            if (this.channelCredsBuilder_ == null) {
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.channelCredsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addChannelCreds(ChannelCredentials value) {
            if (this.channelCredsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.add(value);
                this.onChanged();
            } else {
                this.channelCredsBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addChannelCreds(int index, ChannelCredentials value) {
            if (this.channelCredsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.add(index, value);
                this.onChanged();
            } else {
                this.channelCredsBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addChannelCreds(ChannelCredentials.Builder builderForValue) {
            if (this.channelCredsBuilder_ == null) {
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.channelCredsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addChannelCreds(int index, ChannelCredentials.Builder builderForValue) {
            if (this.channelCredsBuilder_ == null) {
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.channelCredsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllChannelCreds(Iterable<? extends ChannelCredentials> values) {
            if (this.channelCredsBuilder_ == null) {
                this.ensureChannelCredsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.channelCreds_);
                this.onChanged();
            } else {
                this.channelCredsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearChannelCreds() {
            if (this.channelCredsBuilder_ == null) {
                this.channelCreds_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.channelCredsBuilder_.clear();
            }
            return this;
        }

        public Builder removeChannelCreds(int index) {
            if (this.channelCredsBuilder_ == null) {
                this.ensureChannelCredsIsMutable();
                this.channelCreds_.remove(index);
                this.onChanged();
            } else {
                this.channelCredsBuilder_.remove(index);
            }
            return this;
        }

        public ChannelCredentials.Builder getChannelCredsBuilder(int index) {
            return this.getChannelCredsFieldBuilder().getBuilder(index);
        }

        @Override
        public ChannelCredentialsOrBuilder getChannelCredsOrBuilder(int index) {
            if (this.channelCredsBuilder_ == null) {
                return this.channelCreds_.get(index);
            }
            return this.channelCredsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ChannelCredentialsOrBuilder> getChannelCredsOrBuilderList() {
            if (this.channelCredsBuilder_ != null) {
                return this.channelCredsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.channelCreds_);
        }

        public ChannelCredentials.Builder addChannelCredsBuilder() {
            return this.getChannelCredsFieldBuilder().addBuilder(ChannelCredentials.getDefaultInstance());
        }

        public ChannelCredentials.Builder addChannelCredsBuilder(int index) {
            return this.getChannelCredsFieldBuilder().addBuilder(index, ChannelCredentials.getDefaultInstance());
        }

        public List<ChannelCredentials.Builder> getChannelCredsBuilderList() {
            return this.getChannelCredsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ChannelCredentials, ChannelCredentials.Builder, ChannelCredentialsOrBuilder> getChannelCredsFieldBuilder() {
            if (this.channelCredsBuilder_ == null) {
                this.channelCredsBuilder_ = new RepeatedFieldBuilderV3(this.channelCreds_, (this.bitField0_ & 2) != 0, this.getParentForChildren(), this.isClean());
                this.channelCreds_ = null;
            }
            return this.channelCredsBuilder_;
        }

        private void ensureServerFeaturesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.serverFeatures_ = new ArrayList<Value>(this.serverFeatures_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Value> getServerFeaturesList() {
            if (this.serverFeaturesBuilder_ == null) {
                return Collections.unmodifiableList(this.serverFeatures_);
            }
            return this.serverFeaturesBuilder_.getMessageList();
        }

        @Override
        public int getServerFeaturesCount() {
            if (this.serverFeaturesBuilder_ == null) {
                return this.serverFeatures_.size();
            }
            return this.serverFeaturesBuilder_.getCount();
        }

        @Override
        public Value getServerFeatures(int index) {
            if (this.serverFeaturesBuilder_ == null) {
                return this.serverFeatures_.get(index);
            }
            return this.serverFeaturesBuilder_.getMessage(index);
        }

        public Builder setServerFeatures(int index, Value value) {
            if (this.serverFeaturesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.set(index, value);
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setServerFeatures(int index, Value.Builder builderForValue) {
            if (this.serverFeaturesBuilder_ == null) {
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addServerFeatures(Value value) {
            if (this.serverFeaturesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.add(value);
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addServerFeatures(int index, Value value) {
            if (this.serverFeaturesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.add(index, value);
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addServerFeatures(Value.Builder builderForValue) {
            if (this.serverFeaturesBuilder_ == null) {
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addServerFeatures(int index, Value.Builder builderForValue) {
            if (this.serverFeaturesBuilder_ == null) {
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllServerFeatures(Iterable<? extends Value> values) {
            if (this.serverFeaturesBuilder_ == null) {
                this.ensureServerFeaturesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.serverFeatures_);
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearServerFeatures() {
            if (this.serverFeaturesBuilder_ == null) {
                this.serverFeatures_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.clear();
            }
            return this;
        }

        public Builder removeServerFeatures(int index) {
            if (this.serverFeaturesBuilder_ == null) {
                this.ensureServerFeaturesIsMutable();
                this.serverFeatures_.remove(index);
                this.onChanged();
            } else {
                this.serverFeaturesBuilder_.remove(index);
            }
            return this;
        }

        public Value.Builder getServerFeaturesBuilder(int index) {
            return this.getServerFeaturesFieldBuilder().getBuilder(index);
        }

        @Override
        public ValueOrBuilder getServerFeaturesOrBuilder(int index) {
            if (this.serverFeaturesBuilder_ == null) {
                return this.serverFeatures_.get(index);
            }
            return this.serverFeaturesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ValueOrBuilder> getServerFeaturesOrBuilderList() {
            if (this.serverFeaturesBuilder_ != null) {
                return this.serverFeaturesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.serverFeatures_);
        }

        public Value.Builder addServerFeaturesBuilder() {
            return this.getServerFeaturesFieldBuilder().addBuilder(Value.getDefaultInstance());
        }

        public Value.Builder addServerFeaturesBuilder(int index) {
            return this.getServerFeaturesFieldBuilder().addBuilder(index, Value.getDefaultInstance());
        }

        public List<Value.Builder> getServerFeaturesBuilderList() {
            return this.getServerFeaturesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Value, Value.Builder, ValueOrBuilder> getServerFeaturesFieldBuilder() {
            if (this.serverFeaturesBuilder_ == null) {
                this.serverFeaturesBuilder_ = new RepeatedFieldBuilderV3(this.serverFeatures_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                this.serverFeatures_ = null;
            }
            return this.serverFeaturesBuilder_;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class ChannelCredentials
    extends GeneratedMessageV3
    implements ChannelCredentialsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TYPE_FIELD_NUMBER = 1;
        private volatile Object type_ = "";
        public static final int CONFIG_FIELD_NUMBER = 2;
        private Struct config_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ChannelCredentials DEFAULT_INSTANCE = new ChannelCredentials();
        private static final Parser<ChannelCredentials> PARSER = new AbstractParser<ChannelCredentials>(){

            @Override
            public ChannelCredentials parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ChannelCredentials.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ChannelCredentials(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ChannelCredentials() {
            this.type_ = "";
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ChannelCredentials();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_ChannelCredentials_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_ChannelCredentials_fieldAccessorTable.ensureFieldAccessorsInitialized(ChannelCredentials.class, Builder.class);
        }

        @Override
        public String getType() {
            Object ref = this.type_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s2 = bs.toStringUtf8();
            this.type_ = s2;
            return s2;
        }

        @Override
        public ByteString getTypeBytes() {
            Object ref = this.type_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.type_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasConfig() {
            return this.config_ != null;
        }

        @Override
        public Struct getConfig() {
            return this.config_ == null ? Struct.getDefaultInstance() : this.config_;
        }

        @Override
        public StructOrBuilder getConfigOrBuilder() {
            return this.config_ == null ? Struct.getDefaultInstance() : this.config_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty(this.type_)) {
                GeneratedMessageV3.writeString(output, 1, this.type_);
            }
            if (this.config_ != null) {
                output.writeMessage(2, this.getConfig());
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty(this.type_)) {
                size += GeneratedMessageV3.computeStringSize(1, this.type_);
            }
            if (this.config_ != null) {
                size += CodedOutputStream.computeMessageSize(2, this.getConfig());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ChannelCredentials)) {
                return super.equals(obj);
            }
            ChannelCredentials other = (ChannelCredentials)obj;
            if (!this.getType().equals(other.getType())) {
                return false;
            }
            if (this.hasConfig() != other.hasConfig()) {
                return false;
            }
            if (this.hasConfig() && !this.getConfig().equals(other.getConfig())) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ChannelCredentials.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getType().hashCode();
            if (this.hasConfig()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getConfig().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ChannelCredentials parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ChannelCredentials parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ChannelCredentials parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ChannelCredentials parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ChannelCredentials parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ChannelCredentials parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ChannelCredentials parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ChannelCredentials parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ChannelCredentials parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static ChannelCredentials parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ChannelCredentials parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ChannelCredentials parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ChannelCredentials.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ChannelCredentials prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ChannelCredentials getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ChannelCredentials> parser() {
            return PARSER;
        }

        public Parser<ChannelCredentials> getParserForType() {
            return PARSER;
        }

        @Override
        public ChannelCredentials getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ChannelCredentialsOrBuilder {
            private int bitField0_;
            private Object type_ = "";
            private Struct config_;
            private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> configBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_ChannelCredentials_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_ChannelCredentials_fieldAccessorTable.ensureFieldAccessorsInitialized(ChannelCredentials.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.type_ = "";
                this.config_ = null;
                if (this.configBuilder_ != null) {
                    this.configBuilder_.dispose();
                    this.configBuilder_ = null;
                }
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return ServiceConfigProto.internal_static_grpc_service_config_XdsServer_ChannelCredentials_descriptor;
            }

            @Override
            public ChannelCredentials getDefaultInstanceForType() {
                return ChannelCredentials.getDefaultInstance();
            }

            @Override
            public ChannelCredentials build() {
                ChannelCredentials result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ChannelCredentials buildPartial() {
                ChannelCredentials result = new ChannelCredentials(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ChannelCredentials result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.type_ = this.type_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.config_ = this.configBuilder_ == null ? this.config_ : this.configBuilder_.build();
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ChannelCredentials) {
                    return this.mergeFrom((ChannelCredentials)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ChannelCredentials other) {
                if (other == ChannelCredentials.getDefaultInstance()) {
                    return this;
                }
                if (!other.getType().isEmpty()) {
                    this.type_ = other.type_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.hasConfig()) {
                    this.mergeConfig(other.getConfig());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                this.type_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                input.readMessage(this.getConfigFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getType() {
                Object ref = this.type_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s2 = bs.toStringUtf8();
                    this.type_ = s2;
                    return s2;
                }
                return (String)ref;
            }

            @Override
            public ByteString getTypeBytes() {
                Object ref = this.type_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.type_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setType(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.type_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearType() {
                this.type_ = ChannelCredentials.getDefaultInstance().getType();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setTypeBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ChannelCredentials.checkByteStringIsUtf8(value);
                this.type_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasConfig() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Struct getConfig() {
                if (this.configBuilder_ == null) {
                    return this.config_ == null ? Struct.getDefaultInstance() : this.config_;
                }
                return this.configBuilder_.getMessage();
            }

            public Builder setConfig(Struct value) {
                if (this.configBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.config_ = value;
                } else {
                    this.configBuilder_.setMessage(value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setConfig(Struct.Builder builderForValue) {
                if (this.configBuilder_ == null) {
                    this.config_ = builderForValue.build();
                } else {
                    this.configBuilder_.setMessage(builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeConfig(Struct value) {
                if (this.configBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.config_ != null && this.config_ != Struct.getDefaultInstance()) {
                        this.getConfigBuilder().mergeFrom(value);
                    } else {
                        this.config_ = value;
                    }
                } else {
                    this.configBuilder_.mergeFrom(value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearConfig() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.config_ = null;
                if (this.configBuilder_ != null) {
                    this.configBuilder_.dispose();
                    this.configBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Struct.Builder getConfigBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return this.getConfigFieldBuilder().getBuilder();
            }

            @Override
            public StructOrBuilder getConfigOrBuilder() {
                if (this.configBuilder_ != null) {
                    return this.configBuilder_.getMessageOrBuilder();
                }
                return this.config_ == null ? Struct.getDefaultInstance() : this.config_;
            }

            private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getConfigFieldBuilder() {
                if (this.configBuilder_ == null) {
                    this.configBuilder_ = new SingleFieldBuilderV3(this.getConfig(), this.getParentForChildren(), this.isClean());
                    this.config_ = null;
                }
                return this.configBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ChannelCredentialsOrBuilder
    extends MessageOrBuilder {
        public String getType();

        public ByteString getTypeBytes();

        public boolean hasConfig();

        public Struct getConfig();

        public StructOrBuilder getConfigOrBuilder();
    }
}

