/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.gapic.model.AutoValue_GapicClass;
import com.google.api.generator.gapic.model.Sample;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class GapicClass {
    public abstract Kind kind();

    public abstract ClassDefinition classDefinition();

    public abstract List<Sample> samples();

    public abstract String apiShortName();

    public abstract String apiVersion();

    public static GapicClass create(Kind kind, ClassDefinition classDefinition) {
        return GapicClass.builder().setKind(kind).setClassDefinition(classDefinition).build();
    }

    public static GapicClass create(Kind kind, ClassDefinition classDefinition, List<Sample> samples) {
        return GapicClass.builder().setKind(kind).setClassDefinition(classDefinition).setSamples(samples).build();
    }

    static Builder builder() {
        return new AutoValue_GapicClass.Builder().setSamples(Collections.emptyList()).setApiShortName("").setApiVersion("");
    }

    abstract Builder toBuilder();

    public final GapicClass withSamples(List<Sample> samples) {
        return this.toBuilder().setSamples(samples).build();
    }

    public final GapicClass withApiShortName(String apiShortName) {
        return this.toBuilder().setApiShortName(apiShortName).build();
    }

    public final GapicClass withApiVersion(String apiVersion) {
        return this.toBuilder().setApiVersion(apiVersion).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setKind(Kind var1);

        abstract Builder setClassDefinition(ClassDefinition var1);

        abstract Builder setSamples(List<Sample> var1);

        abstract Builder setApiShortName(String var1);

        abstract Builder setApiVersion(String var1);

        abstract GapicClass build();
    }

    public static enum Kind {
        MAIN,
        STUB,
        TEST,
        PROTO;

    }
}

