/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.NullValue;
import com.google.api.client.util.Value;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo {
    private static final Map<Field, FieldInfo> CACHE = new WeakHashMap<Field, FieldInfo>();
    @Deprecated
    public final boolean isFinal;
    @Deprecated
    public final boolean isPrimitive;
    @Deprecated
    public final Class<?> type;
    @Deprecated
    public final Field field;
    @Deprecated
    public final String name;

    public static FieldInfo of(Enum<?> enumValue) {
        try {
            FieldInfo result = FieldInfo.of(enumValue.getClass().getField(enumValue.name()));
            Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"enum constant missing @Value or @NullValue annotation: %s", (Object[])new Object[]{enumValue});
            return result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldInfo of(Field field) {
        if (field == null) {
            return null;
        }
        Map<Field, FieldInfo> map = CACHE;
        synchronized (map) {
            FieldInfo fieldInfo = CACHE.get(field);
            boolean isEnumContant = field.isEnumConstant();
            if (fieldInfo == null && (isEnumContant || !Modifier.isStatic(field.getModifiers()))) {
                String fieldName;
                if (isEnumContant) {
                    Value value = field.getAnnotation(Value.class);
                    if (value != null) {
                        fieldName = value.value();
                    } else {
                        NullValue nullValue = field.getAnnotation(NullValue.class);
                        if (nullValue == null) {
                            return null;
                        }
                        fieldName = null;
                    }
                } else {
                    Key key = field.getAnnotation(Key.class);
                    if (key == null) {
                        return null;
                    }
                    fieldName = key.value();
                    field.setAccessible(true);
                }
                if ("##default".equals(fieldName)) {
                    fieldName = field.getName();
                }
                fieldInfo = new FieldInfo(field, fieldName);
                CACHE.put(field, fieldInfo);
            }
            return fieldInfo;
        }
    }

    FieldInfo(Field field, String name) {
        this.field = field;
        this.name = name == null ? null : name.intern();
        this.isFinal = Modifier.isFinal(field.getModifiers());
        this.type = field.getType();
        this.isPrimitive = Data.isPrimitive(this.getType());
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public Object getValue(Object obj) {
        return FieldInfo.getFieldValue(this.field, obj);
    }

    public void setValue(Object obj, Object value) {
        FieldInfo.setFieldValue(this.field, obj, value);
    }

    public ClassInfo getClassInfo() {
        return ClassInfo.of(this.field.getDeclaringClass());
    }

    public <T extends Enum<T>> T enumValue() {
        return (T)Enum.valueOf(this.field.getDeclaringClass(), this.field.getName());
    }

    @Deprecated
    public static boolean isPrimitive(Class<?> fieldClass) {
        return fieldClass.isPrimitive() || fieldClass == Character.class || fieldClass == String.class || fieldClass == Integer.class || fieldClass == Long.class || fieldClass == Short.class || fieldClass == Byte.class || fieldClass == Float.class || fieldClass == Double.class || fieldClass == BigInteger.class || fieldClass == BigDecimal.class || fieldClass == DateTime.class || fieldClass == Boolean.class;
    }

    @Deprecated
    public static boolean isPrimitive(Object fieldValue) {
        return fieldValue == null || FieldInfo.isPrimitive(fieldValue.getClass());
    }

    public static Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        if (Modifier.isFinal(field.getModifiers())) {
            Object finalValue = FieldInfo.getFieldValue(field, obj);
            if (value == null ? finalValue != null : !value.equals(finalValue)) {
                throw new IllegalArgumentException("expected final value <" + finalValue + "> but was <" + value + "> on " + field.getName() + " field in " + obj.getClass().getName());
            }
        } else {
            try {
                field.set(obj, value);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Deprecated
    public static Object parsePrimitiveValue(Class<?> primitiveClass, String stringValue) {
        if (stringValue == null || primitiveClass == null || primitiveClass == String.class) {
            return stringValue;
        }
        if (primitiveClass == Character.class || primitiveClass == Character.TYPE) {
            if (stringValue.length() != 1) {
                throw new IllegalArgumentException("expected type Character/char but got " + primitiveClass);
            }
            return Character.valueOf(stringValue.charAt(0));
        }
        if (primitiveClass == Boolean.class || primitiveClass == Boolean.TYPE) {
            return Boolean.valueOf(stringValue);
        }
        if (primitiveClass == Byte.class || primitiveClass == Byte.TYPE) {
            return Byte.valueOf(stringValue);
        }
        if (primitiveClass == Short.class || primitiveClass == Short.TYPE) {
            return Short.valueOf(stringValue);
        }
        if (primitiveClass == Integer.class || primitiveClass == Integer.TYPE) {
            return Integer.valueOf(stringValue);
        }
        if (primitiveClass == Long.class || primitiveClass == Long.TYPE) {
            return Long.valueOf(stringValue);
        }
        if (primitiveClass == Float.class || primitiveClass == Float.TYPE) {
            return Float.valueOf(stringValue);
        }
        if (primitiveClass == Double.class || primitiveClass == Double.TYPE) {
            return Double.valueOf(stringValue);
        }
        if (primitiveClass == DateTime.class) {
            return DateTime.parseRfc3339(stringValue);
        }
        if (primitiveClass == BigInteger.class) {
            return new BigInteger(stringValue);
        }
        if (primitiveClass == BigDecimal.class) {
            return new BigDecimal(stringValue);
        }
        throw new IllegalArgumentException("expected primitive class, but got: " + primitiveClass);
    }
}

