/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.DataUtil;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    public static final String CONTENT_TYPE = "application/json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object item) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            JsonGenerator generator = JSON_FACTORY.createJsonGenerator((OutputStream)byteStream, JsonEncoding.UTF8);
            try {
                Json.serialize(generator, item);
            }
            finally {
                generator.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(new PrintStream(byteStream));
        }
        return byteStream.toString();
    }

    public static void serialize(JsonGenerator generator, Object value) throws IOException {
        if (value == null) {
            generator.writeNull();
        }
        if (value instanceof String || value instanceof Long || value instanceof Double || value instanceof BigInteger || value instanceof BigDecimal) {
            generator.writeString(value.toString());
        } else if (value instanceof Boolean) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            generator.writeNumber(((Number)value).intValue());
        } else if (value instanceof Float) {
            generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof DateTime) {
            generator.writeString(((DateTime)value).toStringRfc3339());
        } else if (value instanceof List) {
            generator.writeStartArray();
            List listValue = (List)value;
            int size = listValue.size();
            for (int i = 0; i < size; ++i) {
                Json.serialize(generator, listValue.get(i));
            }
            generator.writeEndArray();
        } else {
            generator.writeStartObject();
            for (Map.Entry entry : DataUtil.mapOf((Object)value).entrySet()) {
                Object fieldValue = entry.getValue();
                if (fieldValue == null) continue;
                String fieldName = (String)entry.getKey();
                generator.writeFieldName(fieldName);
                Json.serialize(generator, fieldValue);
            }
            generator.writeEndObject();
        }
    }

    public static <T> T parseAndClose(JsonParser parser, Class<T> destinationClass, CustomizeJsonParser customizeParser) throws IOException {
        Object newInstance = ClassInfo.newInstance(destinationClass);
        Json.parseAndClose(parser, newInstance, customizeParser);
        return (T)newInstance;
    }

    public static void skipToKey(JsonParser parser, String keyToFind) throws IOException {
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String key = parser.getCurrentName();
            parser.nextToken();
            if (keyToFind.equals(key)) break;
            parser.skipChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAndClose(JsonParser parser, Object destination, CustomizeJsonParser customizeParser) throws IOException {
        try {
            Json.parse(parser, destination, customizeParser);
        }
        finally {
            parser.close();
        }
    }

    public static <T> T parse(JsonParser parser, Class<T> destinationClass, CustomizeJsonParser customizeParser) throws IOException {
        Object newInstance = ClassInfo.newInstance(destinationClass);
        Json.parse(parser, newInstance, customizeParser);
        return (T)newInstance;
    }

    public static void parse(JsonParser parser, Object destination, CustomizeJsonParser customizeParser) throws IOException {
        Class<?> destinationClass = destination.getClass();
        ClassInfo classInfo = ClassInfo.of(destinationClass);
        boolean isGenericData = GenericData.class.isAssignableFrom(destinationClass);
        if (!isGenericData && Map.class.isAssignableFrom(destinationClass)) {
            Map destinationMap = (Map)destination;
            Class valueClass = ClassInfo.getMapValueParameter((Type)destinationClass.getGenericSuperclass());
            Json.parseMap(parser, destinationMap, valueClass, customizeParser);
            return;
        }
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String key = parser.getCurrentName();
            JsonToken curToken = parser.nextToken();
            if (customizeParser != null && customizeParser.stopAt(destination, key)) {
                return;
            }
            FieldInfo fieldInfo = classInfo.getFieldInfo(key);
            if (fieldInfo != null) {
                if (fieldInfo.isFinal && !fieldInfo.isPrimitive) {
                    throw new IllegalArgumentException("final array/object fields are not supported");
                }
                Field field = fieldInfo.field;
                Object fieldValue = Json.parseValue(parser, curToken, field, fieldInfo.type, destination, customizeParser);
                FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)fieldValue);
                continue;
            }
            if (isGenericData) {
                GenericData object = (GenericData)destination;
                object.set(key, Json.parseValue(parser, curToken, null, null, destination, customizeParser));
                continue;
            }
            if (customizeParser != null) {
                customizeParser.handleUnrecognizedKey(destination, key);
            }
            parser.skipChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Collection<T> parseArrayAndClose(JsonParser parser, Class<?> destinationCollectionClass, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        try {
            Collection<T> collection = Json.parseArray(parser, destinationCollectionClass, destinationItemClass, customizeParser);
            return collection;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void parseArrayAndClose(JsonParser parser, Collection<? super T> destinationCollection, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        try {
            Json.parseArray(parser, destinationCollection, destinationItemClass, customizeParser);
        }
        finally {
            parser.close();
        }
    }

    public static <T> Collection<T> parseArray(JsonParser parser, Class<?> destinationCollectionClass, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        Collection destinationCollection = ClassInfo.newCollectionInstance(destinationCollectionClass);
        Json.parseArray(parser, destinationCollection, destinationItemClass, customizeParser);
        return destinationCollection;
    }

    public static <T> void parseArray(JsonParser parser, Collection<? super T> destinationCollection, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        JsonToken listToken;
        while ((listToken = parser.nextToken()) != JsonToken.END_ARRAY) {
            Object parsedValue = Json.parseValue(parser, listToken, null, destinationItemClass, destinationCollection, customizeParser);
            destinationCollection.add(parsedValue);
        }
    }

    private static void parseMap(JsonParser parser, Map<String, Object> destinationMap, Class<?> valueClass, CustomizeJsonParser customizeParser) throws IOException {
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String key = parser.getCurrentName();
            JsonToken curToken = parser.nextToken();
            if (customizeParser != null && customizeParser.stopAt(destinationMap, key)) {
                return;
            }
            Object value = Json.parseValue(parser, curToken, null, valueClass, destinationMap, customizeParser);
            destinationMap.put(key, value);
        }
    }

    private static Object parseValue(JsonParser parser, JsonToken token, Field field, Class<?> fieldClass, Object destination, CustomizeJsonParser customizeParser) throws IOException {
        switch (token) {
            case START_ARRAY: {
                if (fieldClass == null || Collection.class.isAssignableFrom(fieldClass)) {
                    Collection<Object> collectionValue = null;
                    if (customizeParser != null && field != null) {
                        collectionValue = customizeParser.newInstanceForArray(destination, field);
                    }
                    if (collectionValue == null) {
                        collectionValue = ClassInfo.newCollectionInstance(fieldClass);
                    }
                    Class subFieldClass = ClassInfo.getCollectionParameter((Field)field);
                    Json.parseArray(parser, collectionValue, subFieldClass, customizeParser);
                    return collectionValue;
                }
                throw new IllegalArgumentException("expected field type that implements Collection but got " + fieldClass + " for field " + field);
            }
            case START_OBJECT: {
                Class valueClass;
                boolean isMap;
                Object newInstance = null;
                boolean bl = isMap = fieldClass == null || Map.class.isAssignableFrom(fieldClass);
                if (fieldClass != null && customizeParser != null) {
                    newInstance = customizeParser.newInstanceForObject(destination, fieldClass);
                }
                if (newInstance == null) {
                    newInstance = isMap ? ClassInfo.newMapInstance(fieldClass) : ClassInfo.newInstance(fieldClass);
                }
                if (isMap && fieldClass != null && (valueClass = field != null ? ClassInfo.getMapValueParameter((Field)field) : ClassInfo.getMapValueParameter((Type)fieldClass.getGenericSuperclass())) != null) {
                    Map destinationMap = (Map)newInstance;
                    Json.parseMap(parser, destinationMap, valueClass, customizeParser);
                    return newInstance;
                }
                Json.parse(parser, newInstance, customizeParser);
                return newInstance;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                if (fieldClass != null && fieldClass != Boolean.class && fieldClass != Boolean.TYPE) {
                    throw new IllegalArgumentException(parser.getCurrentName() + ": expected type Boolean or boolean but got " + fieldClass + " for field " + field);
                }
                return token == JsonToken.VALUE_TRUE ? Boolean.TRUE : Boolean.FALSE;
            }
            case VALUE_NUMBER_FLOAT: {
                if (fieldClass != null && fieldClass != Float.class && fieldClass != Float.TYPE) {
                    throw new IllegalArgumentException(parser.getCurrentName() + ": expected type Float or float but got " + fieldClass + " for field " + field);
                }
                return Float.valueOf(parser.getFloatValue());
            }
            case VALUE_NUMBER_INT: {
                if (fieldClass == null || fieldClass == Integer.class || fieldClass == Integer.TYPE) {
                    return parser.getIntValue();
                }
                if (fieldClass == Short.class || fieldClass == Short.TYPE) {
                    return parser.getShortValue();
                }
                if (fieldClass == Byte.class || fieldClass == Byte.TYPE) {
                    return parser.getByteValue();
                }
                throw new IllegalArgumentException(parser.getCurrentName() + ": expected type Integer/int/Short/short/Byte/byte but got " + fieldClass + " for field " + field);
            }
            case VALUE_STRING: {
                try {
                    return FieldInfo.parsePrimitiveValue(fieldClass, (String)parser.getText());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(parser.getCurrentName() + " for field " + field, e);
                }
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException(parser.getCurrentName() + ": unexpected JSON node type: " + token);
    }
}

