/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.LowLevelHttpTransport;
import com.google.api.client.util.ArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpTransport {
    static final Logger LOGGER = Logger.getLogger(HttpTransport.class.getName());
    private static LowLevelHttpTransport lowLevelHttpTransport;
    public HttpHeaders defaultHeaders = new HttpHeaders();
    private final ArrayMap<String, HttpParser> contentTypeToParserMap = ArrayMap.create();
    public List<HttpExecuteIntercepter> intercepters = new ArrayList<HttpExecuteIntercepter>(1);

    public static void setLowLevelHttpTransport(LowLevelHttpTransport lowLevelHttpTransport) {
        HttpTransport.lowLevelHttpTransport = lowLevelHttpTransport;
    }

    public static LowLevelHttpTransport useLowLevelHttpTransport() {
        LowLevelHttpTransport lowLevelHttpTransportInterface = lowLevelHttpTransport;
        if (lowLevelHttpTransportInterface == null) {
            try {
                lowLevelHttpTransport = lowLevelHttpTransportInterface = (LowLevelHttpTransport)Class.forName("com.google.api.client.javanet.NetHttpTransport").getField("INSTANCE").get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to load NetHttpTrasnport");
            }
        }
        return lowLevelHttpTransportInterface;
    }

    public void addParser(HttpParser parser) {
        String contentType = this.getNormalizedContentType(parser.getContentType());
        this.contentTypeToParserMap.put((Object)contentType, (Object)parser);
    }

    public HttpParser getParser(String contentType) {
        if (contentType == null) {
            return null;
        }
        contentType = this.getNormalizedContentType(contentType);
        return (HttpParser)this.contentTypeToParserMap.get((Object)contentType);
    }

    private String getNormalizedContentType(String contentType) {
        int semicolon = contentType.indexOf(59);
        return semicolon == -1 ? contentType : contentType.substring(0, semicolon);
    }

    public HttpTransport() {
        HttpTransport.useLowLevelHttpTransport();
    }

    public HttpRequest buildRequest() {
        return new HttpRequest(this, null);
    }

    public HttpRequest buildDeleteRequest() {
        return new HttpRequest(this, "DELETE");
    }

    public HttpRequest buildGetRequest() {
        return new HttpRequest(this, "GET");
    }

    public HttpRequest buildPostRequest() {
        return new HttpRequest(this, "POST");
    }

    public HttpRequest buildPutRequest() {
        return new HttpRequest(this, "PUT");
    }

    public HttpRequest buildPatchRequest() {
        return new HttpRequest(this, "PATCH");
    }

    public HttpRequest buildHeadRequest() {
        return new HttpRequest(this, "HEAD");
    }

    public void removeIntercepters(Class<?> intercepterClass) {
        Iterator<HttpExecuteIntercepter> iterable = this.intercepters.iterator();
        while (iterable.hasNext()) {
            HttpExecuteIntercepter intercepter = iterable.next();
            if (!intercepterClass.isAssignableFrom(intercepter.getClass())) continue;
            iterable.remove();
        }
    }
}

