/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.batch;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartMixedContent
extends AbstractHttpContent {
    private static final String CR_LF = "\r\n";
    private static final String TWO_DASHES = "--";
    private List<BatchRequest.RequestInfo<?, ?>> requestInfos;
    private String boundary;

    MultipartMixedContent(List<BatchRequest.RequestInfo<?, ?>> requestInfos, String boundary) {
        Preconditions.checkNotNull(requestInfos);
        Preconditions.checkArgument((!requestInfos.isEmpty() ? 1 : 0) != 0);
        this.requestInfos = Collections.unmodifiableList(requestInfos);
        this.boundary = (String)Preconditions.checkNotNull((Object)boundary);
    }

    public String getType() {
        return "multipart/mixed; boundary=" + this.boundary;
    }

    public void writeTo(OutputStream out) throws IOException {
        int contentId = 1;
        OutputStreamWriter writer = new OutputStreamWriter(out);
        for (BatchRequest.RequestInfo<?, ?> requestInfo : this.requestInfos) {
            HttpRequest request = requestInfo.request;
            writer.write(TWO_DASHES);
            writer.write(this.boundary);
            writer.write(CR_LF);
            writer.write("Content-Type: application/http");
            writer.write(CR_LF);
            writer.write("Content-Transfer-Encoding: binary");
            writer.write(CR_LF);
            writer.write("Content-ID: ");
            writer.write(String.valueOf(contentId++));
            writer.write(CR_LF);
            writer.write(CR_LF);
            writer.write(request.getMethod().toString());
            writer.write(" ");
            writer.write(request.getUrl().build());
            writer.write(CR_LF);
            HttpHeaders.serializeHeadersForMultipartRequests((HttpHeaders)request.getHeaders(), null, null, (Writer)writer);
            HttpContent data = request.getContent();
            if (data != null) {
                this.writeHeader(writer, "Content-Type", data.getType());
                this.writeHeader(writer, "Content-Length", String.valueOf(data.getLength()));
                writer.write(CR_LF);
                ((Writer)writer).flush();
                data.writeTo(out);
            }
            writer.write(CR_LF);
        }
        writer.write(TWO_DASHES);
        writer.write(this.boundary);
        writer.write(TWO_DASHES);
        writer.write(CR_LF);
        ((Writer)writer).flush();
    }

    private void writeHeader(Writer writer, String name, String value) throws IOException {
        writer.write(name);
        writer.write(": ");
        writer.write(value);
        writer.write(CR_LF);
    }
}

