/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.jsontoken.JsonWebSignature;
import com.google.api.client.auth.jsontoken.JsonWebToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class GoogleIdToken
extends JsonWebSignature {
    public static GoogleIdToken parse(JsonFactory jsonFactory, String idTokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser((JsonFactory)jsonFactory).setPayloadClass(Payload.class).parse(idTokenString);
        return new GoogleIdToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    public GoogleIdToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, (JsonWebToken.Payload)payload, signatureBytes, signedContentBytes);
    }

    public boolean verify(GoogleIdTokenVerifier verifier) throws GeneralSecurityException, IOException {
        return verifier.verify(this);
    }

    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    public static class Payload
    extends JsonWebToken.Payload {
        @Key(value="id")
        private String userId;
        @Key(value="cid")
        private String issuee;
        @Key(value="token_hash")
        private String accessTokenHash;
        @Key(value="hd")
        private String hostedDomain;

        public String getUserId() {
            return this.userId;
        }

        public Payload setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public String getIssuee() {
            return this.issuee;
        }

        public Payload setIssuee(String issuee) {
            this.issuee = issuee;
            return this;
        }

        public String getAccessTokenHash() {
            return this.accessTokenHash;
        }

        public Payload setAccessTokenHash(String accessTokenHash) {
            this.accessTokenHash = accessTokenHash;
            return this;
        }

        public String getHostedDomain() {
            return this.hostedDomain;
        }

        public Payload setHostedDomain(String hostedDomain) {
            this.hostedDomain = hostedDomain;
            return this;
        }
    }
}

