/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.escape.CharEscapers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleUrl
extends GenericUrl {
    @Key
    public Boolean prettyprint;
    @Key
    public String alt;
    @Key
    public String fields;
    @Key
    public String key;
    @Key
    public String userip;

    public GoogleUrl() {
    }

    public GoogleUrl(String encodedUrl) {
        super(encodedUrl);
    }

    public GoogleUrl clone() {
        return (GoogleUrl)super.clone();
    }

    @Deprecated
    public static GoogleUrl create(String encodedServerUrl, String pathTemplate, Object parameters) throws IllegalArgumentException {
        GoogleUrl url = new GoogleUrl(encodedServerUrl);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        for (Map.Entry entry : Data.mapOf((Object)parameters).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            requestMap.put((String)entry.getKey(), value);
        }
        url.appendRawPath(GoogleUrl.expandUriTemplates(pathTemplate, requestMap));
        url.putAll(requestMap);
        return url;
    }

    @VisibleForTesting
    static String expandUriTemplates(String pathUri, HashMap<String, Object> variableMap) throws IllegalArgumentException {
        StringBuilder pathBuf = new StringBuilder();
        int cur = 0;
        int length = pathUri.length();
        while (cur < length) {
            int next = pathUri.indexOf(123, cur);
            if (next == -1) {
                pathBuf.append(pathUri.substring(cur));
                break;
            }
            pathBuf.append(pathUri.substring(cur, next));
            int close = pathUri.indexOf(125, next + 2);
            String varName = pathUri.substring(next + 1, close);
            cur = close + 1;
            Preconditions.checkArgument((variableMap != null ? 1 : 0) != 0, (String)"no variable map supplied for parameterize path: %s", (Object[])new Object[]{varName});
            Object value = variableMap.remove(varName);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"missing required path parameter: %s", (Object[])new Object[]{varName});
            pathBuf.append(CharEscapers.escapeUriPath((String)value.toString()));
        }
        return pathBuf.toString();
    }
}

