/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.clientlogin;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.auth.AuthKeyValueParser;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Key;
import java.io.IOException;

public final class ClientLogin {
    public HttpTransport transport;
    public GenericUrl serverUrl = new GenericUrl("https://www.google.com");
    @Key(value="source")
    public String applicationName;
    @Key(value="service")
    public String authTokenType;
    @Key(value="Email")
    public String username;
    @Key(value="Passwd")
    public String password;
    @Key
    public String accountType;
    @Key(value="logintoken")
    public String captchaToken;
    @Key(value="logincaptcha")
    public String captchaAnswer;

    public Response authenticate() throws HttpResponseException, IOException {
        GenericUrl url = this.serverUrl.clone();
        url.appendRawPath("/accounts/ClientLogin");
        HttpRequest request = this.transport.createRequestFactory().buildPostRequest(url, (HttpContent)new UrlEncodedContent((Object)this));
        request.addParser((HttpParser)AuthKeyValueParser.INSTANCE);
        request.setDisableContentLogging(true);
        return (Response)request.execute().parseAs(Response.class);
    }

    public static final class ErrorInfo {
        @Key(value="Error")
        public String error;
        @Key(value="Url")
        public String url;
        @Key(value="CaptchaToken")
        public String captchaToken;
        @Key(value="CaptchaUrl")
        public String captchaUrl;
    }

    public static final class Response
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        @Key(value="Auth")
        public String auth;

        public String getAuthorizationHeaderValue() {
            return GoogleHeaders.getGoogleLoginValue(this.auth);
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) {
            request.getHeaders().setAuthorization(this.getAuthorizationHeaderValue());
        }
    }
}

