/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.servlet.subscriptions;

import com.google.api.client.googleapis.subscriptions.StoredSubscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JdoSubscriptionStore
implements SubscriptionStore {
    private final PersistenceManagerFactory persistenceManagerFactory;

    public JdoSubscriptionStore(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = persistenceManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSubscription(StoredSubscription subscription) {
        Preconditions.checkNotNull((Object)subscription);
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscription.getId());
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            if (dbEntry != null) {
                dbEntry.setSubscription(subscription);
            } else {
                dbEntry = new JdoStoredSubscription(subscription);
                persistenceManager.makePersistent((Object)dbEntry);
            }
        }
        finally {
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(StoredSubscription subscription) {
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscription.getId());
        if (dbEntry != null) {
            PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
            try {
                persistenceManager.deletePersistent((Object)dbEntry);
            }
            finally {
                persistenceManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoredSubscription> listSubscriptions() {
        ArrayList list = Lists.newArrayList();
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            Query listQuery = persistenceManager.newQuery(JdoStoredSubscription.class);
            Iterable resultList = (Iterable)listQuery.execute();
            for (JdoStoredSubscription dbEntry : resultList) {
                list.add(dbEntry.getSubscription());
            }
        }
        finally {
            persistenceManager.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdoStoredSubscription getStoredSubscription(String subscriptionID) {
        Iterable results = null;
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            Query getByIDQuery = persistenceManager.newQuery(JdoStoredSubscription.class);
            getByIDQuery.setFilter("subscriptionId == idParam");
            getByIDQuery.declareParameters("String idParam");
            getByIDQuery.setRange(0L, 1L);
            results = (Iterable)getByIDQuery.execute((Object)subscriptionID);
            Iterator i$ = results.iterator();
            if (i$.hasNext()) {
                JdoStoredSubscription dbEntry;
                JdoStoredSubscription jdoStoredSubscription = dbEntry = (JdoStoredSubscription)i$.next();
                return jdoStoredSubscription;
            }
            JdoStoredSubscription jdoStoredSubscription = null;
            return jdoStoredSubscription;
        }
        finally {
            persistenceManager.close();
        }
    }

    public StoredSubscription getSubscription(String subscriptionID) {
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscriptionID);
        return dbEntry == null ? null : dbEntry.getSubscription();
    }

    @PersistenceCapable
    private static final class JdoStoredSubscription {
        @Persistent(serialized="true")
        private StoredSubscription subscription;
        @Persistent
        @PrimaryKey
        private String subscriptionId;

        JdoStoredSubscription() {
        }

        public JdoStoredSubscription(StoredSubscription s) {
            this.setSubscription(s);
        }

        public StoredSubscription getSubscription() {
            return this.subscription;
        }

        public String getSubscriptionId() {
            return this.subscriptionId;
        }

        public void setSubscription(StoredSubscription subscription) {
            this.subscription = subscription;
            this.subscriptionId = subscription.getId();
        }
    }
}

