/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.appengine.subscriptions;

import com.google.api.client.googleapis.subscriptions.StoredSubscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Lists;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class AppEngineSubscriptionStore
implements SubscriptionStore {
    private static final String KIND = AppEngineSubscriptionStore.class.getName();
    private static final String FIELD_SUBSCRIPTION = "serializedSubscription";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(baos).writeObject(obj);
            Blob blob = new Blob(baos.toByteArray());
            return blob;
        }
        finally {
            baos.close();
        }
    }

    private <T> T deserialize(Blob data, Class<T> dataType) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes());
        try {
            Object obj = new ObjectInputStream(bais).readObject();
            if (!dataType.isAssignableFrom(obj.getClass())) {
                T t = null;
                return t;
            }
            Object object = obj;
            return (T)object;
        }
        catch (ClassNotFoundException exception) {
            throw new IOException("Failed to deserialize object", exception);
        }
        finally {
            bais.close();
        }
    }

    private StoredSubscription getSubscriptionFromEntity(Entity entity) throws IOException {
        Blob serializedSubscription = (Blob)entity.getProperty(FIELD_SUBSCRIPTION);
        return this.deserialize(serializedSubscription, StoredSubscription.class);
    }

    public void storeSubscription(StoredSubscription subscription) throws IOException {
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        Entity entity = new Entity(KIND, subscription.getId());
        entity.setProperty(FIELD_SUBSCRIPTION, (Object)this.serialize(subscription));
        service.put(entity);
    }

    public void removeSubscription(StoredSubscription subscription) throws IOException {
        if (subscription == null) {
            return;
        }
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        service.delete(new Key[]{KeyFactory.createKey((String)KIND, (String)subscription.getId())});
    }

    public List<StoredSubscription> listSubscriptions() throws IOException {
        ArrayList list = Lists.newArrayList();
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        PreparedQuery results = service.prepare(new Query(KIND));
        for (Entity entity : results.asIterable()) {
            list.add(this.getSubscriptionFromEntity(entity));
        }
        return list;
    }

    public StoredSubscription getSubscription(String subscriptionId) throws IOException {
        try {
            DatastoreService service = DatastoreServiceFactory.getDatastoreService();
            Entity entity = service.get(KeyFactory.createKey((String)KIND, (String)subscriptionId));
            return this.getSubscriptionFromEntity(entity);
        }
        catch (EntityNotFoundException exception) {
            return null;
        }
    }
}

