/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.android.gms.auth;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.AccountPicker;
import com.google.api.client.googleapis.extensions.android.accounts.GoogleAccountManager;
import com.google.api.client.googleapis.extensions.android.gms.auth.GoogleAuthIOException;
import com.google.api.client.googleapis.extensions.android.gms.auth.GooglePlayServicesAvailabilityIOException;
import com.google.api.client.googleapis.extensions.android.gms.auth.UserRecoverableAuthIOException;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class GoogleAccountCredential
implements HttpRequestInitializer {
    final Context context;
    final String scope;
    private final GoogleAccountManager accountManager;
    private String accountName;
    private Account selectedAccount;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private BackOff backOff;

    public GoogleAccountCredential(Context context, String scope) {
        this.accountManager = new GoogleAccountManager(context);
        this.context = context;
        this.scope = scope;
    }

    public static GoogleAccountCredential usingOAuth2(Context context, Collection<String> scopes) {
        Preconditions.checkArgument((scopes != null && scopes.iterator().hasNext() ? 1 : 0) != 0);
        String scopesStr = "oauth2: " + Joiner.on((char)' ').join(scopes);
        return new GoogleAccountCredential(context, scopesStr);
    }

    public static GoogleAccountCredential usingAudience(Context context, String audience) {
        Preconditions.checkArgument((audience.length() != 0 ? 1 : 0) != 0);
        return new GoogleAccountCredential(context, "audience:" + audience);
    }

    public final GoogleAccountCredential setSelectedAccountName(String accountName) {
        this.selectedAccount = this.accountManager.getAccountByName(accountName);
        this.accountName = this.selectedAccount == null ? null : accountName;
        return this;
    }

    public void initialize(HttpRequest request) {
        RequestHandler handler = new RequestHandler();
        request.setInterceptor((HttpExecuteInterceptor)handler);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)handler);
    }

    public final Context getContext() {
        return this.context;
    }

    public final String getScope() {
        return this.scope;
    }

    public final GoogleAccountManager getGoogleAccountManager() {
        return this.accountManager;
    }

    public final Account[] getAllAccounts() {
        return this.accountManager.getAccounts();
    }

    public final Account getSelectedAccount() {
        return this.selectedAccount;
    }

    public BackOff getBackOff() {
        return this.backOff;
    }

    public GoogleAccountCredential setBackOff(BackOff backOff) {
        this.backOff = backOff;
        return this;
    }

    public final Sleeper getSleeper() {
        return this.sleeper;
    }

    public final GoogleAccountCredential setSleeper(Sleeper sleeper) {
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
        return this;
    }

    public final String getSelectedAccountName() {
        return this.accountName;
    }

    public final Intent newChooseAccountIntent() {
        return AccountPicker.newChooseAccountIntent((Account)this.selectedAccount, null, (String[])new String[]{"com.google"}, (boolean)true, null, null, null, null);
    }

    public String getToken() throws IOException, GoogleAuthException {
        if (this.backOff != null) {
            this.backOff.reset();
        }
        while (true) {
            try {
                return GoogleAuthUtil.getToken((Context)this.context, (String)this.accountName, (String)this.scope);
            }
            catch (IOException e) {
                try {
                    if (this.backOff != null && BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.backOff)) continue;
                    throw e;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    @Beta
    class RequestHandler
    implements HttpExecuteInterceptor,
    HttpUnsuccessfulResponseHandler {
        boolean received401;
        String token;

        RequestHandler() {
        }

        public void intercept(HttpRequest request) throws IOException {
            try {
                this.token = GoogleAccountCredential.this.getToken();
                request.getHeaders().setAuthorization("Bearer " + this.token);
            }
            catch (GooglePlayServicesAvailabilityException e) {
                throw new GooglePlayServicesAvailabilityIOException(e);
            }
            catch (UserRecoverableAuthException e) {
                throw new UserRecoverableAuthIOException(e);
            }
            catch (GoogleAuthException e) {
                throw new GoogleAuthIOException(e);
            }
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
            if (response.getStatusCode() == 401 && !this.received401) {
                this.received401 = true;
                GoogleAuthUtil.invalidateToken((Context)GoogleAccountCredential.this.context, (String)this.token);
                return true;
            }
            return false;
        }
    }
}

