/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.datamanager.v1.stub;

import com.google.ads.datamanager.v1.IngestAudienceMembersRequest;
import com.google.ads.datamanager.v1.IngestAudienceMembersResponse;
import com.google.ads.datamanager.v1.IngestEventsRequest;
import com.google.ads.datamanager.v1.IngestEventsResponse;
import com.google.ads.datamanager.v1.RemoveAudienceMembersRequest;
import com.google.ads.datamanager.v1.RemoveAudienceMembersResponse;
import com.google.ads.datamanager.v1.RetrieveRequestStatusRequest;
import com.google.ads.datamanager.v1.RetrieveRequestStatusResponse;
import com.google.ads.datamanager.v1.stub.GrpcIngestionServiceStub;
import com.google.ads.datamanager.v1.stub.HttpJsonIngestionServiceStub;
import com.google.ads.datamanager.v1.stub.IngestionServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IngestionServiceStubSettings
extends StubSettings<IngestionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/datamanager").build();
    private final UnaryCallSettings<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersSettings;
    private final UnaryCallSettings<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersSettings;
    private final UnaryCallSettings<IngestEventsRequest, IngestEventsResponse> ingestEventsSettings;
    private final UnaryCallSettings<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusSettings;

    public UnaryCallSettings<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersSettings() {
        return this.ingestAudienceMembersSettings;
    }

    public UnaryCallSettings<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersSettings() {
        return this.removeAudienceMembersSettings;
    }

    public UnaryCallSettings<IngestEventsRequest, IngestEventsResponse> ingestEventsSettings() {
        return this.ingestEventsSettings;
    }

    public UnaryCallSettings<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusSettings() {
        return this.retrieveRequestStatusSettings;
    }

    public IngestionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIngestionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIngestionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datamanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "datamanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datamanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IngestionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IngestionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IngestionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IngestionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IngestionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.ingestAudienceMembersSettings = settingsBuilder.ingestAudienceMembersSettings().build();
        this.removeAudienceMembersSettings = settingsBuilder.removeAudienceMembersSettings().build();
        this.ingestEventsSettings = settingsBuilder.ingestEventsSettings().build();
        this.retrieveRequestStatusSettings = settingsBuilder.retrieveRequestStatusSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IngestionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersSettings;
        private final UnaryCallSettings.Builder<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersSettings;
        private final UnaryCallSettings.Builder<IngestEventsRequest, IngestEventsResponse> ingestEventsSettings;
        private final UnaryCallSettings.Builder<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.ingestAudienceMembersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAudienceMembersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.ingestEventsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.retrieveRequestStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.ingestAudienceMembersSettings, this.removeAudienceMembersSettings, this.ingestEventsSettings, this.retrieveRequestStatusSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IngestionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.ingestAudienceMembersSettings = settings.ingestAudienceMembersSettings.toBuilder();
            this.removeAudienceMembersSettings = settings.removeAudienceMembersSettings.toBuilder();
            this.ingestEventsSettings = settings.ingestEventsSettings.toBuilder();
            this.retrieveRequestStatusSettings = settings.retrieveRequestStatusSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.ingestAudienceMembersSettings, this.removeAudienceMembersSettings, this.ingestEventsSettings, this.retrieveRequestStatusSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IngestionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IngestionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IngestionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IngestionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IngestionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IngestionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IngestionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IngestionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.ingestAudienceMembersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.removeAudienceMembersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.ingestEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.retrieveRequestStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersSettings() {
            return this.ingestAudienceMembersSettings;
        }

        public UnaryCallSettings.Builder<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersSettings() {
            return this.removeAudienceMembersSettings;
        }

        public UnaryCallSettings.Builder<IngestEventsRequest, IngestEventsResponse> ingestEventsSettings() {
            return this.ingestEventsSettings;
        }

        public UnaryCallSettings.Builder<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusSettings() {
            return this.retrieveRequestStatusSettings;
        }

        public IngestionServiceStubSettings build() throws IOException {
            return new IngestionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

