/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.datamanager.v1.stub;

import com.google.ads.datamanager.v1.IngestAudienceMembersRequest;
import com.google.ads.datamanager.v1.IngestAudienceMembersResponse;
import com.google.ads.datamanager.v1.IngestEventsRequest;
import com.google.ads.datamanager.v1.IngestEventsResponse;
import com.google.ads.datamanager.v1.RemoveAudienceMembersRequest;
import com.google.ads.datamanager.v1.RemoveAudienceMembersResponse;
import com.google.ads.datamanager.v1.RetrieveRequestStatusRequest;
import com.google.ads.datamanager.v1.RetrieveRequestStatusResponse;
import com.google.ads.datamanager.v1.stub.GrpcIngestionServiceCallableFactory;
import com.google.ads.datamanager.v1.stub.IngestionServiceStub;
import com.google.ads.datamanager.v1.stub.IngestionServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIngestionServiceStub
extends IngestionServiceStub {
    private static final MethodDescriptor<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.datamanager.v1.IngestionService/IngestAudienceMembers").setRequestMarshaller(ProtoUtils.marshaller((Message)IngestAudienceMembersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IngestAudienceMembersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.datamanager.v1.IngestionService/RemoveAudienceMembers").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveAudienceMembersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RemoveAudienceMembersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<IngestEventsRequest, IngestEventsResponse> ingestEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.datamanager.v1.IngestionService/IngestEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)IngestEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IngestEventsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.datamanager.v1.IngestionService/RetrieveRequestStatus").setRequestMarshaller(ProtoUtils.marshaller((Message)RetrieveRequestStatusRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RetrieveRequestStatusResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersCallable;
    private final UnaryCallable<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersCallable;
    private final UnaryCallable<IngestEventsRequest, IngestEventsResponse> ingestEventsCallable;
    private final UnaryCallable<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIngestionServiceStub create(IngestionServiceStubSettings settings) throws IOException {
        return new GrpcIngestionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIngestionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIngestionServiceStub(IngestionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIngestionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIngestionServiceStub(IngestionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIngestionServiceStub(IngestionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIngestionServiceCallableFactory());
    }

    protected GrpcIngestionServiceStub(IngestionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings ingestAudienceMembersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(ingestAudienceMembersMethodDescriptor).build();
        GrpcCallSettings removeAudienceMembersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeAudienceMembersMethodDescriptor).build();
        GrpcCallSettings ingestEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(ingestEventsMethodDescriptor).build();
        GrpcCallSettings retrieveRequestStatusTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(retrieveRequestStatusMethodDescriptor).build();
        this.ingestAudienceMembersCallable = callableFactory.createUnaryCallable(ingestAudienceMembersTransportSettings, settings.ingestAudienceMembersSettings(), clientContext);
        this.removeAudienceMembersCallable = callableFactory.createUnaryCallable(removeAudienceMembersTransportSettings, settings.removeAudienceMembersSettings(), clientContext);
        this.ingestEventsCallable = callableFactory.createUnaryCallable(ingestEventsTransportSettings, settings.ingestEventsSettings(), clientContext);
        this.retrieveRequestStatusCallable = callableFactory.createUnaryCallable(retrieveRequestStatusTransportSettings, settings.retrieveRequestStatusSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<IngestAudienceMembersRequest, IngestAudienceMembersResponse> ingestAudienceMembersCallable() {
        return this.ingestAudienceMembersCallable;
    }

    @Override
    public UnaryCallable<RemoveAudienceMembersRequest, RemoveAudienceMembersResponse> removeAudienceMembersCallable() {
        return this.removeAudienceMembersCallable;
    }

    @Override
    public UnaryCallable<IngestEventsRequest, IngestEventsResponse> ingestEventsCallable() {
        return this.ingestEventsCallable;
    }

    @Override
    public UnaryCallable<RetrieveRequestStatusRequest, RetrieveRequestStatusResponse> retrieveRequestStatusCallable() {
        return this.retrieveRequestStatusCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

